/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.utilities.xml;

import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.utilities.xml.XMLNamespace;
import org.eclipse.ohf.utilities.xml.XMLWriterState;
import org.eclipse.ohf.utilities.xml.XMLWriterStateStack;

public class XMLWriter
extends OutputStreamWriter {
    private boolean xmlHeader = true;
    private String charset;
    private boolean pretty;
    private boolean pendingClose;
    private boolean pendingOpen;
    private String pendingComment;
    private int lineType = 0;
    private OutputStream stream;
    private boolean started = false;
    public static final int LINE_UNIX = 0;
    public static final int LINE_WINDOWS = 1;
    private String[][] attributes;
    private XMLWriterStateStack levels = new XMLWriterStateStack();

    public XMLWriter(OutputStream stream, String charset) throws UnsupportedEncodingException {
        super(stream, charset);
        this.stream = stream;
        this.charset = charset;
    }

    public static String escapeXML(String rawContent) {
        if (rawContent == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < rawContent.length()) {
            char ch = rawContent.charAt(i);
            if (ch == '\'') {
                sb.append("&#39;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else if (ch == '\"') {
                sb.append("&quot;");
            } else if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch > '~') {
                sb.append("&#x" + Integer.toHexString(new Character(ch).hashCode()).toUpperCase() + ";");
            } else {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public static String escapeXMLAndLines(String rawContent) {
        if (rawContent == null) {
            return "";
        }
        StringBuffer sb = new StringBuffer();
        int i = 0;
        while (i < rawContent.length()) {
            char ch = rawContent.charAt(i);
            if (ch == '\'') {
                sb.append("&#39;");
            } else if (ch == '&') {
                sb.append("&amp;");
            } else if (ch == '\"') {
                sb.append("&quot;");
            } else if (ch == '<') {
                sb.append("&lt;");
            } else if (ch == '>') {
                sb.append("&gt;");
            } else if (ch > '~') {
                sb.append("&#x" + Integer.toHexString(new Character(ch).hashCode()).toUpperCase() + ";");
            } else if (ch == '\r') {
                sb.append("&#xA;");
            } else if (ch != '\n') {
                sb.append(ch);
            }
            ++i;
        }
        return sb.toString();
    }

    public boolean condition(boolean bTest, String message) throws IOException {
        if (!bTest) {
            throw new IOException(message);
        }
        return bTest;
    }

    public static String getXMLCharsetName(String charset) throws IOException {
        if (charset == null || charset.equals("")) {
            return "UTF-8";
        }
        if (charset.equals("US-ASCII")) {
            return "UTF-8";
        }
        if (charset.equals("ISO-8859-1")) {
            return "ISO-8859-1";
        }
        if (charset.equals("UTF-8")) {
            return "UTF-8";
        }
        if (charset.equals("UTF-16") || charset.equals("UTF-16BE") || charset.equals("UTF-16LE")) {
            return "UTF-16";
        }
        throw new IOException("Unknown charset encoding " + charset);
    }

    public void start() throws IOException {
        this.condition(!this.started, "attempt to start after starting");
        this.levels.clear();
        this.attributes = null;
        try {
            if (this.xmlHeader) {
                this.write("<?xml version=\"1.0\" encoding=\"" + XMLWriter.getXMLCharsetName(this.charset) + "\"?>");
                if (!this.pretty) {
                    this.write(this.lineType == 0 ? "\n" : "\r\n");
                }
            }
        }
        catch (UnsupportedEncodingException e) {
            throw new IOException(e.getMessage());
        }
        this.started = true;
    }

    private void checkStarted() throws IOException {
        this.condition(this.started, "not started");
    }

    private void checkInElement() throws IOException {
        this.condition(this.levels.size() > 0, "not in an element");
    }

    private void addAttribute(String name, String value) throws IOException {
        this.newLevelIfRequired();
        value = XMLWriter.escapeXML(value);
        if (this.attributes == null) {
            this.attributes = new String[][]{{name, value}};
        } else {
            String[][] newattr = new String[this.attributes.length + 1][];
            int i = 0;
            while (i < this.attributes.length) {
                this.condition(!this.attributes[i][0].equals(name), "attempt to define attribute with name " + name + " more than once");
                newattr[i] = this.attributes[i];
                ++i;
            }
            this.attributes = newattr;
            this.attributes[this.attributes.length - 1] = new String[]{name, value};
        }
    }

    private void addAttributeNoLines(String name, String value) throws IOException {
        this.newLevelIfRequired();
        value = XMLWriter.escapeXMLAndLines(value);
        if (this.attributes == null) {
            this.attributes = new String[][]{{name, value}};
        } else {
            String[][] newattr = new String[this.attributes.length + 1][];
            int i = 0;
            while (i < this.attributes.length) {
                this.condition(!this.attributes[i][0].equals(name), "attempt to define attribute with name " + name + " more than once");
                newattr[i] = this.attributes[i];
                ++i;
            }
            this.attributes = newattr;
            this.attributes[this.attributes.length - 1] = new String[]{name, value};
        }
    }

    private void writeAttributes() throws IOException {
        if (this.attributes != null) {
            int i = 0;
            while (i < this.attributes.length) {
                String[] element = this.attributes[i];
                this.write(32);
                this.write(element[0]);
                this.write("=\"");
                if (element[1] != null) {
                    this.write(element[1]);
                }
                this.write("\"");
                ++i;
            }
        }
        this.attributes = null;
    }

    public void attribute(String namespace, String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(namespace, name, value);
        }
    }

    public void attribute(String namespace, String name, String value) throws IOException {
        this.checkStarted();
        if (namespace == null || namespace.equals("")) {
            this.addAttribute(name, value);
        } else {
            this.addAttribute(String.valueOf(this.getNSAbbreviation(namespace)) + name, value);
        }
    }

    public void attribute(String name, String value, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || value != null && !value.equals("")) {
            this.attribute(name, value);
        }
    }

    public void attribute(String name, String value) throws IOException {
        this.checkStarted();
        this.addAttribute(name, value);
    }

    public void attributeNoLines(String name, String value) throws IOException {
        this.checkStarted();
        this.addAttributeNoLines(name, value);
    }

    private void newLevelIfRequired() throws IOException {
        if (!this.pendingOpen) {
            if (!this.levels.empty()) {
                this.levels.current().seeChild();
            }
            XMLWriterState level = new XMLWriterState();
            this.levels.push(level);
            this.pendingOpen = true;
        }
    }

    private void defineNamespace(String namespace, String abbrev) throws IOException {
        this.checkStarted();
        if (namespace != null) {
            if (abbrev.equals("")) {
                abbrev = null;
            }
            this.newLevelIfRequired();
            this.levels.current().addNamespaceDefn(namespace, abbrev);
            if (abbrev == null) {
                this.addAttribute("xmlns", namespace);
            } else {
                this.addAttribute("xmlns:" + abbrev, namespace);
            }
        }
    }

    public XMLNamespace findByNamespace(String namespace) {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefnByNamespace(namespace);
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    public boolean namespaceDefined(String namespace) {
        return this.findByNamespace(namespace) != null;
    }

    public XMLNamespace findByAbbreviation(String abbreviation) {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefnByAbbreviation(abbreviation);
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    public boolean abbreviationDefined(String abbreviation) {
        return this.findByAbbreviation(abbreviation) != null;
    }

    public XMLNamespace findDefaultNamespace() {
        int i = this.levels.size() - 1;
        while (i >= 0) {
            XMLNamespace ns = this.levels.item(i).getDefaultNamespace();
            if (ns != null) {
                return ns;
            }
            --i;
        }
        return null;
    }

    public String getDefaultNamespace() {
        XMLNamespace ns = this.findDefaultNamespace();
        if (ns == null) {
            return null;
        }
        return ns.getNamespace();
    }

    public void namespace(String namespace) throws IOException {
        if (!this.namespaceDefined(namespace)) {
            int index = 0;
            while (this.abbreviationDefined("ns" + Integer.toString(index))) {
                ++index;
            }
            this.defineNamespace(namespace, "ns" + Integer.toString(index));
        }
    }

    public void defaultNamespace(String namespace) throws IOException {
        if (!namespace.equals(this.getDefaultNamespace())) {
            this.defineNamespace(namespace, "");
        }
    }

    public void namespace(String namespace, String abbreviation) throws IOException {
        XMLNamespace ns = this.findByAbbreviation(abbreviation);
        if (ns == null || !ns.getNamespace().equals(namespace)) {
            this.defineNamespace(namespace, abbreviation);
        }
    }

    private String getNSAbbreviation(String namespace) throws IOException {
        XMLNamespace ns = this.findByNamespace(namespace);
        if (ns == null) {
            throw new IOException("Namespace " + namespace + " is not defined");
        }
        if (ns.getAbbreviation() == null) {
            return "";
        }
        return String.valueOf(ns.getAbbreviation()) + ":";
    }

    public void comment(String comment) throws IOException {
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        this.writePretty();
        this.write("<!-- " + comment + " -->");
    }

    private void writePendingComment() throws IOException {
        if (this.pendingComment != null) {
            if (this.pretty) {
                this.write("   ");
            }
            this.write("<!-- " + this.pendingComment + " -->");
        }
    }

    public void open(String namespace, String name) throws IOException {
        this.open(namespace, name, null);
    }

    public void open(String namespace, String name, String comment) throws IOException {
        this.checkStarted();
        if (this.pendingClose) {
            this.write(62);
            this.writePendingComment();
            this.pendingClose = false;
        }
        if (name == null) {
            throw new IOException("name is null");
        }
        this.newLevelIfRequired();
        this.levels.current().setName(name);
        this.levels.current().setNamespace(namespace);
        this.writePretty();
        this.write(60);
        if (namespace == null) {
            this.write(name);
        } else {
            this.write(String.valueOf(this.getNSAbbreviation(namespace)) + name);
        }
        this.writeAttributes();
        this.pendingOpen = false;
        this.pendingClose = true;
        this.pendingComment = comment;
    }

    public void close(String name) throws IOException, IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close null|" + name + ", nothing to close");
        }
        if (this.levels.current().getNamespace() != null || !this.levels.current().getName().equals(name)) {
            throw new IOException("Unable to close null|" + name + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    public void close(String namespace, String name) throws IOException, IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            throw new IOException("Unable to close " + namespace + "|" + name + ", nothing to close");
        }
        if (!this.levels.current().getNamespace().equals(namespace) || !this.levels.current().getName().equals(name)) {
            throw new IOException("Unable to close " + namespace + "|" + name + ", found " + this.levels.current().getNamespace() + "|" + this.levels.current().getName());
        }
        this.close();
    }

    public void closeToLevel(int count) throws IOException {
        while (this.levels.size() > count) {
            this.close();
        }
    }

    public void close() throws IOException {
        this.checkStarted();
        if (this.levels.empty()) {
            super.close();
        } else {
            if (this.pendingClose) {
                this.write("/>");
                this.writePendingComment();
                this.pendingClose = false;
            } else {
                if (this.levels.current().hasChildren()) {
                    this.writePretty();
                }
                this.write("</");
                if (this.levels.current().getNamespace() == null) {
                    this.write(this.levels.current().getName());
                } else {
                    this.write(String.valueOf(this.getNSAbbreviation(this.levels.current().getNamespace())) + this.levels.current().getName());
                }
                this.write(62);
            }
            this.levels.pop();
        }
    }

    public void open(String name) throws IOException {
        this.open(null, name);
    }

    public void element(String namespace, String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(namespace, name, content);
        }
    }

    public void element(String namespace, String name, String content, String comment) throws IOException {
        this.open(namespace, name, comment);
        this.text(content);
        this.close();
    }

    public void element(String namespace, String name, String content) throws IOException {
        this.open(namespace, name);
        this.text(content);
        this.close();
    }

    public void element(String name, String content, boolean onlyIfNotEmpty) throws IOException {
        if (!onlyIfNotEmpty || content != null && !content.equals("")) {
            this.element(null, name, content);
        }
    }

    public void element(String name, String content) throws IOException {
        this.element(null, name, content);
    }

    public void text(String content) throws IOException {
        this.checkInElement();
        if (content != null) {
            if (this.pendingClose) {
                this.write(">");
                this.writePendingComment();
                this.pendingClose = false;
            }
            this.write(XMLWriter.escapeXML(content));
        }
    }

    public void escapedText(String content) throws IOException {
        this.checkInElement();
        if (this.pendingClose) {
            this.write(">");
            this.writePendingComment();
            this.pendingClose = false;
        }
        this.write(content);
    }

    public void writeBytes(byte[] bytes) throws IOException {
        this.checkInElement();
        if (this.pendingClose) {
            this.write(">");
            this.writePendingComment();
            this.pendingClose = false;
        }
        this.flush();
        this.stream.write(bytes);
    }

    public boolean isPretty() {
        return this.pretty;
    }

    public void setPretty(boolean pretty) {
        this.pretty = pretty;
    }

    private void writePretty() throws IOException {
        if (this.pretty) {
            this.write(this.lineType == 0 ? "\n" : "\r\n");
            int i = 0;
            while (i < this.levels.size() - 1) {
                this.write("  ");
                ++i;
            }
        }
    }

    public int getLineType() {
        return this.lineType;
    }

    public void setLineType(int lineType) {
        this.lineType = lineType;
    }

    public boolean isXmlHeader() {
        return this.xmlHeader;
    }

    public void setXmlHeader(boolean xmlHeader) {
        this.xmlHeader = xmlHeader;
    }
}

