/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentRoot;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.util.MetadataResourceFactoryImpl;

public class InputStreamDocumentEntryExtractor
implements DocumentEntryExtractor {
    public static final String DESCRIPTOR = "STREAM_DE_EXTR";
    private static final Logger logger;
    private InputStream documentEntryInputStream;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.InputStreamDocumentEntryExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public InputStreamDocumentEntryExtractor(InputStream documentEntryInputStream) {
        this.documentEntryInputStream = documentEntryInputStream;
    }

    public DocumentEntryType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading MetadataPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new MetadataResourceFactoryImpl().createResource(URI.createURI((String)"urn:org:eclipse:ohf:ihe:xds:metadata"));
        try {
            resource.load(this.documentEntryInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating DocumentEntry metadata with object from InputStream " + this.documentEntryInputStream));
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        DocumentEntryType documentEntry = root.getDocumentEntry();
        return documentEntry;
    }
}

