/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit;

import java.io.IOException;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ExportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ImportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.QueryMessage;
import org.eclipse.ohf.ihe.atna.audit.syslog.bsd.BSDClient;
import org.eclipse.ohf.ihe.atna.audit.syslog.bsd.BSDMessage;

public class AuditService {
    private String hostname = "";
    private URI hosturi = null;
    private boolean doAudit = true;
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.audit.AuditService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public AuditMessage eventPending(String eventType) {
        AuditMessage auditmsg = null;
        if (eventType.equalsIgnoreCase("import")) {
            try {
                auditmsg = new ImportMessage();
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
            }
            catch (FactoryConfigurationError e) {
                logger.error((Object)e);
            }
            catch (ATNAException e) {
                logger.error((Object)e);
            }
        } else if (eventType.equalsIgnoreCase("export")) {
            try {
                auditmsg = new ExportMessage();
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
            }
            catch (FactoryConfigurationError e) {
                logger.error((Object)e);
            }
            catch (ATNAException e) {
                logger.error((Object)e);
            }
        } else if (eventType.equalsIgnoreCase("query")) {
            try {
                auditmsg = new QueryMessage();
            }
            catch (ParserConfigurationException e) {
                logger.error((Object)e);
            }
            catch (FactoryConfigurationError e) {
                logger.error((Object)e);
            }
            catch (ATNAException e) {
                logger.error((Object)e);
            }
        }
        return auditmsg;
    }

    public void eventTriggered(AuditMessage auditMessage) {
        BSDClient client = null;
        if (!this.isDoAudit()) {
            logger.warn((Object)"ATNA Audit is disabled. No Message was sent to the Audit Repository");
            return;
        }
        try {
            int port = 515;
            if (this.getHostname().equalsIgnoreCase("") && this.getAuditRepository() == null) {
                logger.error((Object)"Audit Repository not set. Please use org.eclipse.ohf.ihe.atna.agent.AtnaAgent.setAuditRepository(URI) to set it. No message was sent to the respository");
                return;
            }
            URI uri = this.getAuditRepository();
            this.setHostname(uri.getHost());
            port = uri.getPort();
            client = new BSDClient(this.getHostname(), port);
            InetAddress addr = InetAddress.getLocalHost();
            addr.getAddress();
            addr.getHostName();
            String cannonicalHost = addr.getCanonicalHostName();
            String msg = auditMessage.toXml();
            BSDMessage bsdMessage = new BSDMessage(cannonicalHost, "", "<?xml version=\"1.0\" encoding=\"ASCII\"?>" + msg);
            logger.info((Object)bsdMessage.toString());
            client.sendMessage(bsdMessage);
        }
        catch (UnknownHostException e) {
            logger.error((Object)("Audit message could not be sent to ATNA Audit Repository. " + e.getLocalizedMessage()), (Throwable)e);
        }
        catch (FactoryConfigurationError e) {
            logger.error((Object)("Audit message could not be sent to ATNA Audit Repository. " + e.getLocalizedMessage()), (Throwable)e);
        }
        catch (IOException e) {
            logger.error((Object)("Audit message could not be sent to ATNA Audit Repository. " + e.getLocalizedMessage()), (Throwable)e);
        }
        catch (Exception e) {
            logger.error((Object)("Audit message could not be sent to ATNA Audit Repository. " + e.getLocalizedMessage()), (Throwable)e);
        }
    }

    public void setHostname(String hostname) {
        this.hostname = hostname;
    }

    public String getHostname() {
        return this.hostname;
    }

    public void setAuditRepository(URI hosturi) {
        this.hosturi = hosturi;
    }

    public URI getAuditRepository() {
        return this.hosturi;
    }

    public void setDoAudit(boolean doAudit) {
        this.doAudit = doAudit;
    }

    public boolean isDoAudit() {
        return this.doAudit;
    }
}

