/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventTypeCode;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;

public class ActorStopMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ActorStopMessage(String eventDateTime, int eventOutcomeIndicator, String applicationName) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this(eventDateTime, eventOutcomeIndicator, applicationName, new String[0]);
    }

    public ActorStopMessage(String eventDateTime, int eventOutcomeIndicator, String applicationName, String userOrProcessName) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this(eventDateTime, eventOutcomeIndicator, applicationName, new String[]{userOrProcessName});
    }

    public ActorStopMessage(String eventDateTime, int eventOutcomeIndicator, String applicationName, String[] userOrProcessName) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.logger.debug((Object)"Starting Audit stop messages [1]");
        EventIdentificationType eventId = new EventIdentificationType();
        eventId.setEventActionCode("E");
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        eventId.setEventID(new AuditEventID.ApplicationActivity());
        eventId.setEventTypeCode(new AuditEventTypeCode.ApplicationStop());
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantApplicationID = null;
        activeParticipantApplicationID = new ActiveParticipantType(applicationName);
        activeParticipantApplicationID.setUserIsRequestor(false);
        activeParticipantApplicationID.setRoleIDCode(new AuditActiveParticipantRoleID.Application());
        this.setActiveParticipant(activeParticipantApplicationID);
        int i = 0;
        while (i < userOrProcessName.length) {
            ActiveParticipantType applicationUser = null;
            applicationUser = new ActiveParticipantType(userOrProcessName[i]);
            applicationUser.setUserIsRequestor(true);
            applicationUser.setRoleIDCode(new AuditActiveParticipantRoleID.ApplicationLauncher());
            this.setActiveParticipant(applicationUser);
            ++i;
        }
    }
}

