/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.format;

import java.util.ArrayList;

public class HL7V2MessageUtils {
    public static void trimDelimiters(StringBuffer msg, char delimiter) {
        int count = msg.length() - 1;
        while (msg.charAt(count) == delimiter) {
            msg.deleteCharAt(count);
            if (--count < 0) break;
        }
    }

    public static void trimDelimiters(StringBuffer msg, char delimiter, char subdelimiter) {
        int count = msg.length() - 1;
        while (msg.charAt(count) == delimiter || msg.charAt(count) == subdelimiter) {
            msg.deleteCharAt(count);
            if (--count < 0) break;
        }
    }

    public static void trimDelimiters(StringBuffer msg, char subcomponent, char component, char field, char repetition) {
        int count = msg.length() - 1;
        while (msg.charAt(count) == subcomponent || msg.charAt(count) == component || msg.charAt(count) == field || msg.charAt(count) == repetition) {
            msg.deleteCharAt(count);
            if (--count < 0) break;
        }
    }

    public static ArrayList parse(String msg, char delimiter) {
        ArrayList<String> components = new ArrayList<String>();
        if (msg == null) {
            return components;
        }
        StringBuffer buf = new StringBuffer(msg);
        char previous = delimiter;
        while (buf.length() > 0) {
            if (buf.charAt(0) != delimiter && previous == delimiter) {
                StringBuffer componentI = new StringBuffer();
                while (buf.length() > 0 && buf.charAt(0) != delimiter) {
                    componentI.append(buf.charAt(0));
                    previous = buf.charAt(0);
                    buf.deleteCharAt(0);
                }
                components.add(componentI.toString());
            } else {
                components.add("");
            }
            if (buf.length() <= 0) continue;
            previous = buf.charAt(0);
            buf.deleteCharAt(0);
        }
        return components;
    }
}

