/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.hl7v2.util;

import java.util.Map;
import org.eclipse.emf.common.util.DiagnosticChain;
import org.eclipse.emf.ecore.EPackage;
import org.eclipse.emf.ecore.EValidator;
import org.eclipse.emf.ecore.util.EObjectValidator;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeUtil;
import org.eclipse.emf.ecore.xml.type.util.XMLTypeValidator;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.DocumentRoot;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Package;
import org.eclipse.ohf.ihe.common.hl7v2.SourcePatientInfoType;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;

public class Hl7v2Validator
extends EObjectValidator {
    public static final Hl7v2Validator INSTANCE = new Hl7v2Validator();
    public static final String DIAGNOSTIC_SOURCE = "org.eclipse.ohf.ihe.common.hl7v2";
    private static final int GENERATED_DIAGNOSTIC_CODE_COUNT = 0;
    protected static final int DIAGNOSTIC_CODE_COUNT = 0;
    protected XMLTypeValidator xmlTypeValidator = XMLTypeValidator.INSTANCE;
    public static final EValidator.PatternMatcher[][] DTM__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"[0-9]{1,8}|([0-9]{9,14}|[0-9]{14,14}\\.[0-9]+)([+\\-][0-9]{1,4})?")}};
    public static final EValidator.PatternMatcher[][] OID__PATTERN__VALUES = new EValidator.PatternMatcher[][]{{XMLTypeUtil.createPatternMatcher((String)"([1-9][0-9]*)(\\.[1-9][0-9]*)*")}};

    protected EPackage getEPackage() {
        return Hl7v2Package.eINSTANCE;
    }

    protected boolean validate(int classifierID, Object value, DiagnosticChain diagnostics, Map context) {
        switch (classifierID) {
            case 0: {
                return this.validateCX((CX)value, diagnostics, context);
            }
            case 1: {
                return this.validateDocumentRoot((DocumentRoot)value, diagnostics, context);
            }
            case 2: {
                return this.validateSourcePatientInfoType((SourcePatientInfoType)value, diagnostics, context);
            }
            case 3: {
                return this.validateXAD((XAD)value, diagnostics, context);
            }
            case 4: {
                return this.validateXCN((XCN)value, diagnostics, context);
            }
            case 5: {
                return this.validateXON((XON)value, diagnostics, context);
            }
            case 6: {
                return this.validateXPN((XPN)value, diagnostics, context);
            }
            case 7: {
                return this.validateXTN((XTN)value, diagnostics, context);
            }
            case 8: {
                return this.validateDTM((String)value, diagnostics, context);
            }
            case 9: {
                return this.validateOid((String)value, diagnostics, context);
            }
        }
        return true;
    }

    public boolean validateCX(CX cx, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(cx, diagnostics, context);
    }

    public boolean validateDocumentRoot(DocumentRoot documentRoot, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(documentRoot, diagnostics, context);
    }

    public boolean validateSourcePatientInfoType(SourcePatientInfoType sourcePatientInfoType, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(sourcePatientInfoType, diagnostics, context);
    }

    public boolean validateXAD(XAD xad, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(xad, diagnostics, context);
    }

    public boolean validateXCN(XCN xcn, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(xcn, diagnostics, context);
    }

    public boolean validateXON(XON xon, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(xon, diagnostics, context);
    }

    public boolean validateXPN(XPN xpn, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(xpn, diagnostics, context);
    }

    public boolean validateXTN(XTN xtn, DiagnosticChain diagnostics, Map context) {
        return this.validate_EveryDefaultConstraint(xtn, diagnostics, context);
    }

    public boolean validateDTM(String dtm, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateDTM_Pattern(dtm, diagnostics, context);
        return result;
    }

    public boolean validateDTM_Pattern(String dtm, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(Hl7v2Package.Literals.DTM, dtm, DTM__PATTERN__VALUES, diagnostics, context);
    }

    public boolean validateOid(String oid, DiagnosticChain diagnostics, Map context) {
        boolean result = this.validateOid_Pattern(oid, diagnostics, context);
        return result;
    }

    public boolean validateOid_Pattern(String oid, DiagnosticChain diagnostics, Map context) {
        return this.validatePattern(Hl7v2Package.Literals.OID, oid, OID__PATTERN__VALUES, diagnostics, context);
    }
}

