/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.ihe.IheXdsResourcesFactory;
import org.eclipse.ohf.bridge.ihe.XDSUtil;
import org.eclipse.ohf.bridge.ihe.type.IheDocumentSearchType;
import org.eclipse.ohf.bridge.type.CodedMetadataType;
import org.eclipse.ohf.bridge.type.DocumentQueryPreferencesType;
import org.eclipse.ohf.bridge.type.DocumentSubmissionMetadataType;
import org.eclipse.ohf.bridge.type.FindDocumentQueryType;
import org.eclipse.ohf.bridge.type.GetDocumentQueryType;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.QueryDocumentsResponseType;
import org.eclipse.ohf.bridge.type.SubmitDocumentResponseType;
import org.eclipse.ohf.bridge.type.XDSDocType;
import org.eclipse.ohf.bridge.xds.AbstractXdsBridge;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Factory;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.xds.consumer.Consumer;
import org.eclipse.ohf.ihe.xds.consumer.query.FindDocumentsQuery;
import org.eclipse.ohf.ihe.xds.consumer.query.GetDocumentsQuery;
import org.eclipse.ohf.ihe.xds.consumer.query.Query;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentRelationshipType;
import org.eclipse.ohf.ihe.xds.metadata.transform.ByteArrayDocumentEntryTransformer;
import org.eclipse.ohf.ihe.xds.source.SubmitTransactionData;
import org.eclipse.ohf.ihe.xds.source.document.Document;
import org.eclipse.ohf.ihe.xds.source.document.DocumentDescriptor;
import org.eclipse.ohf.ihe.xds.source.utils.OID;
import sun.misc.BASE64Encoder;

public class IheXdsBridge
extends AbstractXdsBridge {
    static final Logger mLogger = Logger.getLogger(IheXdsBridge.class);
    private SimpleDateFormat dateFormat = new SimpleDateFormat();

    public IheXdsBridge() {
        this.dateFormat.applyPattern("yyyyMMddHHmmss");
    }

    protected QueryDocumentsResponseType goQueryDocumentsByPatientId(PatientIdType patientId, DocumentQueryPreferencesType searchPreferences) throws Exception {
        Iterator iterator;
        Consumer xdsDocumentConsumer;
        org.eclipse.ohf.ihe.xds.consumer.storedquery.FindDocumentsQuery query;
        CX cx = this.createCX(patientId);
        List docList = null;
        if (searchPreferences.isStoredQuery()) {
            query = new org.eclipse.ohf.ihe.xds.consumer.storedquery.FindDocumentsQuery(cx, IheDocumentSearchType.ALL_STATUSES_ARRAY);
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getStoredQueriesXdsDocumentConsumer();
            docList = xdsDocumentConsumer.invokeStoredQuery((StoredQuery)query, searchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        } else {
            query = new FindDocumentsQuery(cx, IheDocumentSearchType.ALL_STATUSES_ARRAY);
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getNoneStoredQueriesXdsDocumentConsumer();
            docList = xdsDocumentConsumer.query((Query)query, searchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        }
        if (docList == null) {
            QueryDocumentsResponseType responce = new QueryDocumentsResponseType();
            responce.setSuccess(true);
            responce.setSuccessMessage("no documents found");
            return responce;
        }
        ArrayList<XDSDocType> documentList = null;
        if (searchPreferences.isReturnReferencesOnly()) {
            iterator = docList.listIterator();
            documentList = new ArrayList<XDSDocType>();
            while (iterator.hasNext()) {
                XDSDocType xdsDocument = new XDSDocType();
                xdsDocument.setUuid((String)iterator.next());
                documentList.add(xdsDocument);
            }
        } else {
            iterator = docList.listIterator();
            documentList = new ArrayList();
            int count = 1;
            while (iterator.hasNext()) {
                DocumentEntryType documentEntry = (DocumentEntryType)iterator.next();
                if (mLogger.isDebugEnabled()) {
                    ByteArrayDocumentEntryTransformer transformer = new ByteArrayDocumentEntryTransformer();
                    transformer.transform(documentEntry);
                    mLogger.debug((Object)("The " + count + " document is:"));
                    mLogger.debug((Object)new String(transformer.getDocumentEntryByteArray()));
                    ++count;
                }
                XDSDocType xdsDocument = this.createXdsDocument(documentEntry);
                documentList.add(xdsDocument);
            }
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("got " + documentList.size() + " documents by QueryDocumentsByPatientId(" + patientId + ")"));
        }
        QueryDocumentsResponseType documentCollection = new QueryDocumentsResponseType();
        documentCollection.setSuccess(true);
        documentCollection.setDocumentTypeArray(documentList.toArray(new XDSDocType[documentList.size()]));
        return documentCollection;
    }

    protected XDSDocType goRetrieveDocument(String searchId, boolean isUUID) throws Exception {
        InputStream is;
        DocumentEntryType documentEntry;
        String[] searchIdList;
        Consumer xdsDocumentConsumer = this.getConsumer();
        List docList = xdsDocumentConsumer.invokeStoredQuery((StoredQuery)new org.eclipse.ohf.ihe.xds.consumer.storedquery.GetDocumentsQuery(searchIdList = new String[]{searchId}, isUUID), false, TransactionContext.instant().getSessionContext().getUser());
        if (docList == null || docList.size() < 1 || docList.get(0) == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("no documents for this id = " + searchId));
            }
            return null;
        }
        if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR) && docList.size() > 1) {
            mLogger.debug((Object)("There are " + docList.size() + " documents where there should be only one!"));
        }
        if ((documentEntry = (DocumentEntryType)docList.get(0)).getUri() == null) {
            ByteArrayDocumentEntryTransformer transformer = new ByteArrayDocumentEntryTransformer();
            transformer.transform(documentEntry);
            String documentAsString = new String(transformer.getDocumentEntryByteArray());
            throw new IllegalArgumentException("ILLEGAL DOCUMENT FORMAT: Null URI for document id [" + searchId + "] \n documentEntry is \n:" + documentAsString);
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("try to retrieve document with URI = " + documentEntry.getUri()));
        }
        if ((is = xdsDocumentConsumer.retrieveDocument(documentEntry.getUri(), TransactionContext.instant().getSessionContext().getUser())) == null) {
            throw new IllegalStateException("the document does not exist on the server");
        }
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        BufferedInputStream bis = new BufferedInputStream(is);
        XDSDocType xdsDocument = this.createXdsDocument(documentEntry);
        try {
            int inputData;
            while ((inputData = bis.read()) != -1) {
                System.err.print(new String(Character.toChars(inputData)));
                bos.write(inputData);
            }
            bos.flush();
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] byteArray = baos.toByteArray();
            xdsDocument.setBase64EncodedDocument(encoder.encode(byteArray));
        }
        finally {
            bis.close();
            is.close();
            baos.close();
            bos.close();
        }
        xdsDocument.setMimeType(documentEntry.getMimeType());
        xdsDocument.setDocumentSize(documentEntry.getSize());
        if (documentEntry.getFormatCode() != null) {
            xdsDocument.setFormatCode(documentEntry.getFormatCode().getCode());
        }
        return xdsDocument;
    }

    protected SubmitDocumentResponseType doAddCDADocumentWithoutExtractingMetadata(String cdaXml, InputStream docEntryStream, InputStream submitSetStream) throws Exception {
        SubmitTransactionData transactionData = new SubmitTransactionData();
        Document cdaInputDoc = new Document(cdaXml.getBytes(), DocumentDescriptor.CDA_R2);
        String docEntryUUID = transactionData.loadDocumentWithMetadata(cdaInputDoc, docEntryStream);
        transactionData.getDocumentEntry(docEntryUUID).setUniqueId(OID.createOID(null));
        transactionData.loadSubmissionSet(submitSetStream);
        transactionData.getSubmissionSet().setUniqueId(OID.createOID(null));
        IheXdsResourcesFactory.getResources().getXdsDocumentSource().submit(transactionData, TransactionContext.instant().getSessionContext().getUser());
        SubmitDocumentResponseType responce = new SubmitDocumentResponseType();
        responce.setDocumentEntryUUID(docEntryUUID);
        responce.setSubmissioSetUniqueId(transactionData.getSubmissionSet().getUniqueId());
        responce.setSuccess(true);
        return responce;
    }

    protected QueryDocumentsResponseType goQueryDocuments(FindDocumentQueryType pFindDocumentQueryType, DocumentQueryPreferencesType searchPreferences) throws Exception {
        Iterator iterator;
        org.eclipse.ohf.ihe.xds.consumer.storedquery.FindDocumentsQuery query;
        Consumer xdsDocumentConsumer;
        CX cx = this.createCX(pFindDocumentQueryType.getPatientID());
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] classCodes = this.getClassCodes(pFindDocumentQueryType);
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] practiceSettingCodes = this.getPracticeSettingCodes(pFindDocumentQueryType);
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] healthcareFacilityCodes = this.getHealthcareFacilityCodes(pFindDocumentQueryType);
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] eventCodes = this.getEventCodes(pFindDocumentQueryType);
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] confidentialityCodes = this.getConfidentialityCodes(pFindDocumentQueryType);
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] formatCodes = this.getFormatCodes(pFindDocumentQueryType);
        IheDocumentSearchType iheDocumentSearchType = new IheDocumentSearchType(pFindDocumentQueryType);
        List docList = null;
        if (searchPreferences.isStoredQuery()) {
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getStoredQueriesXdsDocumentConsumer();
            query = new org.eclipse.ohf.ihe.xds.consumer.storedquery.FindDocumentsQuery(cx, classCodes, iheDocumentSearchType.getOhfDateTimeRanges(), practiceSettingCodes, healthcareFacilityCodes, eventCodes, confidentialityCodes, formatCodes, iheDocumentSearchType.statusAsAvailabilityStatusType());
            docList = xdsDocumentConsumer.invokeStoredQuery((StoredQuery)query, searchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        } else {
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getNoneStoredQueriesXdsDocumentConsumer();
            query = new FindDocumentsQuery(cx, classCodes, iheDocumentSearchType.getOhfDateTimeRanges(), practiceSettingCodes, healthcareFacilityCodes, eventCodes, confidentialityCodes, formatCodes, iheDocumentSearchType.statusAsAvailabilityStatusType());
            docList = xdsDocumentConsumer.query((Query)query, searchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        }
        if (docList == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"no results for Query documents");
            }
            QueryDocumentsResponseType responce = new QueryDocumentsResponseType();
            responce.setSuccessMessage("no documents found");
            responce.setSuccess(true);
            return responce;
        }
        ArrayList<XDSDocType> documentList = null;
        if (searchPreferences.isReturnReferencesOnly()) {
            iterator = docList.listIterator();
            documentList = new ArrayList<XDSDocType>();
            while (iterator.hasNext()) {
                XDSDocType xdsDocument = new XDSDocType();
                xdsDocument.setUuid((String)iterator.next());
                documentList.add(xdsDocument);
            }
        } else {
            iterator = docList.listIterator();
            documentList = new ArrayList();
            while (iterator.hasNext()) {
                DocumentEntryType documentEntry = (DocumentEntryType)iterator.next();
                XDSDocType xdsDocument = this.createXdsDocument(documentEntry);
                documentList.add(xdsDocument);
            }
        }
        QueryDocumentsResponseType responce = new QueryDocumentsResponseType();
        responce.setDocumentTypeArray(documentList.toArray(new XDSDocType[documentList.size()]));
        responce.setSuccess(true);
        return responce;
    }

    private XDSDocType createXdsDocument(DocumentEntryType documentEntry) throws Exception {
        XDSDocType xdsDocument = new XDSDocType();
        xdsDocument.setMimeType(documentEntry.getMimeType());
        xdsDocument.setUniqueId(documentEntry.getUniqueId());
        xdsDocument.setUuid(documentEntry.getEntryUUID());
        xdsDocument.setDocumentSize(documentEntry.getSize());
        xdsDocument.setAuthors(this.authorsToPatientInfoTypeArray(documentEntry.getAuthor()));
        xdsDocument.setAvailabilityStatus(documentEntry.getAvailabilityStatus().getLiteral());
        xdsDocument.setComments(this.extractString(documentEntry.getComments()));
        xdsDocument.setClassCode(this.extractCode(documentEntry.getClassCode()));
        xdsDocument.setConfidentialityCode(this.extractCode(documentEntry.getConfidentialityCode()));
        xdsDocument.setCreationTime(documentEntry.getCreationTime());
        xdsDocument.setEventCodes(this.extractCodes(documentEntry.getEventCode()));
        xdsDocument.setHealthCareFacilityTypeCode(this.extractCode(documentEntry.getHealthCareFacilityTypeCode()));
        xdsDocument.setLanguageCode(documentEntry.getLanguageCode());
        xdsDocument.setParentDocumentId(documentEntry.getParentDocumentId());
        xdsDocument.setParentDocumentRelationship(documentEntry.getParentDocumentRelationship().getLiteral());
        xdsDocument.setPracticeSettingCode(this.extractCode(documentEntry.getPracticeSettingCode()));
        xdsDocument.setServiceStartTime(documentEntry.getServiceStartTime());
        xdsDocument.setServiceStopTime(documentEntry.getServiceStopTime());
        xdsDocument.setSourcePatientId(this.cxToPatientInfoType(documentEntry.getSourcePatientId()));
        xdsDocument.setTypeCode(this.extractCode(documentEntry.getTypeCode()));
        xdsDocument.setUri(documentEntry.getUri());
        if (documentEntry.getFormatCode() != null) {
            xdsDocument.setFormatCode(documentEntry.getFormatCode().getCode());
        }
        String docTitle = XDSUtil.convertString(documentEntry.getTitle());
        xdsDocument.setDocumentTitle(docTitle);
        return xdsDocument;
    }

    private PatientIdType cxToPatientInfoType(CX pSourcePatientId) {
        PatientIdType id = new PatientIdType();
        if (pSourcePatientId == null) {
            return id;
        }
        id.setIdNumber(pSourcePatientId.getIdNumber());
        id.getAssigningAuthorityType().setNamespaceId(pSourcePatientId.getAssigningAuthorityName());
        id.getAssigningAuthorityType().setUniversalId(pSourcePatientId.getAssigningAuthorityUniversalId());
        id.getAssigningAuthorityType().setUniversalIdType(pSourcePatientId.getAssigningAuthorityUniversalIdType());
        return id;
    }

    private CodedMetadataType[] extractCodes(EList pSourceList) {
        if (pSourceList == null) {
            return null;
        }
        ArrayList<CodedMetadataType> list = new ArrayList<CodedMetadataType>();
        int i = 0;
        while (i > pSourceList.size()) {
            org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType sourceObject = (org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType)pSourceList.get(i);
            list.add(this.extractCode(sourceObject));
            ++i;
        }
        return list.toArray(new CodedMetadataType[list.size()]);
    }

    private CodedMetadataType extractCode(org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType pCode) {
        if (pCode != null) {
            CodedMetadataType dest = new CodedMetadataType();
            dest.setCodeName(pCode.getCode());
            dest.setDisplayName(this.extractString(pCode.getDisplayName()));
            dest.setSchemeName(pCode.getSchemeName());
            return dest;
        }
        return null;
    }

    private String extractString(InternationalStringType pComments) {
        LocalizedStringType localizedStringType;
        if (pComments != null && pComments.getLocalizedString() != null && pComments.getLocalizedString().size() > 0 && (localizedStringType = (LocalizedStringType)pComments.getLocalizedString().get(0)) != null) {
            return localizedStringType.getValue();
        }
        return null;
    }

    private PatientInfoType[] authorsToPatientInfoTypeArray(EList pSourceList) {
        if (pSourceList == null) {
            return null;
        }
        ArrayList<PatientInfoType> list = new ArrayList<PatientInfoType>();
        int i = 0;
        while (i > pSourceList.size()) {
            AuthorType sourceObject = (AuthorType)pSourceList.get(i);
            list.add(this.authorToPatientInfoType(sourceObject));
            ++i;
        }
        return list.toArray(new PatientInfoType[list.size()]);
    }

    private PatientInfoType authorToPatientInfoType(AuthorType pSourceObject) {
        if (pSourceObject.getAuthorPerson() == null) {
            return null;
        }
        return this.xcnToPatientInfoType(pSourceObject.getAuthorPerson());
    }

    private PatientInfoType xcnToPatientInfoType(XCN pSourceObject) {
        if (pSourceObject == null) {
            return null;
        }
        PatientInfoType patient = new PatientInfoType();
        patient.getPatientIdentifier().getAssigningAuthorityType().setNamespaceId(pSourceObject.getAssigningAuthorityName());
        patient.getPatientIdentifier().getAssigningAuthorityType().setUniversalId(pSourceObject.getAssigningAuthorityUniversalId());
        patient.getPatientIdentifier().getAssigningAuthorityType().setUniversalIdType(pSourceObject.getAssigningAuthorityUniversalIdType());
        patient.getPatientName().setFamilyName(pSourceObject.getFamilyName());
        patient.getPatientName().setGivenName(pSourceObject.getGivenName());
        patient.getPatientIdentifier().setIdNumber(pSourceObject.getIdNumber());
        patient.getPatientName().setOtherName(pSourceObject.getOtherName());
        patient.getPatientName().setPrefix(pSourceObject.getPrefix());
        patient.getPatientName().setSuffix(pSourceObject.getSuffix());
        return patient;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getFormatCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] formatCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getFormatCodes().length];
        int i = 0;
        while (i < formatCodes.length) {
            formatCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            formatCodes[i].setCode(pFindDocumentQueryType.getFormatCodes()[i]);
            ++i;
        }
        return formatCodes;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getConfidentialityCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] confidentialityCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getConfidentialityCodes().length];
        int i = 0;
        while (i < confidentialityCodes.length) {
            confidentialityCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            confidentialityCodes[i].setCode(pFindDocumentQueryType.getConfidentialityCodes()[i]);
            ++i;
        }
        return confidentialityCodes;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getEventCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] eventCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getEventCodes().length];
        int i = 0;
        while (i < eventCodes.length) {
            eventCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            eventCodes[i].setCode(pFindDocumentQueryType.getEventCodes()[i]);
            ++i;
        }
        return eventCodes;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getHealthcareFacilityCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] healthcareFacilityCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getHealthCareFacilityCodes().length];
        int i = 0;
        while (i < healthcareFacilityCodes.length) {
            healthcareFacilityCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            healthcareFacilityCodes[i].setCode(pFindDocumentQueryType.getHealthCareFacilityCodes()[i]);
            ++i;
        }
        return healthcareFacilityCodes;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getPracticeSettingCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] practiceSettingCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getPracticeSettingCodes().length];
        int i = 0;
        while (i < practiceSettingCodes.length) {
            practiceSettingCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            practiceSettingCodes[i].setCode(pFindDocumentQueryType.getPracticeSettingCodes()[i]);
            ++i;
        }
        return practiceSettingCodes;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] getClassCodes(FindDocumentQueryType pFindDocumentQueryType) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[] classCodes = new org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType[pFindDocumentQueryType.getClassCodes().length];
        int i = 0;
        while (i < classCodes.length) {
            classCodes[i] = MetadataFactory.eINSTANCE.createCodedMetadataType();
            classCodes[i].setCode(pFindDocumentQueryType.getClassCodes()[i]);
            ++i;
        }
        return classCodes;
    }

    public SubmitDocumentResponseType addCDADocument(String pCdaXml, DocumentSubmissionMetadataType pMetadata) throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting String addCDADocument(" + pMetadata + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        SubmitTransactionData transactionData = new SubmitTransactionData();
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"Adding input document, and metadata.");
        }
        Document clinicalDocument = new Document(pCdaXml.getBytes(), DocumentDescriptor.CDA_R2);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("clinicalDocument = " + clinicalDocument));
        }
        String docEntryUUID = transactionData.addDocument(clinicalDocument);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"Supplementing Document Entry metadata");
        }
        if (pMetadata.getDocumentEntryClassCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setClassCode(this.createCode(pMetadata.getDocumentEntryClassCode()));
        }
        if (pMetadata.getDocumentEntryConfidentialityCodeCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setConfidentialityCode(this.createCode(pMetadata.getDocumentEntryConfidentialityCodeCode()));
        }
        if (pMetadata.getDocumentEntryFormatCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setFormatCode(this.createCode(pMetadata.getDocumentEntryFormatCode()));
        }
        if (pMetadata.getDocumentEntryHealthcareFacilityCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setHealthCareFacilityTypeCode(this.createCode(pMetadata.getDocumentEntryHealthcareFacilityCode()));
        }
        if (pMetadata.getPatientId() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setPatientId(this.createCX(pMetadata.getPatientId()));
        }
        if (pMetadata.getDocumentEntryPracticeSettingCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setPracticeSettingCode(this.createCode(pMetadata.getDocumentEntryPracticeSettingCode()));
        }
        if (pMetadata.getDocumentEntryTypeCode() != null) {
            transactionData.getDocumentEntry(docEntryUUID).setTypeCode(this.createCode(pMetadata.getDocumentEntryTypeCode()));
        }
        if (!Utils.isEmptyOrNull((String)pMetadata.getDocumentEntryParentDocumentId())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"replacing a document");
            }
            transactionData.getDocumentEntry(docEntryUUID).setParentDocumentId(pMetadata.getDocumentEntryParentDocumentId());
            transactionData.getDocumentEntry(docEntryUUID).setParentDocumentRelationship(ParentDocumentRelationshipType.RPLC_LITERAL);
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("created document entry: " + transactionData.getDocumentEntry(docEntryUUID).toString()));
        }
        if (!Utils.isEmptyOrNull((String)pMetadata.getSubmissionSetSourceId())) {
            transactionData.getSubmissionSet().setUniqueId(OID.createOIDGivenRoot((String)pMetadata.getSubmissionSetSourceId()));
        }
        transactionData.getSubmissionSet().setSubmissionTime(this.dateFormat.format(new Date()));
        if (pMetadata.getSubmissionSetContentTypeCode() != null) {
            transactionData.getSubmissionSet().setContentTypeCode(this.createCode(pMetadata.getSubmissionSetContentTypeCode()));
        }
        if (pMetadata.getPatientId() != null) {
            transactionData.getSubmissionSet().setPatientId(this.createCX(pMetadata.getPatientId()));
        }
        if (!Utils.isEmptyOrNull((String)pMetadata.getSubmissionSetSourceId())) {
            transactionData.getSubmissionSet().setSourceId(pMetadata.getSubmissionSetSourceId());
        }
        IheXdsResourcesFactory.getResources().getXdsDocumentSource().submit(transactionData, TransactionContext.instant().getSessionContext().getUser());
        SubmitDocumentResponseType responce = new SubmitDocumentResponseType();
        responce.setDocumentEntryUUID(docEntryUUID);
        responce.setSubmissioSetUniqueId(transactionData.getSubmissionSet().getUniqueId());
        responce.setSuccess(true);
        return responce;
    }

    private CX createCX(PatientIdType pPatientId) throws UnavailableResourcesException {
        CX cx = Hl7v2Factory.eINSTANCE.createCX();
        cx.setIdNumber(pPatientId.getIdNumber());
        cx.setAssigningAuthorityUniversalId(pPatientId.getAssigningAuthorityType().getUniversalId());
        cx.setAssigningAuthorityUniversalIdType(pPatientId.getAssigningAuthorityType().getUniversalIdType());
        return cx;
    }

    private org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType createCode(CodedMetadataType pDocumentEntryClassCode) {
        org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType code = MetadataFactory.eINSTANCE.createCodedMetadataType();
        code.setCode(pDocumentEntryClassCode.getCodeName());
        InternationalStringType internationalString = MetadataFactory.eINSTANCE.createInternationalStringType();
        LocalizedStringType stringType = MetadataFactory.eINSTANCE.createLocalizedStringType();
        stringType.setValue(pDocumentEntryClassCode.getDisplayName());
        internationalString.getLocalizedString().add((Object)stringType);
        code.setDisplayName(internationalString);
        code.setSchemeName(pDocumentEntryClassCode.getSchemeName());
        return code;
    }

    protected QueryDocumentsResponseType goQueryDocuments(GetDocumentQueryType pGetDocumentQueryType, DocumentQueryPreferencesType pSearchPreferences) throws Exception {
        Iterator iterator;
        org.eclipse.ohf.ihe.xds.consumer.storedquery.GetDocumentsQuery query;
        Consumer xdsDocumentConsumer;
        List docList = null;
        if (pSearchPreferences.isStoredQuery()) {
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getStoredQueriesXdsDocumentConsumer();
            query = new org.eclipse.ohf.ihe.xds.consumer.storedquery.GetDocumentsQuery(pGetDocumentQueryType.getDocumentIds(), pGetDocumentQueryType.isUUID());
            docList = xdsDocumentConsumer.invokeStoredQuery((StoredQuery)query, pSearchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        } else {
            xdsDocumentConsumer = IheXdsResourcesFactory.getResources().getNoneStoredQueriesXdsDocumentConsumer();
            query = new GetDocumentsQuery(pGetDocumentQueryType.getDocumentIds(), pGetDocumentQueryType.isUUID());
            docList = xdsDocumentConsumer.query((Query)query, pSearchPreferences.isReturnReferencesOnly(), TransactionContext.instant().getSessionContext().getUser());
        }
        if (docList == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"no results for Query documents");
            }
            QueryDocumentsResponseType responce = new QueryDocumentsResponseType();
            responce.setSuccess(true);
            responce.setSuccessMessage("no documents found");
            return responce;
        }
        ArrayList<XDSDocType> documentList = null;
        if (pSearchPreferences.isReturnReferencesOnly()) {
            iterator = docList.listIterator();
            documentList = new ArrayList<XDSDocType>();
            while (iterator.hasNext()) {
                XDSDocType xdsDocument = new XDSDocType();
                xdsDocument.setUuid((String)iterator.next());
                documentList.add(xdsDocument);
            }
        } else {
            iterator = docList.listIterator();
            documentList = new ArrayList();
            while (iterator.hasNext()) {
                DocumentEntryType documentEntry = (DocumentEntryType)iterator.next();
                XDSDocType xdsDocument = this.createXdsDocument(documentEntry);
                documentList.add(xdsDocument);
            }
        }
        QueryDocumentsResponseType responce = new QueryDocumentsResponseType();
        responce.setDocumentTypeArray(documentList.toArray(new XDSDocType[documentList.size()]));
        responce.setSuccess(true);
        return responce;
    }

    protected XDSDocType goRetrieveDocumentByUrl(String pUrl) throws IOException, ATNAAuditClientException, GeneralSecurityException, UnavailableResourcesException {
        Consumer xdsDocumentConsumer = this.getConsumer();
        InputStream is = xdsDocumentConsumer.retrieveDocument(pUrl, TransactionContext.instant().getSessionContext().getUser());
        if (is == null) {
            throw new IllegalStateException("the document does not exist on the server");
        }
        XDSDocType xdsDocument = new XDSDocType();
        this.readDocumentFromStream(is, xdsDocument);
        return xdsDocument;
    }

    private void readDocumentFromStream(InputStream is, XDSDocType xdsDocument) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        BufferedOutputStream bos = new BufferedOutputStream(baos);
        BufferedInputStream bis = new BufferedInputStream(is);
        try {
            int inputData;
            while ((inputData = bis.read()) != -1) {
                System.err.print(new String(Character.toChars(inputData)));
                bos.write(inputData);
            }
            bos.flush();
            BASE64Encoder encoder = new BASE64Encoder();
            byte[] byteArray = baos.toByteArray();
            xdsDocument.setBase64EncodedDocument(encoder.encode(byteArray));
        }
        finally {
            bis.close();
            is.close();
            baos.close();
            bos.close();
        }
    }

    private Consumer getConsumer() throws UnavailableResourcesException {
        Consumer xdsDocumentConsumer = null;
        xdsDocumentConsumer = IheXdsResourcesFactory.getResources().isNoneStoredQueriesResourcesAvaliable() ? IheXdsResourcesFactory.getResources().getNoneStoredQueriesXdsDocumentConsumer() : IheXdsResourcesFactory.getResources().getStoredQueriesXdsDocumentConsumer();
        return xdsDocumentConsumer;
    }
}

