/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.type;

import java.util.ArrayList;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.type.DateTimeRangeType;
import org.eclipse.ohf.bridge.type.FindDocumentQueryType;
import org.eclipse.ohf.ihe.xds.consumer.query.DateTimeRange;
import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;

public class IheDocumentSearchType
extends FindDocumentQueryType {
    private static final long serialVersionUID = 1354998664274492817L;
    static final Logger mLogger = Logger.getLogger(IheDocumentSearchType.class);
    public static final String[] ATTRIBUTES = new String[]{"creationTime", "serviceStartTime", "serviceStopTime", "submissionTime", "lastUpdateTime"};
    public static final AvailabilityStatusType[] ALL_STATUSES_ARRAY = new AvailabilityStatusType[]{AvailabilityStatusType.APPROVED_LITERAL, AvailabilityStatusType.DEPRECATED_LITERAL, AvailabilityStatusType.WITHDRAWN_LITERAL, AvailabilityStatusType.SUBMITTED_LITERAL};
    public static final String[] ALL_STATUSES_STRING_ARRAY = new String[]{AvailabilityStatusType.APPROVED_LITERAL.getLiteral(), AvailabilityStatusType.DEPRECATED_LITERAL.getLiteral(), AvailabilityStatusType.WITHDRAWN_LITERAL.getLiteral(), AvailabilityStatusType.SUBMITTED_LITERAL.getLiteral()};
    private transient AvailabilityStatusType[] mAvailabilityStatusType = ALL_STATUSES_ARRAY;
    private transient DateTimeRange[] mOhfDateTimeRanges;

    public IheDocumentSearchType(FindDocumentQueryType pFindDocumentQueryType) {
        super(pFindDocumentQueryType);
        this.removeEmptyDates();
        this.validateDate();
    }

    private void removeEmptyDates() {
        ArrayList<DateTimeRangeType> temp = new ArrayList<DateTimeRangeType>();
        DateTimeRangeType[] dateTimeRangeTypeArray = this.mDateTimeRanges;
        int n = 0;
        int n2 = dateTimeRangeTypeArray.length;
        while (n < n2) {
            DateTimeRangeType date = dateTimeRangeTypeArray[n];
            if (!Utils.isEmptyOrNull((String)date.getAttributeName())) {
                temp.add(date);
            } else if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"removed a DateTimeRangeType with an empty attribute name");
            }
            ++n;
        }
        this.mDateTimeRanges = temp.toArray(new DateTimeRangeType[temp.size()]);
    }

    private void validateDate() {
        int j = 0;
        while (j < this.mDateTimeRanges.length) {
            if (!this.checkTimeAttribute(j)) {
                StringBuffer message = new StringBuffer("Attribute cant be [");
                message.append(this.mDateTimeRanges[j].getAttributeName()).append("] it has to be one of [");
                int i = 0;
                while (i < ATTRIBUTES.length) {
                    message.append(ATTRIBUTES[i]).append(" ");
                    ++i;
                }
                message.append("]");
                throw new IllegalArgumentException(message.toString());
            }
            ++j;
        }
    }

    private boolean checkTimeAttribute(int j) {
        int i = 0;
        while (i < ATTRIBUTES.length) {
            if (this.mDateTimeRanges[j].getAttributeName().equalsIgnoreCase(ATTRIBUTES[i])) {
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)(String.valueOf(this.mDateTimeRanges[j].getAttributeName()) + " attribute is valid"));
                }
                return true;
            }
            ++i;
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)(String.valueOf(this.mDateTimeRanges[j].getAttributeName()) + " is not a valid attribute"));
        }
        return false;
    }

    public DateTimeRange[] getOhfDateTimeRanges() throws MalformedQueryException {
        if (this.mOhfDateTimeRanges != null) {
            return this.mOhfDateTimeRanges;
        }
        ArrayList<DateTimeRange> tempList = new ArrayList<DateTimeRange>();
        int i = 0;
        while (i < this.getDateTimeRanges().length) {
            DateTimeRangeType date = this.getDateTimeRanges()[i];
            tempList.add(new DateTimeRange(date.getAttributeName(), date.getFrom(), date.getTo()));
            ++i;
        }
        this.mOhfDateTimeRanges = tempList.toArray(new DateTimeRange[tempList.size()]);
        return this.mOhfDateTimeRanges;
    }

    public AvailabilityStatusType[] statusAsAvailabilityStatusType() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting AvailabilityStatusType[] statusAsAvailabilityStatusType(" + Utils.stringArrayAsString((String[])this.mStatus) + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        if (this.mAvailabilityStatusType == ALL_STATUSES_ARRAY) {
            return this.mAvailabilityStatusType;
        }
        if (this.mStatus == null || this.mStatus.length == 0) {
            return ALL_STATUSES_ARRAY;
        }
        ArrayList<String> tempStringList = new ArrayList<String>();
        ArrayList<AvailabilityStatusType> tempTypeList = new ArrayList<AvailabilityStatusType>();
        int i = 0;
        while (i < this.mStatus.length) {
            boolean foundIt = false;
            int j = 0;
            while (j < ALL_STATUSES_ARRAY.length) {
                if (ALL_STATUSES_ARRAY[j].getName().equalsIgnoreCase(this.mStatus[i])) {
                    foundIt = true;
                    tempStringList.add(ALL_STATUSES_ARRAY[j].getLiteral());
                    tempTypeList.add(ALL_STATUSES_ARRAY[j]);
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("added to the list: " + ALL_STATUSES_ARRAY[j].getLiteral()));
                    }
                }
                ++j;
            }
            if (!foundIt) {
                throw new IllegalArgumentException("the status " + this.mStatus[i] + " is not a valid status");
            }
            ++i;
        }
        this.mAvailabilityStatusType = tempTypeList.toArray(new AvailabilityStatusType[tempTypeList.size()]);
        return this.mAvailabilityStatusType;
    }
}

