/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.source.document;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.xds.source.document.DocumentDescriptor;

public class Document {
    private static final Logger logger;
    private String documentData;
    private DocumentDescriptor descriptor;
    private String canonicalPath;
    private String documentEntryUUID;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.source.document.Document");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public Document(File file, DocumentDescriptor descriptor) throws FileNotFoundException, IOException {
        this.canonicalPath = file.getCanonicalPath();
        byte[] data = new byte[(int)file.length()];
        FileInputStream inFile = new FileInputStream(file);
        inFile.read(data);
        inFile.close();
        this.documentData = new String(data);
        this.descriptor = descriptor == null ? DocumentDescriptor.UNKNOWN : descriptor;
        this.canonicalPath = file.getCanonicalPath();
        this.documentEntryUUID = null;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Created new Document from File=" + file.getAbsolutePath() + " Descriptor=" + this.descriptor.toString() + " MimeType=" + this.descriptor.getMimeType()));
        }
    }

    public Document(String source, DocumentDescriptor descriptor) throws FileNotFoundException, IOException {
        this(new File(source), descriptor);
    }

    public Document(byte[] documentByteArray, DocumentDescriptor descriptor) {
        this.documentData = new String(documentByteArray);
        this.descriptor = descriptor == null ? DocumentDescriptor.UNKNOWN : descriptor;
    }

    public String getCanonicalPath() {
        return this.canonicalPath;
    }

    public DocumentDescriptor getDescriptor() {
        return this.descriptor;
    }

    public String getDocumentData() {
        return this.documentData;
    }

    public String getDocumentEntryUUID() {
        return this.documentEntryUUID;
    }

    public void setDocumentEntryUUID(String documentEntryUUID) {
        this.documentEntryUUID = documentEntryUUID;
    }

    public boolean equals(Document document) {
        if (!document.descriptor.equals(this.descriptor)) {
            return false;
        }
        return this.documentData.equals(document.getDocumentData());
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer();
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.source.document.Document");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        return stringBuffer.append(clazz).append(":").append("Document Descriptor=").append(this.descriptor.toString()).append("\nDocument data=").append(this.documentData).append("<<END OF DOCUMENT DATA").toString();
    }
}

