/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.source.utils;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.security.DigestException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.GregorianCalendar;

public class UUID {
    private static long lastTimeCalled = 0L;
    private static String MAC = null;

    public static String generate() {
        StringBuffer uuid = new StringBuffer(32);
        uuid.replace(0, 31, "00000000000000000000000000000000");
        long time = new GregorianCalendar().getTimeInMillis();
        while (time == lastTimeCalled) {
            long tmp = time;
            int i = 0;
            while ((double)i < Math.random() * 10000.0) {
                tmp -= (long)i;
                ++i;
            }
            time = new GregorianCalendar().getTimeInMillis();
        }
        lastTimeCalled = time;
        long timeLow = (time & 0xFFFFFFFL) * 10L;
        long timeMid = (time >> 16 & 0xFFFFL) * 10L;
        long timeHigh = (time >> 24 & 0xFFFL) * 10L;
        String hex = Long.toHexString(timeLow);
        int len = hex.length();
        if (len > 8) {
            hex = hex.substring(len - 8, len);
        }
        len = hex.length();
        uuid.replace(8 - len, 8, hex);
        hex = Long.toHexString(timeMid);
        len = hex.length();
        if (len > 4) {
            hex = hex.substring(len - 4, len);
        }
        len = hex.length();
        uuid.replace(12 - hex.length(), 12, hex);
        hex = Long.toHexString(timeHigh);
        len = hex.length();
        if (len > 4) {
            hex = hex.substring(len - 4, len);
        }
        len = hex.length();
        uuid.replace(16 - len, 16, hex);
        char c = uuid.charAt(12);
        long l = Character.getNumericValue(c) & 0xF;
        hex = Long.toHexString(l += 64L);
        len = hex.length();
        uuid.replace(12, 13, hex.substring(len - 1));
        long clockSequence = (long)(Math.random() * Math.pow(2.0, 14.0)) & 0x3FFFL;
        hex = Long.toHexString(clockSequence);
        len = hex.length();
        if (len > 4) {
            hex = hex.substring(len - 4, len);
        }
        len = hex.length();
        uuid.replace(20 - len, 20, hex);
        c = uuid.charAt(16);
        l = Character.getNumericValue(c) & 0x3F ^ 0x80;
        uuid.replace(16, 17, hex.substring(len - 1));
        String MAC = UUID.getMAC();
        uuid.replace(20, 32, MAC);
        uuid.insert(20, '-');
        uuid.insert(16, '-');
        uuid.insert(12, '-');
        uuid.insert(8, '-');
        return uuid.toString();
    }

    private static String getMAC() {
        String osName = System.getProperty("os.name").toLowerCase();
        if (osName.indexOf("windows") != -1) {
            if (MAC == null) {
                Process proc = null;
                try {
                    String line;
                    proc = Runtime.getRuntime().exec("ipconfig /all");
                    BufferedReader br = new BufferedReader(new InputStreamReader(proc.getInputStream()));
                    while ((line = br.readLine()) != null) {
                        if (line.indexOf("Physical Address") == -1) continue;
                        String[] split = line.toLowerCase().split(":");
                        String rawMAC = split[1];
                        String[] MACBytes = rawMAC.trim().split("-");
                        MAC = "";
                        int i = 0;
                        while (i < 6) {
                            MAC = String.valueOf(MAC) + MACBytes[i];
                            ++i;
                        }
                        return MAC;
                    }
                }
                catch (IOException iOException) {}
            } else {
                return MAC;
            }
        }
        try {
            MessageDigest md = MessageDigest.getInstance("SHA-1");
            Runtime rt = Runtime.getRuntime();
            long freeMemory = rt.freeMemory();
            long maxMemory = rt.maxMemory();
            long totalMemory = rt.totalMemory();
            File cwd = new File(".");
            String[] list = cwd.list();
            String seed = Long.toHexString(freeMemory + maxMemory + totalMemory);
            int i = 0;
            while (i < list.length) {
                seed = String.valueOf(seed) + list[i];
                ++i;
            }
            md.update(seed.getBytes());
            byte[] digest = new byte[20];
            md.digest(digest, 0, 20);
            MAC = "";
            int i2 = 0;
            while (i2 < 6) {
                String hex = Long.toHexString(digest[i2]);
                if (hex.length() > 2) {
                    hex = hex.substring(hex.length() - 2);
                }
                if (hex.length() < 2) {
                    hex = "0" + hex;
                }
                MAC = String.valueOf(MAC) + hex;
                ++i2;
            }
            return MAC;
        }
        catch (NoSuchAlgorithmException noSuchAlgorithmException) {
        }
        catch (DigestException digestException) {}
        File cwd = new File(".");
        String[] list = cwd.list();
        Runtime rt = Runtime.getRuntime();
        long[] octet = new long[6];
        octet[0] = Math.round((double)rt.freeMemory() * Math.random() * 255.0 * (double)list.length);
        octet[1] = Math.round((double)rt.maxMemory() * Math.random() * 128.0 * (double)list.length);
        octet[2] = Math.round((double)rt.totalMemory() * Math.random() * 64.0);
        MAC = "";
        int i = 0;
        while (i < 3) {
            String hex = Long.toHexString(octet[i]);
            MAC = String.valueOf(MAC) + hex.substring(hex.length() - 4);
            ++i;
        }
        return MAC;
    }

    public static String generateURN() {
        return "urn:uuid:" + UUID.generate();
    }

    public static void main(String[] args) {
        int count = 100;
        System.out.println("Generating " + count + " test URNs ...");
        long start = System.currentTimeMillis();
        int i = 0;
        while (i < count) {
            System.out.println(UUID.generateURN());
            ++i;
        }
        long end = System.currentTimeMillis();
        System.out.println("Generated " + count + " URN's at rate of " + Math.round((double)count / (double)(end - start) * 1000.0) + " per second");
    }
}

