/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.query;

import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.consumer.query.Query;
import org.eclipse.ohf.ihe.xds.consumer.query.QueryBuilder;
import org.eclipse.ohf.ihe.xds.consumer.query.QueryBuilderUtils;

public class GetDocumentsQuery
extends Query {
    private GetDocumentsQuery() {
    }

    public GetDocumentsQuery(String[] docIDs, boolean isUUID) throws MalformedQueryException {
        if (docIDs == null) {
            throw new MalformedQueryException("Null document ID. Cannot proceed with query.");
        }
        if (docIDs.length == 0) {
            throw new MalformedQueryException("No document ID. Cannot proceed with query.");
        }
        this.select.add("doc.id");
        this.from.add("ExtrinsicObject doc");
        if (isUUID) {
            StringBuffer clause = new StringBuffer();
            clause.append("doc.id");
            if (docIDs.length > 1) {
                clause.append(" IN ");
            } else {
                clause.append(" = ");
            }
            String[] idValues = new String[docIDs.length];
            int i = 0;
            while (i < docIDs.length) {
                idValues[i] = String.valueOf('\'') + docIDs[i] + '\'';
                ++i;
            }
            clause.append('(');
            clause.append(QueryBuilderUtils.buildListArgs(idValues));
            clause.append(')');
            this.where.add(clause.toString());
        } else {
            GetDocumentsQuery subQuery = new GetDocumentsQuery();
            subQuery.select.add("doc.id");
            subQuery.from.add("ExtrinsicObject doc");
            subQuery.from.add("ExternalIdentifier uId");
            subQuery.where.add(QueryBuilderUtils.buildIdClause("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab", docIDs));
            QueryBuilder qb = new QueryBuilder(subQuery);
            this.where.add("doc.id IN (" + qb.build() + ")");
        }
    }
}

