/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.query;

import java.util.Iterator;
import java.util.List;
import org.eclipse.ohf.ihe.xds.consumer.query.MalformedQueryException;
import org.eclipse.ohf.ihe.xds.consumer.query.Query;

public class QueryBuilder {
    private Query query;

    public QueryBuilder(Query query) {
        this.query = query;
    }

    public String build() throws MalformedQueryException {
        if (this.query.select.isEmpty()) {
            throw new MalformedQueryException("SELECT arguments are empty.");
        }
        if (this.query.from.isEmpty()) {
            throw new MalformedQueryException("FROM arguments are empty.");
        }
        StringBuffer queryString = new StringBuffer();
        queryString.append("SELECT ");
        queryString.append(this.buildListArgs(this.query.select));
        queryString.append(" ");
        queryString.append("FROM ");
        queryString.append(this.buildListArgs(this.query.from));
        queryString.append(" ");
        if (!this.query.where.isEmpty()) {
            queryString.append("WHERE ");
            queryString.append(this.buildANDListArgs(this.query.where));
            queryString.append(" ");
        }
        return queryString.toString();
    }

    private String buildListArgs(List args) {
        StringBuffer list = new StringBuffer("");
        Iterator i = args.iterator();
        while (i.hasNext()) {
            list.append(i.next().toString());
            if (!i.hasNext()) continue;
            list.append(", ");
        }
        return list.toString();
    }

    private String buildANDListArgs(List args) {
        StringBuffer list = new StringBuffer("");
        Iterator i = args.iterator();
        while (i.hasNext()) {
            list.append(i.next().toString());
            if (!i.hasNext()) continue;
            list.append(" AND ");
        }
        return list.toString();
    }
}

