/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.client;

import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClient;
import org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientException;
import org.eclipse.ohf.ihe.atna.audit.messages.ActorStartMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ActorStopMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ExportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.ImportMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.PatientRecordMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.QueryMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.UserAuthenticationMessage;
import org.eclipse.ohf.ihe.atna.audit.util.TimeStamp;

public class ATNAAuditClientDummy
implements ATNAAuditClient {
    private static Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.audit.client.ATNAAuditClientDummy");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public void audit(int eventOutcome, String initiatingUser, String transactionPayload) {
        logger.info((Object)("AUDIT: " + eventOutcome + ", " + initiatingUser + ", " + transactionPayload));
    }

    public void auditQueryEvent(int eventOutcome, String initiatingUser, String registryID, String queryText) throws ATNAAuditClientException {
        QueryMessage qMessage;
        try {
            qMessage = new QueryMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initiatingUser, null, registryID, null, initiatingUser, queryText);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending QueryEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)qMessage);
    }

    public void auditPHIImportEvent(int eventOutcome, String initatingUser, String dataSourceId, String[] patientId, String importedData) throws ATNAAuditClientException {
        ImportMessage iMessage;
        try {
            iMessage = new ImportMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initatingUser, dataSourceId, patientId, importedData);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PHIImportEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)iMessage);
    }

    public void auditPHIExportEvent(int eventOutcome, String initatingUser, String dataRecipientId, String exportedDataId, String patientId) throws ATNAAuditClientException {
        ExportMessage eMessage;
        try {
            eMessage = new ExportMessage(TimeStamp.generateUTCDateTime(), eventOutcome, initatingUser, dataRecipientId, exportedDataId, patientId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PHIExportEvent Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)eMessage);
    }

    public void auditActorStartEvent(int eventOutcome, String applicationName, String userName) throws ATNAAuditClientException {
        ActorStartMessage sMessage;
        try {
            sMessage = new ActorStartMessage(TimeStamp.generateUTCDateTime(), eventOutcome, applicationName, userName);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending ActorStartStopMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)sMessage);
    }

    public void auditActorStopEvent(int eventOutcome, String applicationName, String userName) throws ATNAAuditClientException {
        ActorStopMessage sMessage;
        try {
            sMessage = new ActorStopMessage(TimeStamp.generateUTCDateTime(), eventOutcome, applicationName, userName);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending ActorStartStopMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)sMessage);
    }

    public void auditPatientRecordReadEvent(int eventOutcome, String initiatingUser, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "R", initiatingUser, patientId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordCreateEvent(int eventOutcome, String initiatingUser, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "C", initiatingUser, patientId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordUpdateEvent(int eventOutcome, String initiatingUser, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "U", initiatingUser, patientId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditPatientRecordDeleteEvent(int eventOutcome, String initiatingUser, String patientId) throws ATNAAuditClientException {
        PatientRecordMessage pMessage;
        try {
            pMessage = new PatientRecordMessage(TimeStamp.generateUTCDateTime(), eventOutcome, "D", initiatingUser, patientId);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)pMessage);
    }

    public void auditUserAuthenticationLoginEvent(int eventOutcome, String initiatingUser, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws ATNAAuditClientException {
        UserAuthenticationMessage uMessage;
        try {
            uMessage = new UserAuthenticationMessage(TimeStamp.generateUTCDateTime(), eventOutcome, true, initiatingUser, initiatingUserName, 2, initiatingUserNodeIP, authenticatingNodeIP);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)uMessage);
    }

    public void auditUserAuthenticationLogoutEvent(int eventOutcome, String initiatingUser, String initiatingUserName, String initiatingUserNodeIP, String authenticatingNodeIP) throws ATNAAuditClientException {
        UserAuthenticationMessage uMessage;
        try {
            uMessage = new UserAuthenticationMessage(TimeStamp.generateUTCDateTime(), eventOutcome, false, initiatingUser, initiatingUserName, 2, initiatingUserNodeIP, authenticatingNodeIP);
        }
        catch (ParserConfigurationException e) {
            logger.fatal((Object)"Unable to produce audit message. ParserConfigurationException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ParserConfigurationException", e);
        }
        catch (FactoryConfigurationError e) {
            logger.fatal((Object)"Unable to produce audit message. FactoryConfigurationError", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. FactoryConfigurationError", e);
        }
        catch (ATNAException e) {
            logger.fatal((Object)"Unable to produce audit message. ATNAException", (Throwable)e);
            throw new ATNAAuditClientException("Unable to produce audit message. ATNAException", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Sending PatientRecordMessage Audit message.");
        }
        AtnaAgentFactory.getAtnaAgent().getAudit().eventTriggered((AuditMessage)uMessage);
    }
}

