/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf.builder;

import java.io.IOException;
import java.net.Socket;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.UnknownHostException;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.rhio.IheUri;

public class RhioConfigBuilderUtils {
    static final Logger mLogger = Logger.getLogger(RhioConfigBuilderUtils.class);

    public static IheUri createIheUri(org.eclipse.ohf.bridge.conf.model.IheUri pUrl, boolean isHttp, boolean pVerifyUri) throws URISyntaxException {
        if (pUrl == null) {
            return null;
        }
        IheUri uri = new IheUri();
        uri.setSecured(RhioConfigBuilderUtils.verifyUriStracture(pUrl.getSecured(), isHttp, pVerifyUri));
        uri.setUnsecured(RhioConfigBuilderUtils.verifyUriStracture(pUrl.getUnsecured(), isHttp, pVerifyUri));
        return uri;
    }

    private static String verifyUriStracture(String pString, boolean pIsHttp, boolean pVerifyUri) throws URISyntaxException {
        if (pString == null) {
            return null;
        }
        String urlString = Utils.trimNull(pString);
        URI uri = null;
        if (!Utils.isEmptyOrNull(urlString)) {
            uri = new URI(urlString);
            String schema = uri.getScheme();
            if (!pIsHttp) {
                if (!(schema.equalsIgnoreCase("MLLP") || schema.equalsIgnoreCase("MLLPS") || schema.equalsIgnoreCase("UDP"))) {
                    throw new IllegalArgumentException(String.valueOf(pString) + " should be an MLLP/MLLPS/UDP URI");
                }
            } else if (!schema.equalsIgnoreCase("HTTP") && !schema.equalsIgnoreCase("HTTPS")) {
                throw new IllegalArgumentException(String.valueOf(pString) + " should be an HTTP/HTTPS URI");
            }
        }
        if (pVerifyUri) {
            RhioConfigBuilderUtils.validateUriExist(uri);
        }
        return uri.toString();
    }

    private static void validateUriExist(URI uri) {
        if (uri.getScheme().equalsIgnoreCase("UDP")) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Not checking UDP URI: " + uri));
            }
        } else {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Trying to open a socket to configured URI: " + uri));
            }
            try {
                Socket socket = new Socket(uri.getHost(), uri.getPort());
                socket.getInputStream();
                socket.getOutputStream();
                socket.close();
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)("success: " + uri));
                }
            }
            catch (UnknownHostException e) {
                if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    mLogger.debug((Object)("error handeling URI " + uri + " exception got: " + e));
                }
                System.err.println("error handeling URI " + uri + " exception got: " + e);
            }
            catch (IOException e) {
                if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    mLogger.debug((Object)("error handeling URI " + uri + " exception got: " + e));
                }
                System.err.println("error handeling URI " + uri + " exception got: " + e);
            }
        }
    }
}

