/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.xds;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.StringReader;
import java.text.SimpleDateFormat;
import java.util.Date;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.conf.Configurations;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class CDAExtractor {
    static final Logger mLogger = Logger.getLogger(CDAExtractor.class);
    private DocumentBuilderFactory cdaFactory;
    private DocumentBuilder cdaParser;
    private Document cdaXmlDoc;
    private XPath xpath;

    public CDAExtractor(String cdaDocument) throws IOException, SAXException, ParserConfigurationException {
        StringReader stringReader = new StringReader(cdaDocument);
        this.cdaFactory = DocumentBuilderFactory.newInstance();
        this.cdaParser = this.cdaFactory.newDocumentBuilder();
        this.cdaXmlDoc = this.cdaParser.parse(new InputSource(stringReader));
        this.xpath = XPathFactory.newInstance().newXPath();
    }

    private Node searchPath(String searchExpr, Document searchDoc) {
        try {
            Node objectNode = (Node)this.xpath.evaluate(searchExpr, searchDoc, XPathConstants.NODE);
            return objectNode;
        }
        catch (XPathExpressionException xpee) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)("Error Finding node: " + searchExpr), (Throwable)xpee);
            }
            return null;
        }
    }

    private NodeList searchPath(String searchExpr, Document searchDoc, QName nodeType) {
        try {
            NodeList objectNode = (NodeList)this.xpath.evaluate(searchExpr, searchDoc, nodeType);
            return objectNode;
        }
        catch (XPathExpressionException xpee) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)("Error Finding node: " + searchExpr), (Throwable)xpee);
            }
            return null;
        }
    }

    private String getAttributeValue(String searchExpr, String attribute, Document searchDoc) {
        Node a;
        Node n = this.searchPath(searchExpr, searchDoc);
        if (n != null && (a = n.getAttributes().getNamedItem(attribute)) != null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Found attribute named: " + a.getNodeName()));
            }
            return a.getTextContent();
        }
        return "";
    }

    private String getElementValue(String searchExpr, Document searchDoc) {
        Node n = this.searchPath(searchExpr, searchDoc);
        if (n != null) {
            return n.getTextContent();
        }
        return "";
    }

    private String transform(Document xmlDoc) {
        DOMSource source = new DOMSource(xmlDoc);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        StreamResult result = new StreamResult(os);
        try {
            Transformer xformer = TransformerFactory.newInstance().newTransformer();
            xformer.transform(source, result);
        }
        catch (Exception e) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"Error transforming output.", (Throwable)e);
            }
            return null;
        }
        return os.toString();
    }

    public String getDocEntry() throws ParserConfigurationException, SAXException, IOException {
        String temp;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document docEntryDoc = parser.parse(Configurations.getGlobalConfigurations().getDocumentEntryBase());
        Node node = this.searchPath("/DocumentEntry/author/authorInstitution", docEntryDoc);
        if (node != null && node.hasChildNodes()) {
            NodeList nl = node.getChildNodes();
            int i = 0;
            while (i < nl.getLength()) {
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)("<AIF> Node " + nl.item(i).getNodeName() + "; Type: " + nl.item(i).getNodeType()));
                }
                ++i;
            }
        } else if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"<AIF> has no child nodes: /DocumentEntry/authorInstitution");
        }
        node = this.searchPath("/DocumentEntry/authorInstitution/Component[1]/Value", docEntryDoc);
        if (node != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/author/assignedAuthor/representedOrganization/name", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/authorInstitution/Component[2]/Value", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/author/assignedAuthor/representedOrganization/id", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/title/LocalizedString/@value", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/title", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/creationTime", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/effectiveTime", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/languageCode", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/languageCode", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/patientId/Component[1]/Value", docEntryDoc)) != null) {
            node.setTextContent(this.getAttributeValue("/ClinicalDocument/recordTarget/patientRole/id", "extension", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/typeCode/code", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/code/@code", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/typeCode/displayName/LocalizedString/@value", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/code/@displayName", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/typeCode/displayName/LocalizedString/@schemaName", docEntryDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/code/@codeSystemName", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-3\"]", docEntryDoc)) != null) {
            node = this.searchPath("/DocumentEntry/sourcePatientId", docEntryDoc).cloneNode(true);
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-5\"]/Component[1]/Component[1]/Value", docEntryDoc)) != null) {
            temp = this.getElementValue("/ClinicalDocument/recordTarget/patientRole/patient/name/family", this.cdaXmlDoc);
            node.setTextContent(temp);
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-5\"]/Component[2]/Value", docEntryDoc)) != null) {
            temp = this.getElementValue("/ClinicalDocument/recordTarget/patientRole/patient/name/given", this.cdaXmlDoc);
            node.setTextContent(temp);
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-7\"]/Component[1]/Value", docEntryDoc)) != null) {
            temp = this.getAttributeValue("/ClinicalDocument/recordTarget/patientRole/patient/birthTime", "value", this.cdaXmlDoc);
            node.setTextContent(temp);
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-8\"]/Component[1]/Value", docEntryDoc)) != null) {
            temp = this.getAttributeValue("/ClinicalDocument/recordTarget/patientRole/patient/administrativeGenderCode", "code", this.cdaXmlDoc);
            node.setTextContent(temp);
        }
        if ((node = this.searchPath("/DocumentEntry/sourcePatientInfo/Field[@ItemNo=\"PID-11\"]/Component[1]/Value", docEntryDoc)) != null) {
            temp = this.getElementValue("/ClinicalDocument/recordTarget/patientRole/addr/streetAddressLine", this.cdaXmlDoc);
            node.setTextContent(temp);
        }
        return this.transform(docEntryDoc);
    }

    public String getSubmissionSet() throws ParserConfigurationException, SAXException, IOException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder parser = factory.newDocumentBuilder();
        Document submitSetDoc = parser.parse(Configurations.getGlobalConfigurations().getSubmissionSetBase());
        Node node = this.searchPath("/SubmissionSet/authorInstitution/Component[1]/Value", submitSetDoc);
        if (node != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/author/assignedAuthor/representedOrganization/name", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/SubmissionSet/authorInstitution/Component[2]/Value", submitSetDoc)) != null) {
            node.setTextContent(this.getElementValue("/ClinicalDocument/author/assignedAuthor/representedOrganization/id", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/SubmissionSet/patientId/Component[1]/Value", submitSetDoc)) != null) {
            node.setTextContent(this.getAttributeValue("/ClinicalDocument/recordTarget/patientRole/id", "extension", this.cdaXmlDoc));
        }
        if ((node = this.searchPath("/SubmissionSet/submissionTime", submitSetDoc)) != null) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMdd");
            node.setTextContent(sdf.format(new Date()));
        }
        return this.transform(submitSetDoc);
    }
}

