/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.soap;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.util.Iterator;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.xml.soap.AttachmentPart;
import javax.xml.soap.MessageFactory;
import javax.xml.soap.SOAPBody;
import javax.xml.soap.SOAPElement;
import javax.xml.soap.SOAPEnvelope;
import javax.xml.soap.SOAPMessage;
import javax.xml.soap.SOAPPart;
import org.apache.axis2.saaj.SOAPElementImpl;
import org.apache.axis2.util.XMLUtils;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgent;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.xds.soap.SoapAttachment;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapClientException;
import org.w3c.dom.Document;

public class XDSSoapClientAXIS2
implements XDSSoapClient {
    private static Logger logger;
    private static final String SOAP_ENV_NS = "http://schemas.xmlsoap.org/soap/envelope/";
    private static final String SOAP_SEC_NS = "http://schemas.xmlsoap.org/soap/security/2000-12";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.soap.XDSSoapClientAXIS2");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public byte[] send(String request, SoapAttachment[] attachments, URI uri) throws Exception {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Begin SOAP message constuction.");
        }
        MessageFactory mf = MessageFactory.newInstance();
        SOAPMessage msg = mf.createMessage();
        msg.setProperty("javax.xml.soap.write-xml-declaration", (Object)"true");
        msg.setProperty("javax.xml.soap.character-set-encoding", (Object)"utf-8");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SOAP MESSAGE: Added XML declaration and character set encoding.");
        }
        SOAPPart sp = msg.getSOAPPart();
        SOAPEnvelope se = sp.getEnvelope();
        se.addNamespaceDeclaration("soapenv", SOAP_ENV_NS);
        se.addNamespaceDeclaration("SOAP-SEC", SOAP_SEC_NS);
        se.addAttribute(se.createName("soapenv:actor"), "some-uri");
        se.addAttribute(se.createName("soapenv:mustUnderstand"), "1");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SOAP MESSAGE: Added namespace declarations.");
        }
        Document requestDoc = XMLUtils.newDocument((InputStream)new ByteArrayInputStream(request.getBytes()));
        requestDoc.getFirstChild().setPrefix("rs");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n\n************************\nDOC ELEMENT URI: " + requestDoc.getDocumentElement().getNamespaceURI() + "\n************************\n\n"));
            logger.debug((Object)("\n\n************************\nDOC ELEMENT PREFIX:" + requestDoc.getDocumentElement().getPrefix() + "\n************************\n\n"));
        }
        se.getBody().addDocument(requestDoc);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("\n\n************************\nRESET DOC ELEMENT URI: " + requestDoc.getDocumentElement().getNamespaceURI() + "\n************************\n\n"));
            logger.debug((Object)("\n\n************************\nRESET ELEMENT PREFIX:" + requestDoc.getDocumentElement().getPrefix() + "\n************************\n\n"));
        }
        se.getBody().addAttribute(se.createName("SOAP-SEC:id", "", null), "Body");
        se.getBody().removeNamespaceDeclaration("rs");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"SOAP MESSAGE: Body is set");
        }
        if (attachments != null) {
            int i = 0;
            while (i < attachments.length) {
                msg.setProperty("enableSwA", (Object)"true");
                msg.setProperty("enableMTOM", (Object)"false");
                AttachmentPart ap = msg.createAttachmentPart((Object)attachments[i].getData(), attachments[i].getMimeType());
                ap.setContentId(attachments[i].getContentId());
                msg.addAttachmentPart(ap);
                ++i;
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SOAP MESSAGE: Attatchements added");
            }
        }
        msg.saveChanges();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"\nSOAP REQUEST MESSAGE *********************************");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)bos);
            String logMsg = new String(bos.toByteArray());
            logger.debug((Object)logMsg);
            bos.close();
        }
        logger.info((Object)"Sending SOAPMessage ......................... ");
        SOAPMessage response = null;
        try {
            AtnaAgent agent = AtnaAgentFactory.getAtnaAgent();
            response = agent.send(msg, uri);
        }
        catch (Exception e) {
            logger.fatal((Object)e);
            throw e;
        }
        logger.info((Object)"Response recieved.");
        if (response == null) {
            logger.error((Object)"NO REPLY SOAP MESSAGE WAS RECIEVED");
            throw new XDSSoapClientException("NO REPLY SOAP MESSAGE WAS RECIEVED");
        }
        SOAPPart rsp = response.getSOAPPart();
        if (sp == null) {
            logger.error((Object)"NULL SOAP PART");
            throw new XDSSoapClientException("NULL SOAP PART");
        }
        SOAPEnvelope rse = rsp.getEnvelope();
        if (rse == null) {
            logger.error((Object)"NULL SOAP ENVELOPE");
            throw new XDSSoapClientException("NULL SOAP ENVELOPE");
        }
        logger.info((Object)"\nSOAP RESPONSE MESSAGE *********************************");
        logger.info((Object)"\n*****************************************************\n");
        SOAPBody rbody = response.getSOAPBody();
        if (rbody == null) {
            logger.error((Object)"NULL SOAP BODY");
            throw new XDSSoapClientException("NULL SOAP BODY");
        }
        Iterator iter = rbody.getChildElements();
        Object obj = null;
        SOAPElement rootElem = null;
        while (iter.hasNext()) {
            obj = iter.next();
            if (!(obj instanceof SOAPElement)) continue;
            rootElem = obj;
            break;
        }
        if (rootElem == null) {
            logger.error((Object)"NO PAYLOAD WITHIN SOAP BODY. EMPTY RESPONSE.");
            throw new XDSSoapClientException("NO PAYLOAD WITHIN SOAP BODY. EMPTY RESPONSE.");
        }
        if (rootElem.getNamespaceURI().equalsIgnoreCase(SOAP_ENV_NS) && rootElem.getLocalName().equalsIgnoreCase("fault")) {
            logger.error((Object)"SOAP FAULT");
            ByteArrayOutputStream bos = new ByteArrayOutputStream();
            response.writeTo((OutputStream)bos);
            String logMsg = new String(bos.toByteArray());
            logger.error((Object)("Fault Message:\n" + logMsg));
            bos.close();
            throw new XDSSoapClientException("SOAP FAULT");
        }
        ByteArrayOutputStream boas = new ByteArrayOutputStream();
        ((SOAPElementImpl)rootElem).serialize((OutputStream)boas);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Successfully parsed response out of SOAP encapsulation.");
        }
        return boas.toByteArray();
    }

    private String parseOutResponse(String message) {
        String patternMatchRegex = "(<soap(-)?env:Body([^>])*>(.*)</soap(-)?env:Body>)";
        String patternReplaceRegex = "(<soap(-)?env:Body([^>])*>)|</soap(-)?env:Body>";
        int regexFlags = 34;
        Pattern p = Pattern.compile(patternMatchRegex, regexFlags);
        Matcher m = p.matcher(message);
        String returnMessage = "";
        if (m.find()) {
            returnMessage = message.substring(m.start(), m.end());
        }
        m.reset();
        returnMessage = Pattern.compile(patternReplaceRegex, regexFlags).matcher(returnMessage).replaceAll("").trim();
        return returnMessage;
    }
}

