/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.audit.messages;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;
import java.io.Serializable;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditActiveParticipantRoleID;
import org.eclipse.ohf.ihe.atna.audit.codes.AuditEventID;
import org.eclipse.ohf.ihe.atna.audit.element.ActiveParticipantType;
import org.eclipse.ohf.ihe.atna.audit.element.CodedValueType;
import org.eclipse.ohf.ihe.atna.audit.element.EventIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.element.ParticipantObjectIdentificationType;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;

public class ImportMessage
extends AuditMessage
implements Serializable {
    private static final long serialVersionUID = 1L;
    public static final String PROP_SAMPLE_PROPERTY = "sampleProperty";
    private String sampleProperty;
    private PropertyChangeSupport propertySupport;

    public String getSampleProperty() {
        return this.sampleProperty;
    }

    public void setSampleProperty(String value) {
        String oldValue = this.sampleProperty;
        this.sampleProperty = value;
        this.propertySupport.firePropertyChange(PROP_SAMPLE_PROPERTY, oldValue, this.sampleProperty);
    }

    public void addPropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.addPropertyChangeListener(listener);
    }

    public void removePropertyChangeListener(PropertyChangeListener listener) {
        this.propertySupport.removePropertyChangeListener(listener);
    }

    public ImportMessage() throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        this.setMessagetype("import");
        if (this.getEventIdentification() != null) {
            this.getEventIdentification().setEventActionCode("C");
            CodedValueType eventIDValue = new CodedValueType();
            eventIDValue.setCode("110107");
            eventIDValue.setCodeSystemName("DCM");
            eventIDValue.setDisplayName("Import");
            this.getEventIdentification().setEventID(eventIDValue);
        }
    }

    public ImportMessage(String eventDateTime, int eventOutcomeIndicator, String userIDActiveParticipantConsumer, String userIDActiveParticipantRegistry, String[] participantObjectId, String participantObjectQuery, String sourceId) throws ParserConfigurationException, FactoryConfigurationError, ATNAException {
        super(sourceId);
        this.setMessagetype("import");
        EventIdentificationType eventId = new EventIdentificationType();
        eventId.setEventActionCode("C");
        eventId.setEventDateTime(eventDateTime);
        eventId.setEventOutcomeIndicator(eventOutcomeIndicator);
        eventId.setEventID(new AuditEventID.Import());
        this.setEventIdentification(eventId);
        ActiveParticipantType activeParticipantDocRegistry = null;
        activeParticipantDocRegistry = new ActiveParticipantType(userIDActiveParticipantRegistry);
        activeParticipantDocRegistry.setUserIsRequestor(true);
        activeParticipantDocRegistry.setRoleIDCode(new AuditActiveParticipantRoleID.Destination());
        this.setActiveParticipant(activeParticipantDocRegistry);
        ActiveParticipantType activeParticipantDocConsumer = null;
        activeParticipantDocConsumer = new ActiveParticipantType(userIDActiveParticipantConsumer);
        activeParticipantDocConsumer.setUserIsRequestor(false);
        activeParticipantDocConsumer.setRoleIDCode(new AuditActiveParticipantRoleID.SourceMedia());
        this.setActiveParticipant(activeParticipantDocConsumer);
        int i = 0;
        while (i < participantObjectId.length) {
            ParticipantObjectIdentificationType participantObject = new ParticipantObjectIdentificationType();
            participantObject.setParticipantObjectTypeCode((short)1);
            participantObject.setParticipantObjectTypeCodeRoleName("patient");
            CodedValueType objectIDTypeCode = new CodedValueType();
            objectIDTypeCode.setCode("2");
            participantObject.setParticipantObjectIDTypeCode(objectIDTypeCode);
            participantObject.setParticipantObjectID(participantObjectId[i]);
            byte[] b = participantObjectQuery.getBytes();
            participantObject.setParticipantObjectQuery(b);
            this.setParticipationObjectIdentification(participantObject);
            ++i;
        }
    }
}

