/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.consumer.storedquery;

import org.eclipse.ohf.ihe.xds.consumer.storedquery.MalformedStoredQueryException;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQuery;
import org.eclipse.ohf.ihe.xds.consumer.storedquery.StoredQueryBuilderUtils;

public class GetDocumentsQuery
extends StoredQuery {
    public GetDocumentsQuery(String[] docIDs, boolean isUUID) throws MalformedStoredQueryException {
        super("urn:uuid:5c4f972b-d56b-40ac-a5fc-c8ca9b40b9d4");
        if (docIDs == null) {
            throw new MalformedStoredQueryException("Null document ID. Cannot proceed with query.");
        }
        if (docIDs.length == 0) {
            throw new MalformedStoredQueryException("No document ID. Cannot proceed with query.");
        }
        String[] idValues = new String[docIDs.length];
        int i = 0;
        while (i < docIDs.length) {
            idValues[i] = String.valueOf('\'') + docIDs[i] + '\'';
            ++i;
        }
        String clause = String.valueOf('(') + StoredQueryBuilderUtils.buildListArgs(idValues) + ')';
        if (isUUID) {
            this.queryParameters.put("$XDSDocumentEntryEntryUUID", clause);
        } else {
            this.queryParameters.put("$XDSDocumentEntryUniqueId", clause);
        }
    }

    public GetDocumentsQuery(String[] docIDs, boolean isUUID, String homeCommunityId) throws MalformedStoredQueryException {
        this(docIDs, isUUID);
        if (homeCommunityId != null && homeCommunityId.length() > 0) {
            this.homeCommunityId = homeCommunityId;
        }
    }
}

