/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.atna.agent;

import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.Socket;
import java.net.URI;
import java.net.UnknownHostException;
import java.security.KeyManagementException;
import java.security.NoSuchAlgorithmException;
import javax.net.ssl.SSLHandshakeException;
import javax.xml.parsers.FactoryConfigurationError;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentService;
import org.eclipse.ohf.ihe.atna.audit.ATNAException;
import org.eclipse.ohf.ihe.atna.audit.AuditService;
import org.eclipse.ohf.ihe.atna.audit.messages.AuditMessage;
import org.eclipse.ohf.ihe.atna.audit.messages.NodeAuthenticationFailureMessage;
import org.eclipse.ohf.ihe.atna.transport.TransporterImpl;
import org.eclipse.ohf.ihe.atna.transport.service.transporter.TransporterService;
import org.eclipse.ohf.ihe.common.atna.NoSecurityDomainException;

public class AtnaAgent
implements AtnaAgentService {
    private static final Logger logger;
    private static URI defaultAuditRepository;
    private boolean doAudit = true;
    private AuditService audit = null;
    private TransporterService m_transporter = null;
    private String initiatingUser;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.atna.agent.AtnaAgent");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        defaultAuditRepository = URI.create("syslog://lswin10.dfw.ibm.com:515");
    }

    public AtnaAgent() {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Thread.currentThread().setContextClassLoader(classLoader);
        this.setTransporter((TransporterService)new TransporterImpl());
        this.setAudit(new AuditService());
        this.getAudit().setAuditRepository(defaultAuditRepository);
    }

    public static String exampleMessage() {
        return "<55>Oct 18 11:23:07 192.168.0.112 mckesson1:<AuditMessage><EventIdentification EventDateTime=\"2006-08-10T13:22:13\" EventOutcomeIndicator=\"4\" EventActionCode=\"E\"><EventID code=\"110114\" codeSystemName=\"DCM\" displayName=\"User Authentication\"/><EventTypeCode code=\"110122\" codeSystemName=\"DCM\" displayName=\"Login\"/></EventIdentification><ActiveParticipant UserID=\"peterh\" AlternativeUserID=\"peterh\" NetworkAccessPointID=\"192.168.0.112\" NetworkAccessPointTypeCode=\"2\" UserName=\"peterh\" UserIsRequestor=\"true\"><RoleIDCode code=\"110153\" codeSystemName=\"DCM\" displayName=\"Source\"/></ActiveParticipant><ActiveParticipant UserID=\"peterh\" NetworkAccessPointID=\"192.168.0.112\" NetworkAccessPointTypeCode=\"2\" UserIsRequestor=\"false\"><RoleIDCode code=\"110153\" codeSystemName=\"DCM\" displayName=\"Source\"/></ActiveParticipant><ActiveParticipant UserID=\"peterh\" NetworkAccessPointID=\"2006-08-10T13:22:130\" NetworkAccessPointTypeCode=\"2\" UserIsRequestor=\"false\"><RoleIDCode code=\"110152\" codeSystemName=\"DCM\" displayName=\"Destination\"/></ActiveParticipant><AuditSourceIdentification AuditSourceID=\"Quovadx IHE Demo\" AuditEnterpriseSiteID=\"Quovadx\"><AuditSourceTypeCode code=\"4\" displayName=\"Application Software\"/></AuditSourceIdentification></AuditMessage>";
    }

    protected void auditReportNodeAuthenticationFailure(URI uri, String reason) {
        AuditService audit = AtnaAgentFactory.getAtnaAgent().getAudit();
        NodeAuthenticationFailureMessage message = null;
        try {
            message = new NodeAuthenticationFailureMessage(0, "", "Secure Node", uri, reason, this.getAuditSourceId());
        }
        catch (ParserConfigurationException e1) {
            logger.error((Object)("Error constructing ATNA Audit Message. Reason " + e1.getLocalizedMessage()));
        }
        catch (FactoryConfigurationError e1) {
            logger.error((Object)("Error constructing ATNA Audit Message. Reason " + e1.getLocalizedMessage()));
        }
        catch (ATNAException e1) {
            logger.error((Object)("Error constructing ATNA Audit Message. Reason " + e1.getLocalizedMessage()));
        }
        if (message != null) {
            audit.eventTriggered((AuditMessage)message);
            logger.debug((Object)"Node Authentication Failure message sent to Audit Repository");
        } else {
            logger.error((Object)"Node Authentication Failure event was not logged to ATNA Audit Repository");
        }
    }

    public InputStream getInputStream(URI uri) throws NoSecurityDomainException, MalformedURLException, IOException, NoSuchAlgorithmException {
        try {
            InputStream is = this.getTransporter().getInputStream(uri);
            return is;
        }
        catch (SSLHandshakeException e) {
            logger.error((Object)("Node Authentication Failure with URI " + uri.toString() + " reason: " + e.getLocalizedMessage()));
            this.auditReportNodeAuthenticationFailure(uri, e.getLocalizedMessage());
            throw e;
        }
    }

    public Socket getSocket(URI uri, boolean useTLS) throws KeyManagementException, NoSecurityDomainException, NoSuchAlgorithmException, UnknownHostException, IOException {
        try {
            Socket socket = this.getTransporter().getSocket(uri, useTLS);
            return socket;
        }
        catch (SSLHandshakeException e) {
            logger.error((Object)("Node Authentication Failure with URI " + uri.toString() + " reason: " + e.getLocalizedMessage()));
            this.auditReportNodeAuthenticationFailure(uri, e.getLocalizedMessage());
            throw e;
        }
    }

    private void setTransporter(TransporterService m_transporter) {
        this.m_transporter = m_transporter;
    }

    private TransporterService getTransporter() {
        return this.m_transporter;
    }

    private void setAudit(AuditService audit) {
        this.audit = audit;
    }

    public AuditService getAudit() {
        return this.audit;
    }

    public void eventTriggered(AuditMessage msg) {
        if (this.getAudit() != null) {
            this.audit.eventTriggered(msg);
        }
    }

    public AuditMessage eventPending(String eventType) {
        AuditMessage auditmsg = null;
        if (this.getAudit() != null) {
            auditmsg = this.audit.eventPending(eventType);
        }
        return auditmsg;
    }

    public void setAuditRepository(URI hosturi) {
        this.audit.setAuditRepository(hosturi);
    }

    public URI getAuditRepository() {
        return this.audit.getAuditRepository();
    }

    public static void setDefaultAuditRepository(URI hosturi) {
        defaultAuditRepository = hosturi;
    }

    public static URI getDefaultAuditRepository() {
        return defaultAuditRepository;
    }

    public boolean isDoAudit() {
        return this.doAudit;
    }

    public void setDoAudit(boolean doAudit) {
        this.doAudit = doAudit;
        this.getAudit().setDoAudit(doAudit);
    }

    public String getInitiatingUser() {
        return this.initiatingUser;
    }

    public void setInitiatingUser(String initiatingUser) {
        this.initiatingUser = initiatingUser;
    }

    public String getAuditSourceId() {
        return this.getAudit().getAuditSourceId();
    }

    public void setAuditSourceId(String sourceId) {
        this.getAudit().setAuditSourceId(sourceId);
    }
}

