/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.soap;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.util.ByteArrayDataSource;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.OMNamespace;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.om.OMText;
import org.apache.log4j.Logger;
import org.eclipse.ohf.ihe.common.ws.OHFSOAPSenderFactory;
import org.eclipse.ohf.ihe.xds.document.Document;
import org.eclipse.ohf.ihe.xds.soap.AbstractXDSSoapClient;
import org.eclipse.ohf.ihe.xds.soap.XDSSoapConstants;

public class B_XDSSoapClient
extends AbstractXDSSoapClient {
    private static final Logger logger;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.soap.B_XDSSoapClient");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public B_XDSSoapClient() throws Exception {
        super(OHFSOAPSenderFactory.getMTOMSender());
    }

    protected Map buildRequestAttachments(OMElement bodyOMElement, List attachments) throws Exception {
        if (attachments != null && attachments.size() > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Request contains attachments.  Begin building attachment list.");
            }
            HashMap<String, DataHandler> attachmentMap = new HashMap<String, DataHandler>();
            OMFactory omFactory = bodyOMElement.getOMFactory();
            OMNamespace iheNS = omFactory.createOMNamespace("urn:ihe:iti:xds-b:2007", "ihe");
            OMElement lastElement = bodyOMElement.getFirstElement();
            Iterator attachmentIterator = attachments.iterator();
            while (attachmentIterator.hasNext()) {
                Document attachDocument = (Document)attachmentIterator.next();
                DataHandler attachmentPart = new DataHandler((DataSource)new ByteArrayDataSource(attachDocument.getDocumentData(), attachDocument.getDescriptor().getMimeType()));
                OMElement documentAttachmentElement = omFactory.createOMElement("Document", iheNS);
                documentAttachmentElement.addAttribute(omFactory.createOMAttribute("id", null, attachDocument.getDocumentEntryUUID()));
                documentAttachmentElement.addChild((OMNode)omFactory.createOMText((Object)attachmentPart, true));
                lastElement.insertSiblingAfter((OMNode)documentAttachmentElement);
                attachmentMap.put(attachDocument.getDocumentEntryUUID(), attachmentPart);
                lastElement = documentAttachmentElement;
                if (!logger.isDebugEnabled()) continue;
                logger.debug((Object)("Adding document " + attachDocument + " as attachment"));
            }
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"SOAP Attachments Added to Map");
            }
            return attachmentMap;
        }
        return null;
    }

    public List getAttachments() throws Exception {
        return this.getResponseAttachments();
    }

    protected OMElement buildResponseAttachments(OMElement responseOMElement, boolean returnRegistryResponseOnly) throws Exception {
        if (!responseOMElement.getQName().equals(XDSSoapConstants.RETRIEVE_DOCUMENT_SET_RESPONSE_QNAME)) {
            return responseOMElement;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Beginning XDS.b MTOM attachment extraction");
        }
        ArrayList<Document> responseAttachments = new ArrayList<Document>();
        Iterator documentResponseElements = responseOMElement.getChildrenWithName(XDSSoapConstants.DOCUMENT_RESPONSE_QNAME);
        while (documentResponseElements.hasNext()) {
            DataHandler documentBody;
            OMElement documentBodyElement;
            OMElement homeCommunityIdElement;
            OMElement repositoryUniqueIdElement;
            String repositoryUniqueId = null;
            String documentUniqueId = null;
            String homeCommunityId = null;
            OMElement documentResponseElement = (OMElement)documentResponseElements.next();
            OMElement documentUniqueIdElement = documentResponseElement.getFirstChildWithName(XDSSoapConstants.DOCUMENT_UNIQUE_ID_QNAME);
            if (documentUniqueIdElement != null) {
                documentUniqueId = ((OMText)documentUniqueIdElement.getFirstOMChild()).getText();
            }
            if ((repositoryUniqueIdElement = documentResponseElement.getFirstChildWithName(XDSSoapConstants.REPOSITORY_UNIQUE_ID_QNAME)) != null) {
                repositoryUniqueId = ((OMText)repositoryUniqueIdElement.getFirstOMChild()).getText();
            }
            if ((homeCommunityIdElement = documentResponseElement.getFirstChildWithName(XDSSoapConstants.HOME_COMMUNITY_ID_QNAME)) != null) {
                homeCommunityId = ((OMText)homeCommunityIdElement.getFirstOMChild()).getText();
            }
            if ((documentBodyElement = documentResponseElement.getFirstChildWithName(XDSSoapConstants.DOCUMENT_BODY_QNAME)) == null || (documentBody = (DataHandler)((OMText)documentBodyElement.getFirstOMChild()).getDataHandler()) == null) continue;
            ByteArrayOutputStream attachmentOutputStream = new ByteArrayOutputStream();
            documentBody.writeTo((OutputStream)attachmentOutputStream);
            Document attachDocument = new Document(attachmentOutputStream.toByteArray(), documentBody.getContentType(), documentUniqueId, repositoryUniqueId, homeCommunityId);
            responseAttachments.add(attachDocument);
            if (!logger.isDebugEnabled()) continue;
            logger.debug((Object)("Extracted attachment with id " + documentUniqueId + " from repository " + repositoryUniqueId));
        }
        this.setResponseAttachments(responseAttachments);
        OMElement response = returnRegistryResponseOnly ? responseOMElement.getFirstChildWithName(XDSSoapConstants.REGISTRY_RESPONSE_QNAME) : responseOMElement;
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Ending XDS.b MTOM attachment extraction");
        }
        return response;
    }
}

