/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.IdentifiableType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.util.RimResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;

public class EbXML_3_0InputStreamDocumentEntryExtractor
implements DocumentEntryExtractor {
    public static final String DESCRIPTOR = "EBXML_3_0_STREAM_DE_EXTR";
    private static final Logger logger;
    private InputStream ebXMLdocumentEntryInputStream;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0InputStreamDocumentEntryExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_3_0InputStreamDocumentEntryExtractor(InputStream ebXMLdocumentEntryInputStream) {
        this.ebXMLdocumentEntryInputStream = ebXMLdocumentEntryInputStream;
    }

    public DocumentEntryType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading RimPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new RimResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:xsd:rim:3.0"));
        try {
            resource.load(this.ebXMLdocumentEntryInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing ebXML InputStream contents.");
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        ExtrinsicObjectType docData = null;
        AssociationType1 parentData = null;
        if (root.getExtrinsicObject() != null) {
            docData = root.getExtrinsicObject();
        } else if (root.getRegistryObjectList() != null) {
            if (root.getRegistryObjectList().getIdentifiable() != null) {
                boolean foundExtrinsicObject = false;
                boolean foundAssociation = false;
                Iterator i = root.getRegistryObjectList().getIdentifiable().iterator();
                while (i.hasNext()) {
                    IdentifiableType ident = (IdentifiableType)i.next();
                    if (ident instanceof ExtrinsicObjectType && !foundExtrinsicObject) {
                        docData = (ExtrinsicObjectType)ident;
                        foundExtrinsicObject = true;
                        continue;
                    }
                    if (!(ident instanceof AssociationType1) || foundAssociation) continue;
                    parentData = (AssociationType1)ident;
                    foundAssociation = true;
                }
                if (!foundAssociation || !foundExtrinsicObject) {
                    logger.error((Object)"Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
                    throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
                }
            }
        } else {
            logger.error((Object)"Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
            throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating DocumentEntry metadata with object from InputStream " + this.ebXMLdocumentEntryInputStream));
        }
        EbXML_3_0DocumentEntryExtractor deExtractor = new EbXML_3_0DocumentEntryExtractor(docData, parentData);
        DocumentEntryType documentEntry = deExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unloading Resources.");
        }
        resource.unload();
        return documentEntry;
    }
}

