/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RegistryPackageType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.SlotType1;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.SubmissionSetType;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0ExtractorConstants;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.SubmissionSetExtractor;

public class EbXML_3_0SubmissionSetExtractor
implements SubmissionSetExtractor {
    public static final String DESCRIPTOR = "EBXML_3_0_SS_EXTR";
    private static final Logger logger;
    private RegistryPackageType setData;
    private AssociationType1[] documentsInSubmissionSet;
    private AssociationType1[] foldersInSubmissionSet;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_3_0SubmissionSetExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_3_0SubmissionSetExtractor(RegistryPackageType setData, AssociationType1[] documentsInSubmissionSet, AssociationType1[] foldersInSubmissionSet) {
        this.setData = setData;
        this.documentsInSubmissionSet = documentsInSubmissionSet;
        this.foldersInSubmissionSet = foldersInSubmissionSet;
    }

    public SubmissionSetType extract() throws MetadataExtractionException {
        if (this.setData == null) {
            logger.error((Object)"RegistryPackage is null, cannot execute extraction.");
            throw new MetadataExtractionException("RegistryPackage is null, cannot execute extraction.");
        }
        SubmissionSetType subSet = MetadataFactory.eINSTANCE.createSubmissionSetType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting attributes from the Registry Package.");
        }
        this.extractRegistryPackageAttributes(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Name from the Registry Package.");
        }
        subSet.setTitle(EbXML_3_0SubmissionSetExtractor.copy(this.setData.getName()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting description from the Registry Package.");
        }
        subSet.setComments(EbXML_3_0SubmissionSetExtractor.copy(this.setData.getDescription()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Slot data from  the Registry Package.");
        }
        this.extractRegistryPackageSlots(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting ExternalIdentifier data from the Registry Package.");
        }
        this.extractRegistryPackageExternalIdentifiers(subSet);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting Classification data from the Registry Package.");
        }
        this.extractRegistryPackageClassification(subSet);
        this.extractAssociatedDocuments(subSet);
        this.extractAssociatedFolders(subSet);
        return subSet;
    }

    private void extractRegistryPackageAttributes(SubmissionSetType subSet) {
        subSet.setEntryUUID(this.setData.getId());
        if (this.setData.getStatus() != null) {
            if (this.setData.getStatus().equals(EbXML_3_0ExtractorConstants.APPROVED_STATUS)) {
                subSet.setAvailabilityStatus(AvailabilityStatusType.APPROVED_LITERAL);
            } else if (this.setData.getStatus().equals(EbXML_3_0ExtractorConstants.DEPRECATED_STATUS)) {
                subSet.setAvailabilityStatus(AvailabilityStatusType.DEPRECATED_LITERAL);
            } else if (this.setData.getStatus().equals(EbXML_3_0ExtractorConstants.SUBMITTED_STATUS)) {
                subSet.setAvailabilityStatus(AvailabilityStatusType.SUBMITTED_LITERAL);
            } else if (this.setData.getStatus().equals(EbXML_3_0ExtractorConstants.WITHDRAWN_STATUS)) {
                subSet.setAvailabilityStatus(AvailabilityStatusType.WITHDRAWN_LITERAL);
            } else {
                logger.error((Object)"Unknown Status. Status will not be included in extracted content.");
            }
        }
    }

    private void extractRegistryPackageSlots(SubmissionSetType subSet) {
        EList slots = this.setData.getSlot();
        int i = 0;
        while (i < slots.size()) {
            SlotType1 slot = (SlotType1)slots.get(i);
            if (slot != null && slot.getName() != null && slot.getValueList() != null && slot.getValueList().getValue() != null && slot.getValueList().getValue().size() >= 1 && slot.getValueList().getValue().get(0) != null) {
                String slotName = slot.getName();
                if (slotName.equals("submissionTime")) {
                    subSet.setSubmissionTime((String)slot.getValueList().getValue().get(0));
                } else {
                    logger.error((Object)("Unidentified Slot: " + slotName + ". Slot content will not be included in extracted content."));
                }
            }
            ++i;
        }
    }

    private void extractRegistryPackageExternalIdentifiers(SubmissionSetType subSet) {
        EList externalIdentifiers = this.setData.getExternalIdentifier();
        int i = 0;
        while (i < externalIdentifiers.size()) {
            ExternalIdentifierType exID = (ExternalIdentifierType)externalIdentifiers.get(i);
            if (exID != null) {
                String exUUID = exID.getIdentificationScheme();
                if (exUUID == null) {
                    logger.error((Object)("Required ExternalIdentifier/@identificationScheme attribute missing for following id: " + exID.getValue() + ". ID will not be included in extracted content."));
                }
                if (exUUID.equals("urn:uuid:6b5aea1a-874d-4603-a4bc-96a0a7b38446")) {
                    String s = exID.getValue();
                    CX patientId = HL7V2MessageFormat.buildCXFromMessageString((String)s, (char)'^', (char)'&');
                    subSet.setPatientId(patientId);
                } else if (exUUID.equals("urn:uuid:554ac39e-e3fe-47fe-b233-965d2a147832")) {
                    subSet.setSourceId(exID.getValue());
                } else if (exUUID.equals("urn:uuid:96fdda7c-d067-4183-912e-bf5ee74998a8")) {
                    subSet.setUniqueId(exID.getValue());
                } else {
                    logger.error((Object)("Unidentified ExternalIdentifier/@identificationScheme: " + exUUID + ". " + exID.getValue() + " will not be included in extracted content."));
                }
            }
            ++i;
        }
    }

    private void extractRegistryPackageClassification(SubmissionSetType subSet) {
        EList classifications = this.setData.getClassification();
        if (classifications == null) {
            return;
        }
        int i = 0;
        while (i < classifications.size()) {
            ClassificationType classification = (ClassificationType)classifications.get(i);
            if (classification != null) {
                if (classification.getClassificationScheme().equals("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d")) {
                    AuthorType author = MetadataFactory.eINSTANCE.createAuthorType();
                    int j = 0;
                    while (j < classification.getSlot().size()) {
                        SlotType1 slot = (SlotType1)classification.getSlot().get(j);
                        if (slot != null && slot.getName() != null && slot.getValueList() != null && slot.getValueList().getValue() != null && slot.getValueList().getValue().size() >= 1 && slot.getValueList().getValue().get(0) != null) {
                            String s;
                            String slotName = slot.getName();
                            if (slotName.equals("authorInstitution")) {
                                s = (String)slot.getValueList().getValue().get(0);
                                XON authorInstitution = HL7V2MessageFormat.buildXONFromMessageString((String)s, (char)'^', (char)'&');
                                author.getAuthorInstitution().add((Object)authorInstitution);
                            } else if (slotName.equals("authorPerson")) {
                                if (author.getAuthorPerson() != null) {
                                    logger.error((Object)"Duplicate Author.authorPerson. Will only use first full name in the extracted content.");
                                } else {
                                    s = (String)slot.getValueList().getValue().get(0);
                                    XCN authorPerson = HL7V2MessageFormat.buildXCNFromMessageString((String)s, (char)'^', (char)'&');
                                    author.setAuthorPerson(authorPerson);
                                }
                            } else if (slotName.equals("authorRole")) {
                                author.getAuthorRole().add((Object)((String)slot.getValueList().getValue().get(0)));
                            } else if (slotName.equals("authorSpecialty")) {
                                author.getAuthorSpeciality().add((Object)((String)slot.getValueList().getValue().get(0)));
                            }
                        }
                        ++j;
                    }
                    subSet.setAuthor(author);
                } else if (classification.getClassificationScheme().equals("urn:uuid:aa543740-bdda-424e-8c96-df4873be8500")) {
                    if (subSet.getContentTypeCode() != null) {
                        logger.error((Object)"Duplicate SubmissionSet.contentTypeCode. Will only use first code in the extracted content.");
                    } else {
                        SlotType1 cSlot;
                        CodedMetadataType code = MetadataFactory.eINSTANCE.createCodedMetadataType();
                        code.setCode(classification.getNodeRepresentation());
                        code.setDisplayName(EbXML_3_0SubmissionSetExtractor.copy(classification.getName()));
                        if (classification.getSlot() != null && classification.getSlot().size() > 0 && classification.getSlot().get(0) != null && (cSlot = (SlotType1)classification.getSlot().get(0)).getValueList() != null && cSlot.getValueList().getValue() != null && cSlot.getValueList().getValue().size() > 0) {
                            code.setSchemeName((String)cSlot.getValueList().getValue().get(0));
                        }
                        subSet.setContentTypeCode(code);
                    }
                } else if (classification.getClassificationScheme() == null) {
                    logger.error((Object)"Required Classification/@classificationScheme attribute missing. Code or Author will not be included in extracted content.");
                } else {
                    logger.error((Object)("Unidentified Classification/@classificationScheme: " + classification.getClassificationScheme() + ". Code or Author will not be included in extracted content."));
                }
            }
            ++i;
        }
    }

    private void extractAssociatedDocuments(SubmissionSetType subSet) {
        if (this.documentsInSubmissionSet != null && this.documentsInSubmissionSet.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Extracting Submission Set Associated Documents.");
            }
            int i = 0;
            while (i < this.documentsInSubmissionSet.length) {
                if (this.documentsInSubmissionSet[i].getSourceObject().equals(subSet.getEntryUUID())) {
                    subSet.getAssociatedDocuments().add((Object)this.documentsInSubmissionSet[i].getTargetObject());
                } else {
                    logger.error((Object)("Souce Object on " + i + "th Document Association does not match the entryUUID for this Submission Set. " + "This Association will not be included in the extraction."));
                }
                ++i;
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No Submission Set Associated Documents.");
        }
    }

    private void extractAssociatedFolders(SubmissionSetType subSet) {
        if (this.foldersInSubmissionSet != null && this.foldersInSubmissionSet.length > 0) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)"Extracting Submission Set Associated Folders.");
            }
            int i = 0;
            while (i < this.foldersInSubmissionSet.length) {
                if (this.foldersInSubmissionSet[i].getSourceObject().equals(subSet.getEntryUUID())) {
                    subSet.getAssociatedFolders().add((Object)this.foldersInSubmissionSet[i].getTargetObject());
                } else {
                    logger.error((Object)("Souce Object on " + (i + 1) + "th Folder Association does not match the entryUUID for this Submission Set. " + "This Association will not be included in the extraction."));
                }
                ++i;
            }
            return;
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"No Submission Set Associated Folders.");
        }
    }

    private static InternationalStringType copy(org.eclipse.ohf.ihe.common.ebxml._3._0.rim.InternationalStringType ist) {
        InternationalStringType result = MetadataFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                LocalizedStringType lst = MetadataFactory.eINSTANCE.createLocalizedStringType();
                org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType original = (org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

