/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.formats;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPCell;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPDescribed;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPDynamicDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPInteraction;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPItem;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPMetaData;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegmentGroup;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTableItem;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTyped;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPUseCase;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPUseCaseElement;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefnList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.Worker;
import org.eclipse.ohf.utilities.OHFException;
import org.eclipse.ohf.utilities.xml.XMLWriter;

public class CPConformanceProfileComposer
extends Worker {
    private OutputStream stream;
    private boolean stitching;

    public CPConformanceProfileComposer() {
    }

    public CPConformanceProfileComposer(OutputStream stream) {
        this.setStream(stream);
    }

    public CPConformanceProfileComposer(String filename) throws OHFException {
        this.setFilename(filename);
    }

    private void setFilename(String filename) throws OHFException {
        try {
            this.setStream(new FileOutputStream(new File(filename)));
        }
        catch (FileNotFoundException e) {
            throw new OHFException((Throwable)e);
        }
    }

    public OutputStream getStream() {
        return this.stream;
    }

    public void setStream(OutputStream stream) {
        this.stream = stream;
    }

    public boolean isStitching() {
        return this.stitching;
    }

    public void setStitching(boolean stitching) {
        this.stitching = stitching;
    }

    public void compose(CPConformanceProfile profile) throws OHFException {
        try {
            this.compose(new XMLWriter(this.stream, "UTF-8"), profile);
        }
        catch (UnsupportedEncodingException e) {
            throw new OHFException((Throwable)e);
        }
    }

    public void compose(CPDocument model) throws OHFException {
        if (model.getDocumentType() == 1) {
            this.compose((CPConformanceProfile)model.getContent());
        } else {
            this.condition(!this.stitching, "Cannot stitch a definition", 19);
            try {
                this.compose(new XMLWriter(this.stream, "UTF-8"), model);
            }
            catch (UnsupportedEncodingException e) {
                throw new OHFException((Throwable)e);
            }
        }
    }

    private void compose(XMLWriter xml, CPConformanceProfile profile) throws OHFException {
        try {
            xml.setPretty(true);
            xml.start();
            xml.attribute("HL7Version", profile.getHl7Version(), true);
            xml.attribute("ProfileType", this.writeProfileType(profile.getProfileType()), true);
            xml.attribute("Identifier", profile.getIdentifier(), true);
            xml.open("HL7v2xConformanceProfile");
            this.composeMetaData(xml, profile.getMetaData());
            xml.element("ImpNote", profile.getImplementationNote(), true);
            this.composeUseCase(xml, profile.getUseCase());
            this.composeEncodings(xml, profile.getEncodings());
            int i = 0;
            while (i < profile.getInteractions().size()) {
                this.composeInteraction(xml, profile.getInteractions().itemInteraction(i));
                ++i;
            }
            xml.close();
            xml.flush();
        }
        catch (IOException e) {
            throw new OHFException((Throwable)e);
        }
    }

    private void compose(XMLWriter xml, CPDocument model) throws OHFException {
        try {
            xml.start();
            xml.attribute("HL7Version", VersionDefnList.display(model.getHl7Version()), true);
            xml.attribute("Name", model.getName(), true);
            xml.attribute("Derivation", model.getDerivation(), true);
            xml.attribute("Type", this.writeModelType(model.getDocumentType()), true);
            xml.open("HL7v2xConformanceDocument");
            switch (model.getDocumentType()) {
                case 2: {
                    this.composeStaticDefinition(xml, (CPStaticDefinition)model.getContent());
                    break;
                }
                case 3: {
                    this.composeSegmentGroup(xml, (CPSegmentGroup)model.getContent());
                    break;
                }
                case 4: {
                    this.composeSegment(xml, (CPSegment)model.getContent());
                    break;
                }
                case 5: {
                    this.composeField(xml, (CPField)model.getContent());
                    break;
                }
                case 6: {
                    this.composeComponent(xml, (CPComponent)model.getContent());
                    break;
                }
                case 7: {
                    this.composeTable(xml, (CPTable)model.getContent());
                    break;
                }
                default: {
                    throw new HL7V2Exception("unknown document type " + Integer.toString(model.getDocumentType()), 25);
                }
            }
            xml.close();
            xml.flush();
        }
        catch (IOException e) {
            throw new OHFException((Throwable)e);
        }
    }

    private String writeProfileType(int profileType) throws OHFException {
        switch (profileType) {
            case 1: {
                return null;
            }
            case 3: {
                return "Implementation";
            }
            case 2: {
                return "Constrainable";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(profileType) + "' for ProfileType");
    }

    private String writeModelType(int modelType) throws OHFException {
        switch (modelType) {
            case 2: {
                return "Message";
            }
            case 3: {
                return "SegmentGroup";
            }
            case 4: {
                return "Segment";
            }
            case 5: {
                return "Field";
            }
            case 6: {
                return "Component";
            }
            case 7: {
                return "Table";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(modelType) + "' for ModelType");
    }

    private void composeUseCase(XMLWriter xml, CPUseCase useCase) throws OHFException, IOException {
        if (useCase.getElements().size() > 0 || useCase.hasPurpose() || useCase.hasDescription()) {
            xml.open("UseCase");
            xml.element("Purpose", useCase.getPurpose(), true);
            xml.element("Description", useCase.getDescription(), true);
            int i = 0;
            while (i < useCase.getElements().size()) {
                this.composeUseCaseElement(xml, useCase.getElements().itemUseCaseElement(i));
                ++i;
            }
            xml.close();
        }
    }

    private void composeUseCaseElement(XMLWriter xml, CPUseCaseElement element) throws OHFException, IOException {
        xml.attribute("Name", element.getName());
        xml.element(this.getUseCaseElementName(element.getType()), element.getValue());
    }

    private String getUseCaseElementName(int type) throws OHFException {
        switch (type) {
            case 1: {
                return "Actor";
            }
            case 2: {
                return "PreCondition";
            }
            case 3: {
                return "PostCondition";
            }
            case 4: {
                return "EventFlow";
            }
            case 5: {
                return "DerivedEvent";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(type) + "' for UseCase Element Type");
    }

    private void composeMetaData(XMLWriter xml, CPMetaData metaData) throws OHFException, IOException {
        xml.attribute("Name", metaData.getName(), true);
        xml.attribute("Context", metaData.getContext(), true);
        xml.attribute("OrgName", metaData.getOrgName(), true);
        xml.attribute("Version", metaData.getVersion(), true);
        xml.attribute("MetaVersion", metaData.getMetaVersion(), true);
        xml.attribute("Status", metaData.getStatus(), true);
        xml.attribute("Topics", metaData.getTopics(), true);
        xml.element("MetaData", "");
    }

    private void composeEncodings(XMLWriter xml, String[] encodings) throws OHFException, IOException {
        xml.open("Encodings");
        int i = 0;
        while (i < encodings.length) {
            xml.element("Encoding", encodings[i]);
            ++i;
        }
        xml.close();
    }

    private void composeInteraction(XMLWriter xml, CPInteraction interaction) throws OHFException, IOException {
        this.composeDynamicDefinition(xml, interaction.getDynamicDefinition());
        this.composeStaticDefinition(xml, interaction.getStaticDefinition());
    }

    private void composeDynamicDefinition(XMLWriter xml, CPDynamicDefinition definition) throws OHFException, IOException {
        xml.attribute("AccAck", this.writeAcceptAcknowledgment(definition.getAcceptAcknowledgment()));
        xml.attribute("AppAck", this.writeApplicationAcknowledgment(definition.getApplicationAcknowledgment()));
        xml.attribute("MsgAckMode", this.writeAcknowledgmentMode(definition.getAcknowledgmentMode()));
        if (definition.getQueryType() != 1) {
            xml.attribute("QueryMessageType", this.writeQueryType(definition.getQueryType()));
        }
        if (definition.getQueryMode() != 2) {
            xml.attribute("QueryMode", this.writeQueryMode(definition.getQueryMode()));
        }
        xml.element("DynamicDef", "");
    }

    private String writeQueryMode(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "Batch";
            }
            case 2: {
                return "RealTime";
            }
            case 3: {
                return "Both";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for QueryMode");
    }

    private String writeQueryType(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "NonQuery";
            }
            case 2: {
                return "Query";
            }
            case 3: {
                return "Response";
            }
            case 4: {
                return "Publish";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for QueryType");
    }

    private String writeAcknowledgmentMode(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "Immediate";
            }
            case 2: {
                return "Deferred";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for MsgAckMode");
    }

    private String writeApplicationAcknowledgment(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "AL";
            }
            case 2: {
                return "NE";
            }
            case 3: {
                return "SU";
            }
            case 4: {
                return "ER";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for AppAck");
    }

    private String writeAcceptAcknowledgment(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "AL";
            }
            case 2: {
                return "NE";
            }
            case 3: {
                return "SU";
            }
            case 4: {
                return "ER";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for AccAck");
    }

    private void composeStaticDefinition(XMLWriter xml, CPStaticDefinition definition) throws OHFException, IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", definition.getImplementationType(), true);
        }
        if (this.stitching || !definition.hasImplementationType()) {
            xml.attribute("Identifier", definition.getIdentifier(), true);
            if (definition.isReferenceOnly()) {
                xml.element("HL7v2xStaticDefRef", "");
            } else {
                xml.attribute("MsgType", definition.getMsgType(), true);
                xml.attribute("EventType", definition.getEventType(), true);
                xml.attribute("MsgStructID", definition.getMsgStructId(), true);
                xml.attribute("OrderControl", definition.getOrderControl(), true);
                xml.attribute("EventDesc", definition.getEventDesc(), true);
                xml.attribute("Role", this.writeRole(definition.getRole()), true);
                xml.open("HL7v2xStaticDef");
                this.composeMetaData(xml, definition.getMetaData());
                this.describedElements(xml, definition);
                int i = 0;
                while (i < definition.getElements().size()) {
                    this.composeSegmentElement(xml, definition.getElements().itemSegmentElement(i));
                    ++i;
                }
                xml.close();
            }
        } else {
            xml.element("HL7v2xStaticDef", "");
        }
    }

    private String writeRole(int value) throws OHFException {
        switch (value) {
            case 2: {
                return "Sender";
            }
            case 1: {
                return "Receiver";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for Role");
    }

    private void nodeAttributes(XMLWriter xml, CPTyped node) throws IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", node.getImplementationType(), true);
        }
    }

    private void describedAttributes(XMLWriter xml, CPDescribed described) throws IOException {
        this.nodeAttributes(xml, described);
    }

    private void describedElements(XMLWriter xml, CPDescribed described) throws OHFException, IOException {
        xml.element("ImpNote", described.getImplementationNote(), true);
        xml.element("Description", described.getDescription(), true);
        xml.element("Reference", described.getReference(), true);
    }

    private void composeSegmentElement(XMLWriter xml, CPSegmentElement element) throws OHFException, IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", element.getImplementationType(), true);
        }
        if (element instanceof CPSegment) {
            this.composeSegment(xml, (CPSegment)element);
        } else if (element instanceof CPSegmentGroup) {
            this.composeSegmentGroup(xml, (CPSegmentGroup)element);
        } else {
            throw new OHFException("unexpected class " + element.getClass().getName());
        }
    }

    private void composeSegmentGroup(XMLWriter xml, CPSegmentGroup group) throws OHFException, IOException {
        if (this.stitching || !group.hasImplementationType()) {
            this.segmentElementAttributes(xml, group);
            xml.open("SegGroup");
            this.segmentElementElements(xml, group);
            int i = 0;
            while (i < group.getElements().size()) {
                this.composeSegmentElement(xml, group.getElements().itemSegmentElement(i));
                ++i;
            }
            xml.close();
        } else {
            xml.element("SegGroup", "");
        }
    }

    private void composeSegment(XMLWriter xml, CPSegment segment) throws OHFException, IOException {
        if (this.stitching || !segment.hasImplementationType()) {
            this.segmentElementAttributes(xml, segment);
            xml.open("Segment");
            this.segmentElementElements(xml, segment);
            int i = 0;
            while (i < segment.getFields().size()) {
                this.composeField(xml, segment.getFields().itemField(i));
                ++i;
            }
            xml.close();
        } else {
            xml.element("Segment", "");
        }
    }

    private void segmentElementAttributes(XMLWriter xml, CPSegmentElement segmentElement) throws IOException, OHFException {
        xml.attribute("Name", segmentElement.getName(), true);
        xml.attribute("LongName", segmentElement.getLongName(), true);
        this.itemAttributes(xml, segmentElement);
        xml.attribute("Min", this.writeMin(segmentElement.getMin()), true);
        xml.attribute("Max", this.writeMax(segmentElement.getMax()), true);
    }

    protected String writeMax(int value) {
        if (value == -1) {
            return "*";
        }
        return Integer.toString(value);
    }

    protected String writeMin(int value) {
        return Integer.toString(value);
    }

    private void segmentElementElements(XMLWriter xml, CPSegmentElement segmentElement) throws OHFException, IOException {
        this.itemElements(xml, segmentElement);
    }

    private void itemElements(XMLWriter xml, CPItem item) throws OHFException, IOException {
        this.describedElements(xml, item);
        xml.element("Predicate", item.getPredicate(), true);
    }

    private void itemAttributes(XMLWriter xml, CPItem item) throws OHFException, IOException {
        this.describedAttributes(xml, item);
        xml.attribute("Usage", this.writeUsage(item.getUsage()), true);
    }

    private String writeUsage(int value) throws OHFException {
        switch (value) {
            case 1: {
                return "R";
            }
            case 2: {
                return "RE";
            }
            case 3: {
                return "O";
            }
            case 4: {
                return "C";
            }
            case 5: {
                return "CE";
            }
            case 6: {
                return "X";
            }
        }
        throw new OHFException("illegal value '" + Integer.toString(value) + "' for Usage");
    }

    private void composeField(XMLWriter xml, CPField field) throws OHFException, IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", field.getImplementationType(), true);
        }
        if (this.stitching || !field.hasImplementationType()) {
            this.cellAttributes(xml, field);
            xml.attribute("Min", this.writeMin(field.getMin()), true);
            xml.attribute("Max", this.writeMax(field.getMax()), true);
            xml.attribute("ItemNo", field.getItemNo(), true);
            xml.open("Field");
            this.cellElements(xml, field);
            int i = 0;
            while (i < field.getComponents().size()) {
                this.composeComponent(xml, field.getComponents().itemComponent(i));
                ++i;
            }
            xml.close();
        } else {
            xml.element("Field", "");
        }
    }

    private void cellAttributes(XMLWriter xml, CPCell cell) throws OHFException, IOException {
        xml.attribute("Name", cell.getName(), true);
        this.itemAttributes(xml, cell);
        xml.attribute("DataType", cell.getDataType(), true);
        if (cell.getLength() != -1) {
            xml.attribute("Length", this.writeMax(cell.getLength()), true);
        }
        xml.attribute("Table", cell.getTable(), true);
        xml.attribute("ConstantValue", cell.getFixedValue(), true);
    }

    private void cellElements(XMLWriter xml, CPCell cell) throws OHFException, IOException {
        this.itemElements(xml, cell);
        if (cell.getDataValues() != null) {
            int i = 0;
            while (i < cell.getDataValues().length) {
                xml.attribute("ExValue", cell.getDataValues()[i]);
                ++i;
            }
            xml.element("DataValues", "");
        }
    }

    private void composeComponent(XMLWriter xml, CPComponent component) throws OHFException, IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", component.getImplementationType(), true);
        }
        if (this.stitching || !component.hasImplementationType()) {
            this.cellAttributes(xml, component);
            xml.open("Component");
            this.cellElements(xml, component);
            int i = 0;
            while (i < component.getComponents().size()) {
                this.composeSubComponent(xml, component.getComponents().itemComponent(i));
                ++i;
            }
            xml.close();
        } else {
            xml.element("Component", "");
        }
    }

    private void composeSubComponent(XMLWriter xml, CPComponent component) throws OHFException, IOException {
        if (!this.stitching) {
            xml.attribute("ImplementationType", component.getImplementationType(), true);
        }
        if (this.stitching || !component.hasImplementationType()) {
            this.condition(component.getComponents().size() == 0, "Cannot encode sub-sub-components", 15);
            this.cellAttributes(xml, component);
            xml.open("SubComponent");
            this.cellElements(xml, component);
            xml.close();
        } else {
            xml.element("SubComponent", "");
        }
    }

    private void composeTable(XMLWriter xml, CPTable table) throws OHFException, IOException {
        xml.attribute("TableType", table.getTableType(), true);
        xml.attribute("CodeSystem", table.getCodeSystem(), true);
        xml.attribute("Id", table.getId(), true);
        xml.attribute("Name", table.getName(), true);
        this.describedAttributes(xml, table);
        xml.open("Table");
        this.describedElements(xml, table);
        int i = 0;
        while (i < table.getItems().size()) {
            this.composeTableItem(xml, table.getItems().itemTableItem(i));
            ++i;
        }
        xml.close();
    }

    private void composeTableItem(XMLWriter xml, CPTableItem item) throws OHFException, IOException {
        xml.attribute("Order", Integer.toString(item.getOrder()), true);
        xml.attribute("Key", item.getKey(), true);
        xml.attribute("Code", item.getCode(), true);
        xml.attribute("DisplayName", item.getDisplayName(), true);
        xml.attribute("Usage", this.writeUsage(item.getUsage()), true);
        xml.element("Item", "");
    }
}

