/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.apache.commons.lang.StringUtils;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPItem;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class CPSegmentElement
extends CPItem {
    private String name;
    private String longName;
    private int min;
    private int max;

    public CPSegmentElement(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.name = "";
        this.longName = "";
        this.min = -1;
        this.max = -1;
    }

    public String getLongName() {
        return this.longName;
    }

    public void setLongName(String longName) {
        this.longName = longName;
    }

    public int getMax() {
        return this.max;
    }

    public void setMax(int max) {
        this.max = max;
    }

    public int getMin() {
        return this.min;
    }

    public void setMin(int min) {
        this.min = min;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 24, 25, 26, 46});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 24: {
                return this.getLongName();
            }
            case 25: {
                return Integer.toString(this.getMin());
            }
            case 26: {
                return Integer.toString(this.getMax());
            }
            case 46: {
                return this.getCardinality();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 24: {
                this.setLongName(value);
                break;
            }
            case 25: {
                this.setMin(Integer.parseInt(value));
                break;
            }
            case 26: {
                this.setMax(Integer.parseInt(value));
                break;
            }
            case 46: {
                this.setCardinality(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public void defaults() {
        super.defaults();
        this.name = null;
        this.longName = null;
        this.min = 0;
        this.max = 1;
    }

    public String getCardinality() {
        if (this.max < 0) {
            return String.valueOf(Integer.toString(this.min)) + "..*";
        }
        return String.valueOf(Integer.toString(this.min)) + ".." + Integer.toString(this.max);
    }

    public void setCardinality(String value) throws HL7V2Exception {
        String[] bits = StringUtils.split((String)value, (String)"..");
        this.condition(bits.length == 2 && StringUtils.isNumeric((String)bits[0]) && (StringUtils.isNumeric((String)bits[1]) || bits[1].equals("*")), "cardinality " + value + " is not valid", 19);
        this.min = Integer.parseInt(bits[0]);
        this.max = bits[1].equals("*") ? -1 : Integer.parseInt(bits[1]);
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPSegmentElement src = (CPSegmentElement)source;
        this.name = src.name;
        this.longName = src.longName;
        this.min = src.min;
        this.max = src.max;
    }

    public CPSegmentElement cloneSegmentElement() throws CloneNotSupportedException {
        return (CPSegmentElement)this.clone();
    }
}

