/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.operations;

import org.eclipse.ohf.hl7v2.core.conformance.CPDocument;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPComponent;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPField;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPSegment;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPStaticDefinition;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTable;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPTableItem;
import org.eclipse.ohf.hl7v2.core.definitions.model.ComponentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.FieldDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.MessageStructureDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.SegmentDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.TableItemDefn;
import org.eclipse.ohf.hl7v2.core.definitions.model.VersionDefn;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPPatternApplier {
    private int destinationType;
    private CPElement destination;
    private int version;
    private String source;

    public CPElement getDestination() {
        return this.destination;
    }

    public void setDestination(CPElement destination) {
        this.destination = destination;
    }

    public int getDestinationType() {
        return this.destinationType;
    }

    public void setDestinationType(int destinationType) {
        this.destinationType = destinationType;
    }

    public String getSource() {
        return this.source;
    }

    public void setSource(String source) {
        this.source = source;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }

    public void apply() throws HL7V2Exception {
        this.destination.clear();
        switch (this.destinationType) {
            case 2: {
                this.applyMessage((CPStaticDefinition)this.destination, this.getMessageDefinition());
            }
            case 4: {
                this.applySegment((CPSegment)this.destination, this.getSegmentDefinition());
            }
            case 5: {
                this.applyField((CPField)this.destination, this.getFieldDefinition());
            }
            case 6: {
                this.applyComponent((CPComponent)this.destination, this.getComponentDefinition());
            }
            case 7: {
                this.applyTable((CPTable)this.destination, this.getTableDefinition());
            }
        }
        throw new HL7V2Exception("Cannot apply a pattern of type " + CPDocument.displayDocumentType(this.destinationType), 19);
    }

    private VersionDefn getVersionDefinition() {
        return MessageManager.getFactory().getVersionDefinitions().itemByVersion(this.version);
    }

    private MessageStructureDefn getMessageDefinition() throws HL7V2Exception {
        MessageStructureDefn defn = this.getVersionDefinition().getMessageStructures().itemByName(this.source);
        if (defn == null) {
            throw new HL7V2Exception("unable to find structure " + this.source, 19);
        }
        return defn;
    }

    private SegmentDefn getSegmentDefinition() throws HL7V2Exception {
        SegmentDefn defn = this.getVersionDefinition().getSegments().itemByName(this.source);
        if (defn == null) {
            throw new HL7V2Exception("unable to find segment " + this.source, 19);
        }
        return defn;
    }

    private FieldDefn getFieldDefinition() throws HL7V2Exception {
        String[] parts = this.source.split("-");
        if (parts.length != 2) {
            throw new HL7V2Exception("unable to find field " + this.source, 19);
        }
        SegmentDefn seg = this.getVersionDefinition().getSegments().itemByName(parts[0]);
        if (seg == null) {
            throw new HL7V2Exception("unable to find segment " + parts[0], 19);
        }
        FieldDefn defn = seg.getFields().itemByNumber(Integer.parseInt(parts[1]) - 1);
        if (defn == null) {
            throw new HL7V2Exception("unable to find field " + this.source, 19);
        }
        return null;
    }

    private ComponentDefn getComponentDefinition() throws HL7V2Exception {
        ComponentDefn defn = this.getVersionDefinition().getComponents().itemByName(this.source);
        if (defn == null) {
            throw new HL7V2Exception("unable to find component " + this.source, 19);
        }
        return defn;
    }

    private TableDefn getTableDefinition() throws HL7V2Exception {
        TableDefn defn = this.getVersionDefinition().getTables().itemById(this.source);
        if (defn == null) {
            throw new HL7V2Exception("unable to find table " + this.source, 19);
        }
        return defn;
    }

    private void applyMessage(CPStaticDefinition message, MessageStructureDefn definition) throws HL7V2Exception {
        throw new HL7V2Exception("to do", 18);
    }

    private void applySegment(CPSegment segment, SegmentDefn definition) {
        segment.setName(definition.getName());
        segment.setLongName(definition.getDescription());
        segment.setDescription(definition.getDescription());
        int i = 0;
        while (i < definition.getFields().size() - 1) {
            CPField field = new CPField(segment);
            this.applyField(field, definition.getFields().item(i));
            segment.getFields().add(field);
            ++i;
        }
    }

    private void applyField(CPField field, FieldDefn definition) {
        field.setName(definition.getPathName());
        field.setItemNo(Integer.toString(definition.getDataElementId()));
        if (definition.isRequired()) {
            field.setMin(1);
            field.setUsage(1);
        } else {
            field.setMin(0);
        }
        if (definition.isRepeatable()) {
            field.setMax(definition.getRepeatCount());
        } else {
            field.setMax(1);
        }
        if (definition.hasDataElement()) {
            field.setLength(definition.getDataElement().getLength());
            field.setTable(Integer.toString(definition.getDataElement().getTableId()));
            field.setDescription(definition.getDataElement().getDescription());
            if (definition.getDataElement().hasStructure()) {
                field.setDataType(definition.getDataElement().getStructure().getDataTypeCode());
                field.setDescription(definition.getDataElement().getStructure().getDescription());
                int i = 0;
                while (i < definition.getDataElement().getStructure().getComponents().size() - 1) {
                    CPComponent child = new CPComponent(field);
                    this.applyComponent(child, definition.getDataElement().getStructure().getComponents().item(i));
                    field.getComponents().add(child);
                    ++i;
                }
            }
        }
    }

    private void applyComponent(CPComponent component, ComponentDefn definition) {
        component.setName(definition.getName());
        component.setDataType(definition.getDataTypeCode());
        component.setTable(Integer.toString(definition.getTableId()));
        if (definition.hasStructure()) {
            component.setDescription(definition.getStructure().getDescription());
            int i = 0;
            while (i < definition.getStructure().getComponents().size() - 1) {
                CPComponent child = new CPComponent(component);
                this.applyComponent(child, definition.getStructure().getComponents().item(i));
                component.getComponents().add(child);
                ++i;
            }
        }
    }

    private void applyTable(CPTable table, TableDefn definition) {
        table.setId(Integer.toString(definition.getId()));
        table.setName(definition.getDescription());
        int i = 0;
        while (i < definition.getItems().size() - 1) {
            CPTableItem item = new CPTableItem(table);
            this.applyTableItem(item, definition.getItems().item(i), i);
            table.getItems().add(item);
            ++i;
        }
    }

    private void applyTableItem(CPTableItem item, TableItemDefn definition, int index) {
        item.setCode(definition.getName());
        item.setDisplayName(definition.getDescription());
        item.setKey(Integer.toString(definition.getId()));
        item.setOrder(index);
    }
}

