/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.message.model.Content;
import org.eclipse.ohf.hl7v2.core.message.model.ContentIterator;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.ItemIterator;
import org.eclipse.ohf.hl7v2.core.message.model.ItemList;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class ContentList
extends ItemList {
    private boolean complex;

    public ContentList(Item owner, boolean complex) {
        super(owner, true);
        this.complex = complex;
    }

    public Content itemContent(int index) {
        return (Content)super.itemNode(index);
    }

    public ContentIterator iteratorContent() {
        return (ContentIterator)this.makeIterator();
    }

    protected ItemIterator makeIterator() {
        return new ContentIterator(this);
    }

    public void add(Content content) throws HL7V2Exception {
        this.condition(this.complex || this.size() == 0 && content.getContentType() != 2, "Cannot accept complex content at " + this.getOwner().elementName(), 19);
        this.condition(this.size() == 0 || this.itemContent(0).getContentType() != 1, "cannot add multiple items when existing item is null " + this.getOwner().elementName(), 19);
        this.condition(this.size() == 0 || content.getContentType() != 1, "cannot add null to multiple items " + this.getOwner().elementName(), 19);
        content.setIndex(this.size());
        super.add(content);
    }

    public void insert(Content content, int index) throws HL7V2Exception {
        this.condition(this.complex || this.size() == 0 && content.getContentType() != 2, "Cannot accept complex content " + this.getOwner().elementName(), 19);
        this.condition(this.size() == 0 || this.itemContent(0).getContentType() != 1, "cannot add multiple items when existing item is null " + this.getOwner().elementName(), 19);
        this.condition(this.size() == 0 || content.getContentType() != 1, "cannot add null to multiple items " + this.getOwner().elementName(), 19);
        super.insert(content, index);
        int i = 0;
        while (i < this.size()) {
            this.itemContent(i).setIndex(i);
            ++i;
        }
    }

    public boolean isComplex() {
        return this.complex;
    }

    protected void remove(int index) throws HL7V2Exception {
        super.remove(index);
        int i = index;
        while (i < this.size()) {
            this.itemContent(i).setIndex(i);
            ++i;
        }
    }
}

