/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.message.model.CellList;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.message.model.FieldIterator;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.ItemIterator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class FieldList
extends CellList {
    private boolean checkIndexes = false;

    public FieldList(Item owner) {
        super(owner);
    }

    public Field item(int index) {
        return (Field)super.itemNode(index);
    }

    public void add(Field dataElement) throws HL7V2Exception {
        this.condition(!this.checkIndexes || dataElement.getIndex() == this.size() + 1, "Index order error", 18);
        super.add(dataElement);
    }

    public void insert(Item node, int index) throws HL7V2Exception {
        this.condition(!this.checkIndexes, "Cannot insert a field", 18);
        super.insert(node, index);
    }

    public boolean isCheckIndexes() {
        return this.checkIndexes;
    }

    public void setCheckIndexes(boolean checkIndexes) throws HL7V2Exception {
        this.condition(this.size() == 0, "Cannot change CheckIndexes flag once list contains content", 19);
        this.checkIndexes = checkIndexes;
    }

    public FieldIterator iteratorDataElement() {
        return (FieldIterator)this.makeIterator();
    }

    protected ItemIterator makeIterator() {
        return new FieldIterator(this);
    }

    public void remove(int index) throws HL7V2Exception {
        super.remove(index);
    }

    public void remove(Field field) throws HL7V2Exception {
        this.condition(!this.checkIndexes, "Cannot remove a field", 18);
        super.remove(this.indexOfItem(field));
    }
}

