/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Random;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.Utils;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SessionContext
implements Serializable {
    static final Logger mLogger = Logger.getLogger(SessionContext.class);
    private static final long serialVersionUID = -6189814352080258571L;
    private static final Random mRandom = new Random();
    private String mUser;
    private String mSessionID = "Random Session ID [" + mRandom.nextLong() + "]";
    private String mRhioName;
    private String mUserApplicationName;
    private String mUserFacilityName;
    private String mReturnLogLevel = null;
    private boolean mUseSecuredConnectionWhenAvailable = false;
    private transient Level mLevel = null;
    private transient List<String> mLogList = new ArrayList<String>();
    private transient int mLogSize = 0;
    private transient boolean mLogLevelInvalid = false;
    private transient String mCallerIp;
    public static final SessionContext DEFAULT = new SessionContext();

    static {
        DEFAULT.setRhioName("NO_RHIO");
        DEFAULT.setUser("NO_USER");
        DEFAULT.setSessionID("NO_SESSION");
        DEFAULT.setUserApplicationName("NO_USER_APPLICATION_NAME");
        DEFAULT.setUserFacilityName("NO_FACILITY");
    }

    public String getRhioName() {
        return this.mRhioName;
    }

    public void setRhioName(String pRhioName) {
        this.mRhioName = pRhioName;
    }

    public String getSessionID() {
        return this.mSessionID;
    }

    public void setSessionID(String pSessionID) {
        this.mSessionID = pSessionID;
    }

    public String getUser() {
        return this.mUser;
    }

    public void setUser(String pUser) {
        this.mUser = pUser;
    }

    public String getUserApplicationName() {
        return this.mUserApplicationName;
    }

    public void setUserApplicationName(String pUserApplicationName) {
        this.mUserApplicationName = pUserApplicationName;
    }

    public String getUserFacilityName() {
        return this.mUserFacilityName;
    }

    public void setUserFacilityName(String pUserFacilityName) {
        this.mUserFacilityName = pUserFacilityName;
    }

    public String getReturnLogLevel() {
        return this.mReturnLogLevel;
    }

    public void setReturnLogLevel(String pReturnLogLevel) {
        this.mReturnLogLevel = pReturnLogLevel;
    }

    public Level logLevel() {
        if (this.mLevel == null && this.mReturnLogLevel != null && !this.mLogLevelInvalid && !Utils.isEmptyOrNull(this.mReturnLogLevel)) {
            System.err.println("Using ReturnLogLevel = " + this.mReturnLogLevel);
            if (this.mReturnLogLevel != null) {
                this.mLevel = Level.toLevel((String)this.mReturnLogLevel);
            }
            if (this.mLevel == null) {
                this.mLogLevelInvalid = true;
                mLogger.error((Object)("ReturnLogLevel " + this.mReturnLogLevel + " is not a valid level"));
            }
        }
        return this.mLevel;
    }

    public List<String> logList() {
        return this.mLogList;
    }

    public void addLogSize(int pSize) {
        this.mLogSize += pSize;
    }

    public int logSize() {
        return this.mLogSize;
    }

    public String toString() {
        StringBuffer retValue = new StringBuffer();
        retValue.append("SessionContext ( ").append("mUser=[").append(this.mUser).append("]").append("    ").append("mSessionID=[").append(this.mSessionID).append("]").append("    ").append("mRhioName=[").append(this.mRhioName).append("]").append("    ").append("mUserApplicationName=[").append(this.mUserApplicationName).append("]").append("    ").append("mUserFacilityName=[").append(this.mUserFacilityName).append("]").append("    ").append("mReturnLogLevel=[").append(this.mReturnLogLevel).append("]").append("    ").append("mUseSecuredConnectionWhenAvailable=[").append(this.mUseSecuredConnectionWhenAvailable).append("]").append("    ").append(" )");
        return retValue.toString();
    }

    public boolean isUseSecuredConnectionWhenAvailable() {
        return this.mUseSecuredConnectionWhenAvailable;
    }

    public void setUseSecuredConnectionWhenAvailable(boolean pUseSecuredConnectionWhenAvailable) {
        this.mUseSecuredConnectionWhenAvailable = pUseSecuredConnectionWhenAvailable;
    }

    public void putCallerIp(String pIpAddress) {
        this.mCallerIp = pIpAddress;
    }

    public String callerIp() {
        return this.mCallerIp;
    }
}

