/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.Configurations;
import org.eclipse.ohf.bridge.conf.PixPdqResourcesFactory;
import org.eclipse.ohf.bridge.conf.RhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.TransactionHandlerFactory;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.XdsResourcesFactory;
import org.eclipse.ohf.bridge.conf.rhio.AuditConfig;
import org.eclipse.ohf.bridge.pix.PIXSourceBridge;
import org.eclipse.ohf.bridge.pix.PatientConsumerBridge;
import org.eclipse.ohf.bridge.type.ResponseType;
import org.eclipse.ohf.bridge.xds.XdsBridge;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.common.atna.ConfigurableInheritableThreadLocal;

public class TransactionContext {
    static final Logger mLogger = Logger.getLogger(TransactionContext.class);
    private static Configurations sConfigurations = null;
    private final SessionContext mSessionContext;
    private static Map<String, RhioDedicatedResources> sPixPdqResources = new HashMap<String, RhioDedicatedResources>();
    private static Map<String, RhioDedicatedResources> sXdsResources = new HashMap<String, RhioDedicatedResources>();
    private final long mStartTime = System.currentTimeMillis();
    private static XdsResourcesFactory mXdsResourcesFactory = null;
    private static PixPdqResourcesFactory mPixPdqResourcesFactory = null;
    private static TransactionHandlerFactory mTransactionHandlerFactory = null;
    private static ThreadLocal<TransactionContext> sTransactionContext = new ThreadLocal<TransactionContext>(){

        @Override
        protected synchronized TransactionContext initialValue() {
            return null;
        }
    };

    static {
        ConfigurableInheritableThreadLocal.enableThreading((boolean)true);
    }

    private TransactionContext(SessionContext pSessionContext) {
        this.mSessionContext = pSessionContext;
        if (pSessionContext == null) {
            throw new NullPointerException("SessionContext is null");
        }
        if (Utils.isEmptyOrNull(this.mSessionContext.getRhioName())) {
            throw new IllegalArgumentException("rhio name can't be null");
        }
    }

    public static void setConfigurations(Configurations pConfigurations) {
        if (sConfigurations != null) {
            throw new IllegalStateException("init should be called only once");
        }
        sConfigurations = pConfigurations;
    }

    public static void unsetConfigurations() {
        sConfigurations = null;
    }

    public RhioDedicatedResources getXdsResources() throws UnavailableResourcesException {
        if (sConfigurations == null) {
            throw new IllegalStateException("the Configurations should have been set by now");
        }
        if (mXdsResourcesFactory == null) {
            throw new UnavailableResourcesException("XdsResourcesFactory");
        }
        String rhio = this.mSessionContext.getRhioName();
        RhioDedicatedResources resources = sXdsResources.get(rhio);
        if (resources == null) {
            resources = mXdsResourcesFactory.getRhioDedicatedResources(sConfigurations.getRhioConfig(rhio), sConfigurations);
            if (!resources.getRhioConfiguration().getName().equals(rhio)) {
                if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    mLogger.error((Object)("got rhio " + resources.getRhioConfiguration().getName() + " and expected " + rhio));
                }
                System.err.println("got rhio " + resources.getRhioConfiguration().getName() + " and expected " + rhio);
                System.exit(1);
            }
            sXdsResources.put(rhio, resources);
        }
        return resources;
    }

    public RhioDedicatedResources getPixPdqResources() throws UnavailableResourcesException {
        if (sConfigurations == null) {
            throw new IllegalStateException("the Configurations should have been set by now");
        }
        if (mPixPdqResourcesFactory == null) {
            throw new UnavailableResourcesException("PixPdqResourcesFactory");
        }
        String rhio = this.mSessionContext.getRhioName();
        RhioDedicatedResources resources = sPixPdqResources.get(rhio);
        if (resources == null) {
            resources = mPixPdqResourcesFactory.getRhioDedicatedResources(sConfigurations.getRhioConfig(rhio), sConfigurations);
            if (resources.getRhioConfiguration().getName() != null && !resources.getRhioConfiguration().getName().equals(rhio)) {
                if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    mLogger.error((Object)("got rhio " + resources.getRhioConfiguration().getName() + " and expected " + rhio));
                }
                System.err.println("got rhio " + resources.getRhioConfiguration().getName() + " and expected " + rhio);
                System.exit(1);
            }
            sPixPdqResources.put(rhio, resources);
        }
        return resources;
    }

    public static TransactionContext instant() {
        return sTransactionContext.get();
    }

    public static void start(SessionContext pSessionContext) throws Throwable {
        TransactionContext context = new TransactionContext(pSessionContext);
        sTransactionContext.set(context);
        if (mTransactionHandlerFactory != null) {
            mTransactionHandlerFactory.start();
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"......................................................................");
            mLogger.debug((Object)("Start transaction mark for " + pSessionContext));
            mLogger.debug((Object)("Bridge version " + Configurations.getVersion()));
            mLogger.debug((Object)"......................................................................");
        }
        if (!pSessionContext.getRhioName().equals(SessionContext.DEFAULT.getRhioName())) {
            AuditConfig audit = context.getAllAvailableResources()[0].getRhioConfiguration().getAuditConfig();
            if (audit.getAuditUri() != null) {
                AtnaAgentFactory.getAtnaAgent().setAuditRepository(new URI(audit.getAuditUri().defaultUri()));
                AtnaAgentFactory.getAtnaAgent().setAuditSourceId(pSessionContext.getUserApplicationName());
                AtnaAgentFactory.getAtnaAgent().setInitiatingUser(pSessionContext.getUser());
                AtnaAgentFactory.getAtnaAgent().setDoAudit(true);
                if (mLogger.isInfoEnabled()) {
                    mLogger.info((Object)("Audit enabled to " + audit.getAuditUri().defaultUri()));
                }
            } else {
                if (AtnaAgentFactory.getAtnaAgent() != null) {
                    AtnaAgentFactory.getAtnaAgent().setDoAudit(false);
                } else if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                    mLogger.error((Object)"THIS SHOULD NEVER HAPPEN!!! ", (Throwable)new IllegalStateException("AtnaAgentFactory.getAtnaAgent() == null, that should never happen"));
                }
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)"Audit disabled");
                }
            }
        } else {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Using default RHIO \"NO_RHIO\".  Audit disabled.");
            }
            if (AtnaAgentFactory.getAtnaAgent() != null) {
                AtnaAgentFactory.getAtnaAgent().setDoAudit(false);
            }
        }
    }

    public static void stop(ResponseType pResponse) throws Throwable {
        if (sTransactionContext.get() == null) {
            throw new IllegalStateException("no transactions going on now");
        }
        TransactionContext context = sTransactionContext.get();
        if (mTransactionHandlerFactory != null) {
            mTransactionHandlerFactory.stop();
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)"Transaction cleared configurations");
            mLogger.debug((Object)"......................................................................");
            mLogger.debug((Object)("end transaction mark for " + context.getSessionContext()));
            mLogger.debug((Object)("Transaction took " + (System.currentTimeMillis() - context.getStartTime()) + " miliseconds"));
            mLogger.debug((Object)"......................................................................");
        }
        sTransactionContext.set(null);
        if (pResponse != null) {
            pResponse.setLog(context.getSessionContext().logList().toArray(new String[context.getSessionContext().logList().size()]));
        }
    }

    public SessionContext getSessionContext() {
        return this.mSessionContext;
    }

    public long getStartTime() {
        return this.mStartTime;
    }

    public static void setXdsResourcesFactory(XdsResourcesFactory pXdsResourcesFactory) {
        if (mXdsResourcesFactory != null && pXdsResourcesFactory == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Unsetting XDS resource factory");
            }
            mXdsResourcesFactory = null;
            return;
        }
        if (mXdsResourcesFactory != null) {
            throw new IllegalStateException("XDSResourcesFactory is already set! it is a " + mXdsResourcesFactory.getClass().getName());
        }
        if (mLogger.isDebugEnabled()) {
            if (pXdsResourcesFactory != null) {
                mLogger.debug((Object)("XdsResourcesFactory set to be " + pXdsResourcesFactory.getClass().getName()));
            } else {
                mLogger.debug((Object)"XdsResourcesFactory set to null");
            }
        }
        mXdsResourcesFactory = pXdsResourcesFactory;
    }

    public static void setPixPdqResourcesFactory(PixPdqResourcesFactory pPixPdqResourcesFactory) {
        if (mPixPdqResourcesFactory != null && pPixPdqResourcesFactory == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Unsetting PixPdq resource factory");
            }
            mPixPdqResourcesFactory = null;
        }
        if (mPixPdqResourcesFactory != null) {
            throw new IllegalStateException("PixPdqResourcesFactory is already set!");
        }
        mPixPdqResourcesFactory = pPixPdqResourcesFactory;
    }

    public static void setTransactionHandlerFactory(TransactionHandlerFactory pTransactionHandlerFactory) {
        if (mTransactionHandlerFactory != null && pTransactionHandlerFactory == null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"Unsetting TransactionHandlerFactory");
            }
            mTransactionHandlerFactory = null;
        }
        if (mTransactionHandlerFactory != null) {
            throw new IllegalStateException("TransactionHandlerFactory is already set!");
        }
        mTransactionHandlerFactory = pTransactionHandlerFactory;
    }

    public XdsBridge getXDSBridge() throws UnavailableResourcesException {
        if (mXdsResourcesFactory == null) {
            throw new UnavailableResourcesException("XdsResourcesFactory");
        }
        return mXdsResourcesFactory.getXDSBridge();
    }

    public PIXSourceBridge getPIXSourceBridge() throws UnavailableResourcesException {
        if (mPixPdqResourcesFactory == null) {
            throw new UnavailableResourcesException("PixPdqResourcesFactory");
        }
        return mPixPdqResourcesFactory.getPIXSourceBridge();
    }

    public PatientConsumerBridge getPatientConsumerBridge() throws UnavailableResourcesException {
        if (mPixPdqResourcesFactory == null) {
            throw new UnavailableResourcesException("PixPdqResourcesFactory");
        }
        return mPixPdqResourcesFactory.getPatientConsumerBridge();
    }

    public RhioDedicatedResources[] getAllAvailableResources() throws UnavailableResourcesException {
        ArrayList<RhioDedicatedResources> list = new ArrayList<RhioDedicatedResources>();
        RhioDedicatedResources pixpdq = this.getPixPdqResources();
        RhioDedicatedResources xds = this.getXdsResources();
        if (pixpdq != null) {
            list.add(pixpdq);
        }
        if (xds != null) {
            list.add(xds);
        }
        return list.toArray(new RhioDedicatedResources[list.size()]);
    }

    public static TransactionHandlerFactory getTransactionHandlerFactory() {
        return mTransactionHandlerFactory;
    }
}

