/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf.builder;

import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.DefaultMessageQueryName;
import org.eclipse.ohf.bridge.conf.builder.BridgeConfigurationException;
import org.eclipse.ohf.bridge.conf.builder.RhioConfigBuilderUtils;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationFacilityAndAuthorityProperties;
import org.eclipse.ohf.bridge.conf.rhio.PixConfig;
import org.eclipse.ohf.ihe.common.config.MessageQueryName;
import org.eclipse.ohf.ihe.common.config.Pix;
import org.eclipse.ohf.ihe.common.config.PixProperties;
import org.eclipse.ohf.ihe.common.config.RhioConfigurationsType;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PixServerBuilder {
    static Map<String, PixConfig> getPixServers(RhioConfigurationsType pRhioConfigurations, boolean pVerifyUri) throws URISyntaxException, BridgeConfigurationException {
        Map<String, ApplicationFacilityAndAuthorityProperties> properties = PixServerBuilder.getProperties(pRhioConfigurations);
        Map<String, DefaultMessageQueryName> messageQueryNames = PixServerBuilder.getMessageQueryName(pRhioConfigurations);
        HashMap<String, PixConfig> destServers = new HashMap<String, PixConfig>();
        EList sourceServers = pRhioConfigurations.getPix();
        for (Pix source : sourceServers) {
            PixConfig dest = PixServerBuilder.createPixConfig(source, properties, messageQueryNames, pVerifyUri);
            if (destServers.get(source.getId()) != null) {
                throw new BridgeConfigurationException("PIX Id " + source.getId() + " already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private static Map<String, ApplicationFacilityAndAuthorityProperties> getProperties(RhioConfigurationsType pRhioConfigurations) {
        HashMap<String, ApplicationFacilityAndAuthorityProperties> destinations = new HashMap<String, ApplicationFacilityAndAuthorityProperties>();
        EList sources = pRhioConfigurations.getPixProperties();
        for (PixProperties source : sources) {
            ApplicationFacilityAndAuthorityProperties dest = PixServerBuilder.createApplicationFacilityAndAuthorityProperties(source.getApplication(), source.getFacility(), source.getAssigningAuthorityNamespaceId(), source.getAssigningAuthorityUniversalId(), source.getAssigningAuthorityUniversalIdType());
            if (destinations.get(source.getId()) != null) {
                throw new IllegalStateException("Id " + source.getId() + " of " + dest + " already exist");
            }
            destinations.put(source.getId(), dest);
        }
        return destinations;
    }

    private static PixConfig createPixConfig(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, Map<String, DefaultMessageQueryName> pMessageQueryNames, boolean pVerifyUri) throws BridgeConfigurationException, URISyntaxException {
        PixConfig config = new PixConfig();
        config.setDefaultPixUri(RhioConfigBuilderUtils.createIheUri(pSource.getMllp(), false, pVerifyUri));
        config.setQueryPixUri(RhioConfigBuilderUtils.createIheUri(pSource.getMllpQuery(), false, pVerifyUri));
        PixServerBuilder.setPixSourceProperties(pSource, pProperties, config);
        PixServerBuilder.setPixConsumerProperties(pSource, pProperties, config);
        PixServerBuilder.setPixServerProperties(pSource, pProperties, config);
        PixServerBuilder.setPdqServerProperties(pSource, pProperties, config);
        PixServerBuilder.setPdqConsumerProperties(pSource, pProperties, config);
        String messageQueryNameId = pSource.getDefaultMessageQueryNameId();
        if (messageQueryNameId != null) {
            config.setDefaultMessageQueryName(PixServerBuilder.getMessageQueryNames(pMessageQueryNames, messageQueryNameId));
        }
        return config;
    }

    private static void setPixSourceProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, PixConfig config) throws BridgeConfigurationException {
        String id = pSource.getPixSourcePropertiesId();
        if (id != null) {
            ApplicationFacilityAndAuthorityProperties properties = PixServerBuilder.getProperties(pSource, pProperties, id);
            config.setPixSourceProperties(properties);
        }
    }

    private static void setPixConsumerProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, PixConfig config) throws BridgeConfigurationException {
        String id = pSource.getPixConsumerPropertiesId();
        if (id != null) {
            ApplicationFacilityAndAuthorityProperties properties = PixServerBuilder.getProperties(pSource, pProperties, id);
            config.setPixConsumerProperties(properties);
        }
    }

    private static void setPixServerProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, PixConfig config) throws BridgeConfigurationException {
        String id = pSource.getPixServerPropertiesId();
        if (id != null) {
            ApplicationFacilityAndAuthorityProperties properties = PixServerBuilder.getProperties(pSource, pProperties, id);
            config.setPixServerProperties(properties);
        }
    }

    private static void setPdqServerProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, PixConfig config) throws BridgeConfigurationException {
        String id = pSource.getPdqServerPropertiesId();
        if (id != null) {
            ApplicationFacilityAndAuthorityProperties properties = PixServerBuilder.getProperties(pSource, pProperties, id);
            config.setPdqServerProperties(properties);
        }
    }

    private static void setPdqConsumerProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, PixConfig config) throws BridgeConfigurationException {
        String id = pSource.getPdqConsumerPropertiesId();
        if (id != null) {
            ApplicationFacilityAndAuthorityProperties properties = PixServerBuilder.getProperties(pSource, pProperties, id);
            config.setPdqConsumerProperties(properties);
        }
    }

    private static ApplicationFacilityAndAuthorityProperties getProperties(Pix pSource, Map<String, ApplicationFacilityAndAuthorityProperties> pProperties, String id) throws BridgeConfigurationException {
        if (Utils.isEmptyOrNull(id)) {
            return null;
        }
        ApplicationFacilityAndAuthorityProperties properties = pProperties.get(id);
        if (properties == null) {
            throw new BridgeConfigurationException("there is no chiled id " + id + " for parent id " + pSource.getId());
        }
        return properties;
    }

    private static ApplicationFacilityAndAuthorityProperties createApplicationFacilityAndAuthorityProperties(String pApplication, String pFacility, String pAssigningAuthorityNamespaceId, String pAssigningAuthorityUniversalId, String pAssigningAuthorityUniversalIdType) {
        ApplicationFacilityAndAuthorityProperties dest = new ApplicationFacilityAndAuthorityProperties();
        dest.setApplication(pApplication);
        dest.setFacility(pFacility);
        dest.setAssigningAuthorityNamespaceId(pAssigningAuthorityNamespaceId);
        dest.setAssigningAuthorityUniversalId(pAssigningAuthorityUniversalId);
        dest.setAssigningAuthorityUniversalIdType(pAssigningAuthorityUniversalIdType);
        return dest;
    }

    private static Map<String, DefaultMessageQueryName> getMessageQueryName(RhioConfigurationsType pRhioConfigurations) {
        HashMap<String, DefaultMessageQueryName> destServers = new HashMap<String, DefaultMessageQueryName>();
        EList sourceServers = pRhioConfigurations.getMessageQueryName();
        for (MessageQueryName source : sourceServers) {
            DefaultMessageQueryName dest = PixServerBuilder.createDefaultMessageQueryNameConfig(source);
            if (destServers.get(source.getId()) != null) {
                throw new IllegalStateException("MessageQueryName Id already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private static DefaultMessageQueryName createDefaultMessageQueryNameConfig(MessageQueryName pSource) {
        DefaultMessageQueryName dest = new DefaultMessageQueryName();
        dest.setQpd11Identifier(pSource.getQpd11Identifier());
        dest.setQpd12Text(pSource.getQpd12Text());
        dest.setQpd13NameOfCodingSystem(pSource.getQpd13NameOfCodingSystem());
        return dest;
    }

    private static DefaultMessageQueryName getMessageQueryNames(Map<String, DefaultMessageQueryName> pMessageQueryNames, String pMessageQueryNameId) {
        DefaultMessageQueryName names = pMessageQueryNames.get(pMessageQueryNameId);
        if (names == null) {
            throw new IllegalStateException("No Message Query Name with id = " + pMessageQueryNameId);
        }
        return names;
    }
}

