/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.conf.builder;

import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.bridge.conf.RhioConfigManager;
import org.eclipse.ohf.bridge.conf.SessionContext;
import org.eclipse.ohf.bridge.conf.builder.BridgeConfigurationException;
import org.eclipse.ohf.bridge.conf.builder.PixServerBuilder;
import org.eclipse.ohf.bridge.conf.builder.RhioConfigBuilderUtils;
import org.eclipse.ohf.bridge.conf.rhio.AuditConfig;
import org.eclipse.ohf.bridge.conf.rhio.PixConfig;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.bridge.conf.rhio.XcaGatewayConfig;
import org.eclipse.ohf.bridge.conf.rhio.XdsRegistryConfig;
import org.eclipse.ohf.bridge.conf.rhio.XdsRepositoryConfig;
import org.eclipse.ohf.ihe.common.config.Audit;
import org.eclipse.ohf.ihe.common.config.ConfigPackage;
import org.eclipse.ohf.ihe.common.config.DocumentRoot;
import org.eclipse.ohf.ihe.common.config.Registry;
import org.eclipse.ohf.ihe.common.config.Repository;
import org.eclipse.ohf.ihe.common.config.Rhio;
import org.eclipse.ohf.ihe.common.config.RhioConfigurationsType;
import org.eclipse.ohf.ihe.common.config.XcaGateway;
import org.eclipse.ohf.ihe.common.config.util.ConfigResourceFactoryImpl;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RhioConfigManagerImpl
implements RhioConfigManager {
    static final Logger mLogger = Logger.getLogger(RhioConfigManagerImpl.class);
    private Resource mResource = null;
    private RhioConfigurationsType mRhioConfigurations = null;
    private Map<String, RhioConfig> mRhioConfigMap;
    private boolean mVerifyUri = false;

    public RhioConfigManagerImpl(String pConfigFile, boolean pVerifyUri) throws IOException, URISyntaxException, BridgeConfigurationException {
        this.mVerifyUri = pVerifyUri;
        if (pConfigFile == null) {
            throw new IllegalStateException("rhio config file is null");
        }
        this.load(pConfigFile);
    }

    @Override
    public void close() {
        this.mResource.unload();
        this.mRhioConfigurations = null;
        this.mRhioConfigMap = null;
    }

    private void load(String pConfigFile) throws IOException, URISyntaxException, BridgeConfigurationException {
        this.mResource = new ConfigResourceFactoryImpl().createResource(URI.createURI((String)"http://config.common.ihe.ohf.eclipse.org"));
        ConfigPackage packageInstance = ConfigPackage.eINSTANCE;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("loaded " + packageInstance.getClass()));
        }
        ByteArrayInputStream bais = this.getConfigXML(pConfigFile);
        try {
            this.mResource.load((InputStream)bais, null);
        }
        finally {
            if (bais != null) {
                bais.close();
            }
        }
        EList list = this.mResource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        this.mRhioConfigurations = root.getRhioConfigurations();
        this.populateRhioConfigMap();
    }

    private ByteArrayInputStream getConfigXML(String pPath) throws IOException {
        File file = new File(pPath);
        if (file.exists()) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Got rhio config file from " + file.getAbsolutePath()));
            }
            return this.getConfigXML(file);
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("RHIO config file is not at " + file.getAbsolutePath()));
        }
        URL url = new URL(pPath);
        return this.getConfigXML(url);
    }

    private ByteArrayInputStream getConfigXML(URL pUrl) throws IOException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("using URL to get the config file: " + pUrl.toExternalForm()));
        }
        InputStream is = pUrl.openStream();
        InputStreamReader isr = new InputStreamReader(is);
        BufferedReader br = new BufferedReader(isr);
        StringBuffer sb = new StringBuffer();
        try {
            String line = br.readLine();
            while (line != null) {
                sb.append(line);
                line = br.readLine();
            }
        }
        finally {
            if (is != null) {
                is.close();
            }
            if (isr != null) {
                isr.close();
            }
            if (br != null) {
                br.close();
            }
        }
        return new ByteArrayInputStream(sb.toString().getBytes());
    }

    private ByteArrayInputStream getConfigXML(File pFile) throws IOException {
        byte[] input = new byte[(int)pFile.length()];
        FileInputStream fis = null;
        ByteArrayInputStream bais = null;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("loading EMF from " + pFile.getAbsolutePath()));
        }
        fis = new FileInputStream(pFile);
        try {
            fis.read(input);
            bais = new ByteArrayInputStream(input);
        }
        finally {
            if (fis != null) {
                fis.close();
            }
        }
        return bais;
    }

    private void populateRhioConfigMap() throws MalformedURLException, URISyntaxException, BridgeConfigurationException {
        if (this.mRhioConfigMap != null) {
            throw new IllegalStateException("RhioConfigMap is not null");
        }
        Map<String, AuditConfig> auditServers = this.getAuditServers(this.mRhioConfigurations);
        Map<String, XdsRegistryConfig> registryServers = this.getRegistryServers(this.mRhioConfigurations);
        Map<String, XdsRepositoryConfig> repositoryServers = this.getRepositoryServers(this.mRhioConfigurations);
        Map<String, PixConfig> pixServers = PixServerBuilder.getPixServers(this.mRhioConfigurations, this.mVerifyUri);
        Map<String, XcaGatewayConfig> xcaGatewayServers = this.getXcaGatewayServers(this.mRhioConfigurations);
        this.mRhioConfigMap = new HashMap<String, RhioConfig>();
        EList rhios = this.mRhioConfigurations.getRhio();
        for (Rhio rhio : rhios) {
            RhioConfig rhioConfig = this.createRhioConfig(rhio, auditServers, registryServers, repositoryServers, xcaGatewayServers, pixServers);
            this.mRhioConfigMap.put(rhioConfig.getName(), rhioConfig);
        }
    }

    private Map<String, XdsRepositoryConfig> getRepositoryServers(RhioConfigurationsType pRhioConfigurations) throws URISyntaxException {
        HashMap<String, XdsRepositoryConfig> destServers = new HashMap<String, XdsRepositoryConfig>();
        EList sourceServers = this.mRhioConfigurations.getRepository();
        for (Repository source : sourceServers) {
            XdsRepositoryConfig dest = this.createRepositoryConfig(source);
            if (destServers.get(source.getId()) != null) {
                throw new IllegalStateException("Repository Id already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private Map<String, XdsRegistryConfig> getRegistryServers(RhioConfigurationsType pRhioConfigurations) throws URISyntaxException {
        HashMap<String, XdsRegistryConfig> destServers = new HashMap<String, XdsRegistryConfig>();
        EList sourceServers = this.mRhioConfigurations.getRegistry();
        for (Registry source : sourceServers) {
            XdsRegistryConfig dest = this.createRegistryConfig(source);
            if (destServers.get(source.getId()) != null) {
                throw new IllegalStateException("Registry Id already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private Map<String, AuditConfig> getAuditServers(RhioConfigurationsType pRhioConfigurations) throws URISyntaxException {
        HashMap<String, AuditConfig> destServers = new HashMap<String, AuditConfig>();
        EList sourceServers = this.mRhioConfigurations.getAudit();
        for (Audit source : sourceServers) {
            AuditConfig dest = this.createAuditConfig(source);
            if (destServers.get(source.getId()) != null) {
                throw new IllegalStateException("Audit Id already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private Map<String, XcaGatewayConfig> getXcaGatewayServers(RhioConfigurationsType pRhioConfigurations) throws URISyntaxException {
        HashMap<String, XcaGatewayConfig> destServers = new HashMap<String, XcaGatewayConfig>();
        EList sourceServers = this.mRhioConfigurations.getXcaGateway();
        for (XcaGateway source : sourceServers) {
            XcaGatewayConfig dest = this.createXcaGatewayConfig(source);
            if (destServers.get(source.getId()) != null) {
                throw new IllegalStateException("XCA Gateway Id already exit for " + dest);
            }
            destServers.put(source.getId(), dest);
        }
        return destServers;
    }

    private RhioConfig createRhioConfig(Rhio pSource, Map<String, AuditConfig> pAuditServers, Map<String, XdsRegistryConfig> pRegistryServers, Map<String, XdsRepositoryConfig> pRepositoryServers, Map<String, XcaGatewayConfig> pXcaGatewayServers, Map<String, PixConfig> pPixServers) throws MalformedURLException, URISyntaxException {
        XcaGatewayConfig gateway;
        RhioConfig config = new RhioConfig();
        if (pSource.getPublicHealthcareAffinityDomain() != null) {
            config.setPublicHealthcareAffinityDomain(pSource.getPublicHealthcareAffinityDomain());
        }
        config.setHidden(pSource.isHidden());
        config.setDescription(pSource.getDescription());
        config.setName(pSource.getName());
        config.setDefaultRepositoryName(pSource.getDefaultRepository());
        if (pSource.getConfig().getPixId() != null) {
            PixConfig pix = pPixServers.get(pSource.getConfig().getPixId());
            if (pix == null) {
                throw new IllegalStateException("could not find pix config server with id = " + pSource.getConfig().getPixId());
            }
            config.setPixConfig(pix);
        }
        if (pSource.getConfig().getRegistryId() != null) {
            XdsRegistryConfig registry = pRegistryServers.get(pSource.getConfig().getRegistryId());
            if (registry == null) {
                throw new IllegalStateException("could not find registry config server with id = " + pSource.getConfig().getRegistryId());
            }
            config.setXdsRegistryConfig(registry);
        }
        if (pSource.getConfig().getRegistryId() != null && (gateway = pXcaGatewayServers.get(pSource.getConfig().getXcaGatewayId())) != null) {
            config.setXcaGatewayConfig(gateway);
        }
        XdsRepositoryConfig defaultRepository = null;
        if (pSource.getConfig().getRepositoryId() != null) {
            EList repositories = pSource.getConfig().getRepositoryId();
            for (String repositoryId : repositories) {
                XdsRepositoryConfig repository = pRepositoryServers.get(repositoryId);
                if (repository == null) {
                    throw new IllegalStateException("could not find repository config server with id = " + pSource.getConfig().getRepositoryId());
                }
                if (defaultRepository == null) {
                    defaultRepository = repository;
                }
                config.getXdsRepositoryConfig().put(repositoryId, repository);
            }
        }
        if (pSource.getConfig().getAuditId() != null) {
            AuditConfig audit = pAuditServers.get(pSource.getConfig().getAuditId());
            if (audit == null) {
                throw new IllegalStateException("could not find audit config server with id = " + pSource.getConfig().getAuditId());
            }
            config.setAuditConfig(audit);
        }
        if (config.getDefaultRepositoryName() != null && !config.getDefaultRepositoryName().equals("")) {
            XdsRepositoryConfig tempConfig = pRepositoryServers.get(config.getDefaultRepositoryName());
            if (tempConfig == null) {
                mLogger.error((Object)("The default repository specified for RHIO Configuration " + config.getName() + " could not be found.  Defaulting to first repository listed."));
            } else {
                defaultRepository = tempConfig;
            }
        }
        config.setDefaultXdsRepositoryConfig(defaultRepository);
        return config;
    }

    private AuditConfig createAuditConfig(Audit pSource) throws URISyntaxException {
        AuditConfig config = new AuditConfig();
        config.setAuditUri(RhioConfigBuilderUtils.createIheUri(pSource.getUrl(), false, this.mVerifyUri));
        return config;
    }

    private XdsRepositoryConfig createRepositoryConfig(Repository pSource) throws URISyntaxException {
        XdsRepositoryConfig config = new XdsRepositoryConfig();
        config.setRepositoryUniqueId(pSource.getRepositoryUniqueId());
        config.setXdsType(pSource.getXdsVersion().getLiteral());
        config.setProvideAndRegisterUrl(RhioConfigBuilderUtils.createIheUri(pSource.getProvideRegisterUrl(), true, this.mVerifyUri));
        config.setRetrieveUrl(RhioConfigBuilderUtils.createIheUri(pSource.getRetrieveDocumentUrl(), true, this.mVerifyUri));
        return config;
    }

    private XdsRegistryConfig createRegistryConfig(Registry pSource) throws URISyntaxException {
        XdsRegistryConfig config = new XdsRegistryConfig();
        config.setXdsType(pSource.getXdsVersion().getLiteral());
        config.setNonStoredQueryUrl(RhioConfigBuilderUtils.createIheUri(pSource.getNonStoredQueryUrl(), true, this.mVerifyUri));
        config.setStoredQueryUrl(RhioConfigBuilderUtils.createIheUri(pSource.getStoredQueryUrl(), true, this.mVerifyUri));
        config.setMllp(RhioConfigBuilderUtils.createIheUri(pSource.getMllp(), false, this.mVerifyUri));
        return config;
    }

    private XcaGatewayConfig createXcaGatewayConfig(XcaGateway pGateway) throws URISyntaxException {
        XcaGatewayConfig config = new XcaGatewayConfig();
        config.setStoredQueryUrl(RhioConfigBuilderUtils.createIheUri(pGateway.getStoredQueryUrl(), true, this.mVerifyUri));
        config.setRetrieveUrl(RhioConfigBuilderUtils.createIheUri(pGateway.getRetrieveDocumentUrl(), true, this.mVerifyUri));
        return config;
    }

    @Override
    public RhioConfig[] getRhios() {
        ArrayList<RhioConfig> list = new ArrayList<RhioConfig>(this.mRhioConfigMap.values());
        return list.toArray(new RhioConfig[list.size()]);
    }

    @Override
    public RhioConfig getRhioConfig(String pRhioName) {
        if (SessionContext.DEFAULT.getRhioName().equals(pRhioName)) {
            return null;
        }
        RhioConfig conf = this.mRhioConfigMap.get(pRhioName);
        if (conf == null) {
            throw new IllegalArgumentException("No configurations for " + pRhioName);
        }
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Found confugurations for rhio " + pRhioName));
        }
        return conf;
    }
}

