/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.type;

import java.io.Serializable;
import org.apache.log4j.Level;
import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.ohf.bridge.Utils;

public class DateTimeRangeType
implements Serializable {
    private static final long serialVersionUID = 6456900451812603884L;
    private String mAttributeName;
    private String mFrom;
    private String mTo;
    static final Logger mLogger = Logger.getLogger(DateTimeRangeType.class);
    private static final int MIN_TIME_FORMAT_LENGTH = 4;

    public String getFrom() {
        return this.mFrom;
    }

    public void setFrom(String pFrom) {
        this.mFrom = this.validateAndSet(pFrom);
    }

    private String validateAndSet(String pTime) {
        block7: {
            if (!Utils.isEmptyOrNull(pTime)) break block7;
            return null;
        }
        try {
            pTime = pTime.trim();
            if (pTime.length() < 4) {
                throw new IllegalArgumentException("time length should be at least4 where you use " + pTime + " which has a length of " + pTime.length());
            }
            int i = 0;
            while (i < pTime.length()) {
                if (!Character.isDigit(pTime.charAt(i))) {
                    throw new IllegalArgumentException("time string use none digit charecters like " + pTime.charAt(i) + " as part of [" + pTime + "]");
                }
                ++i;
            }
        }
        catch (IllegalArgumentException e) {
            if (mLogger.getEffectiveLevel().isGreaterOrEqual((Priority)Level.ERROR)) {
                mLogger.debug((Object)"validateAndSet failed", (Throwable)e);
            }
            throw e;
        }
        return pTime;
    }

    public String getAttributeName() {
        return this.mAttributeName;
    }

    public void setAttributeName(String pAttributeName) {
        this.mAttributeName = pAttributeName.trim();
    }

    public String getTo() {
        return this.mTo;
    }

    public void setTo(String pTo) {
        this.mTo = this.validateAndSet(pTo);
    }

    public String toString() {
        StringBuffer retValue = new StringBuffer();
        retValue.append("DateTimeRangeType ( ").append("mAttributeName=[").append(this.mAttributeName).append("]").append("    ").append("mFrom=[").append(this.mFrom).append("]").append("    ").append("mTo=[").append(this.mTo).append("]").append("    ").append(" )");
        return retValue.toString();
    }
}

