/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.transform;

import java.util.Iterator;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ClassificationType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExternalIdentifierType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.RimFactory;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.SlotType1;
import org.eclipse.ohf.ihe.common.ebxml._3._0.rim.ValueListType;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.SourcePatientInfoType;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;
import org.eclipse.ohf.ihe.common.hl7v2.format.HL7V2MessageFormat;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.ExtensionType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.transform.DocumentEntryTransformer;
import org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0TransformerConstants;
import org.eclipse.ohf.ihe.xds.metadata.transform.MetadataTransformationException;

public class EbXML_3_0DocumentEntryTransformer
implements DocumentEntryTransformer {
    public static final String DESCRIPTOR = "EBXML_3_0_DE_XFRMR";
    private static final Logger logger;
    private ExtrinsicObjectType docData = null;
    private AssociationType1 parentData = null;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.transform.EbXML_3_0DocumentEntryTransformer");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public ExtrinsicObjectType getExtrinsicObject() {
        return this.docData;
    }

    public AssociationType1 getAssociation() {
        return this.parentData;
    }

    public void transform(DocumentEntryType docEntry) throws MetadataTransformationException {
        if (docEntry == null) {
            logger.error((Object)"DocumentEntry is null, cannot execute transformation.");
            throw new MetadataTransformationException("DocumentEntry is null, cannot execute transformation.");
        }
        this.docData = RimFactory.eINSTANCE.createExtrinsicObjectType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting attributes on the Extrinsic Object.");
        }
        this.setExtrinsicObjectAttributes(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Name on the Extrinsic Object.");
        }
        this.docData.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getTitle()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Description on the Extrinsic Object.");
        }
        this.docData.setDescription(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getComments()));
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Slots on the Extrinsic Object.");
        }
        this.setExtrinsicObjectSlots(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting Classifications on the Extrinsic Object.");
        }
        this.setExtrinsicObjectClassifications(docEntry);
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Setting ExternalIdentifiers on the Extrinsic Object.");
        }
        this.setExtringsicObjectExternalIdentifiers(docEntry);
        if (docEntry.getParentDocument() != null) {
            this.parentData = RimFactory.eINSTANCE.createAssociationType1();
            if (docEntry.getParentDocument().getParentDocumentId() != null) {
                this.parentData.setTargetObject(docEntry.getParentDocument().getParentDocumentId());
            }
            if (docEntry.getParentDocument().getParentDocumentRelationship() != null) {
                this.parentData.setAssociationType(docEntry.getParentDocument().getParentDocumentRelationship().getName());
            }
            if (docEntry.getParentDocument().getParentDocumentRelationshipCode() != null) {
                EList classifications = this.parentData.getClassification();
                ClassificationType c = RimFactory.eINSTANCE.createClassificationType();
                EList slots = c.getSlot();
                SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
                ValueListType list = RimFactory.eINSTANCE.createValueListType();
                String associationId = "ThisAssociation";
                this.parentData.setId(associationId);
                c.setClassificationScheme("urn:uuid:abd807a3-4432-4053-87b4-fd82c643d1f3");
                c.setClassifiedObject(associationId);
                c.setNodeRepresentation(docEntry.getParentDocument().getParentDocumentRelationshipCode().getCode());
                c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getParentDocument().getParentDocumentRelationshipCode().getDisplayName()));
                if (docEntry.getClassCode().getSchemeName() != null) {
                    slot.setValueList(list);
                    slot.setName("codingScheme");
                    slot.getValueList().getValue().add((Object)docEntry.getParentDocument().getParentDocumentRelationshipCode().getSchemeName());
                    slots.add((Object)slot);
                }
                classifications.add((Object)c);
            }
            this.parentData.setSourceObject(docEntry.getEntryUUID());
        } else if (logger.isDebugEnabled()) {
            logger.debug((Object)("No parentDocumentID for " + docEntry.getEntryUUID() + "."));
        }
    }

    private void setExtrinsicObjectAttributes(DocumentEntryType docEntry) {
        this.docData.setId(docEntry.getEntryUUID());
        this.docData.setObjectType("urn:uuid:7edca82f-054d-47f2-a032-9b2a5b5186c1");
        if (docEntry.isSetAvailabilityStatus()) {
            if (docEntry.getAvailabilityStatus().equals(AvailabilityStatusType.APPROVED_LITERAL)) {
                this.docData.setStatus(EbXML_3_0TransformerConstants.APPROVED_STATUS);
            } else if (docEntry.getAvailabilityStatus().equals(AvailabilityStatusType.DEPRECATED_LITERAL)) {
                this.docData.setStatus(EbXML_3_0TransformerConstants.DEPRECATED_STATUS);
            } else if (docEntry.getAvailabilityStatus().equals(AvailabilityStatusType.SUBMITTED_LITERAL)) {
                this.docData.setStatus(EbXML_3_0TransformerConstants.SUBMITTED_STATUS);
            } else if (docEntry.getAvailabilityStatus().equals(AvailabilityStatusType.WITHDRAWN_LITERAL)) {
                this.docData.setStatus(EbXML_3_0TransformerConstants.WITHDRAWN_STATUS);
            }
        }
        this.docData.setMimeType(docEntry.getMimeType());
    }

    private void setExtrinsicObjectSlots(DocumentEntryType docEntry) {
        String s;
        EList slots = this.docData.getSlot();
        SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
        ValueListType list = RimFactory.eINSTANCE.createValueListType();
        if (docEntry.getCreationTime() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("creationTime");
            slot.getValueList().getValue().add((Object)docEntry.getCreationTime());
            slots.add((Object)slot);
        }
        if (docEntry.getHash() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("hash");
            slot.getValueList().getValue().add((Object)docEntry.getHash());
            slots.add((Object)slot);
        }
        if (docEntry.getExtension() != null && docEntry.getExtension().size() > 0) {
            Iterator i = docEntry.getExtension().iterator();
            while (i.hasNext()) {
                ExtensionType extension = (ExtensionType)i.next();
                if (extension.getName() == null || extension.getValue() == null || extension.getValue().size() <= 0) continue;
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName(extension.getName());
                Iterator j = extension.getValue().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add(j.next());
                }
                slots.add((Object)slot);
            }
        }
        if (docEntry.getLanguageCode() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("languageCode");
            slot.getValueList().getValue().add((Object)docEntry.getLanguageCode());
            slots.add((Object)slot);
        }
        if (docEntry.getLegalAuthenticator() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("legalAuthenticator");
            slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((XCN)docEntry.getLegalAuthenticator(), (char)'^', (char)'&'));
            slots.add((Object)slot);
        }
        if (docEntry.getRepositoryUniqueId() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("repositoryUniqueId");
            slot.getValueList().getValue().add((Object)docEntry.getRepositoryUniqueId());
            slots.add((Object)slot);
        }
        if (docEntry.getServiceStartTime() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("serviceStartTime");
            slot.getValueList().getValue().add((Object)docEntry.getServiceStartTime());
            slots.add((Object)slot);
        }
        if (docEntry.getServiceStopTime() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("serviceStopTime");
            slot.getValueList().getValue().add((Object)docEntry.getServiceStopTime());
            slots.add((Object)slot);
        }
        if (docEntry.getSize() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("size");
            slot.getValueList().getValue().add((Object)docEntry.getSize());
            slots.add((Object)slot);
        }
        if (docEntry.getUri() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("URI");
            if (docEntry.getUri().length() <= 128) {
                slot.getValueList().getValue().add((Object)docEntry.getUri());
            } else {
                int piece = 1;
                int start = 0;
                while (start < docEntry.getUri().length()) {
                    int end = start + 128;
                    if (end > docEntry.getUri().length()) {
                        end = docEntry.getUri().length();
                    }
                    slot.getValueList().getValue().add((Object)(String.valueOf(piece) + "|" + docEntry.getUri().substring(start, end)));
                    ++piece;
                    start += 128;
                }
            }
            slots.add((Object)slot);
        }
        if (docEntry.getSourcePatientId() != null) {
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            slot.setValueList(list);
            slot.setName("sourcePatientId");
            slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((CX)docEntry.getSourcePatientId(), (char)'^', (char)'&'));
            slots.add((Object)slot);
        }
        slot = RimFactory.eINSTANCE.createSlotType1();
        list = RimFactory.eINSTANCE.createValueListType();
        slot.setValueList(list);
        slot.setName("sourcePatientInfo");
        SourcePatientInfoType pid = docEntry.getSourcePatientInfo();
        if (pid == null) {
            return;
        }
        Iterator i = pid.getPatientIdentifier().iterator();
        while (i.hasNext()) {
            s = HL7V2MessageFormat.toMessageString((CX)((CX)i.next()), (char)'^', (char)'&');
            if (s.length() <= 0) continue;
            slot.getValueList().getValue().add((Object)("PID-3|" + s));
        }
        i = pid.getPatientName().iterator();
        while (i.hasNext()) {
            s = HL7V2MessageFormat.toMessageString((XPN)((XPN)i.next()), (char)'^');
            if (s.length() <= 0) continue;
            slot.getValueList().getValue().add((Object)("PID-5|" + s));
        }
        s = pid.getPatientDateOfBirth();
        if (s != null && s.length() > 0) {
            slot.getValueList().getValue().add((Object)("PID-7|" + s));
        }
        if ((s = pid.getPatientSex()) != null && s.length() > 0) {
            slot.getValueList().getValue().add((Object)("PID-8|" + s));
        }
        if ((s = HL7V2MessageFormat.toMessageString((XAD)pid.getPatientAddress(), (char)'^')).length() > 0) {
            slot.getValueList().getValue().add((Object)("PID-11|" + s));
        }
        if ((s = HL7V2MessageFormat.toMessageString((XTN)pid.getPatientPhoneHome(), (char)'^')).length() > 0) {
            slot.getValueList().getValue().add((Object)("PID-13|" + s));
        }
        if ((s = HL7V2MessageFormat.toMessageString((XTN)pid.getPatientPhoneBusiness(), (char)'^')).length() > 0) {
            slot.getValueList().getValue().add((Object)("PID-14|" + s));
        }
        if (slot.getValueList().getValue().size() > 0) {
            slots.add((Object)slot);
        }
    }

    private void setExtrinsicObjectClassifications(DocumentEntryType docEntry) {
        EList classifications = this.docData.getClassification();
        ClassificationType c = RimFactory.eINSTANCE.createClassificationType();
        EList slots = c.getSlot();
        SlotType1 slot = RimFactory.eINSTANCE.createSlotType1();
        ValueListType list = RimFactory.eINSTANCE.createValueListType();
        c.setClassificationScheme("urn:uuid:41a5887f-8865-4c09-adf7-e362475b143a");
        c.setClassifiedObject(docEntry.getEntryUUID());
        if (docEntry.getClassCode() != null) {
            c.setNodeRepresentation(docEntry.getClassCode().getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getClassCode().getDisplayName()));
            if (docEntry.getClassCode().getSchemeName() != null) {
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)docEntry.getClassCode().getSchemeName());
                slots.add((Object)slot);
            }
        }
        classifications.add((Object)c);
        Iterator i = docEntry.getConfidentialityCode().iterator();
        while (i.hasNext()) {
            c = RimFactory.eINSTANCE.createClassificationType();
            c.setClassificationScheme("urn:uuid:f4f85eac-e6cb-4883-b524-f2705394840f");
            c.setClassifiedObject(docEntry.getEntryUUID());
            CodedMetadataType conf = (CodedMetadataType)i.next();
            c.setNodeRepresentation(conf.getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(conf.getDisplayName()));
            if (conf.getSchemeName() != null) {
                slots = c.getSlot();
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)conf.getSchemeName());
                slots.add((Object)slot);
            }
            classifications.add((Object)c);
        }
        i = docEntry.getEventCode().iterator();
        while (i.hasNext()) {
            c = RimFactory.eINSTANCE.createClassificationType();
            c.setClassificationScheme("urn:uuid:2c6b8cb7-8b2a-4051-b291-b1ae6a575ef4");
            c.setClassifiedObject(docEntry.getEntryUUID());
            CodedMetadataType event = (CodedMetadataType)i.next();
            if (event != null) {
                c.setNodeRepresentation(event.getCode());
                c.setName(EbXML_3_0DocumentEntryTransformer.copy(event.getDisplayName()));
                if (event.getSchemeName() != null) {
                    slots = c.getSlot();
                    slot = RimFactory.eINSTANCE.createSlotType1();
                    list = RimFactory.eINSTANCE.createValueListType();
                    slot.setValueList(list);
                    slot.setName("codingScheme");
                    slot.getValueList().getValue().add((Object)event.getSchemeName());
                    slots.add((Object)slot);
                }
            }
            classifications.add((Object)c);
        }
        c = RimFactory.eINSTANCE.createClassificationType();
        c.setClassificationScheme("urn:uuid:a09d5840-386c-46f2-b5ad-9c3699a4309d");
        c.setClassifiedObject(docEntry.getEntryUUID());
        if (docEntry.getFormatCode() != null) {
            c.setNodeRepresentation(docEntry.getFormatCode().getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getFormatCode().getDisplayName()));
            if (docEntry.getFormatCode().getSchemeName() != null) {
                slots = c.getSlot();
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)docEntry.getFormatCode().getSchemeName());
                slots.add((Object)slot);
            }
        }
        classifications.add((Object)c);
        c = RimFactory.eINSTANCE.createClassificationType();
        c.setClassificationScheme("urn:uuid:f33fb8ac-18af-42cc-ae0e-ed0b0bdb91e1");
        c.setClassifiedObject(docEntry.getEntryUUID());
        if (docEntry.getHealthCareFacilityTypeCode() != null) {
            c.setNodeRepresentation(docEntry.getHealthCareFacilityTypeCode().getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getHealthCareFacilityTypeCode().getDisplayName()));
            if (docEntry.getHealthCareFacilityTypeCode().getSchemeName() != null) {
                slots = c.getSlot();
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)docEntry.getHealthCareFacilityTypeCode().getSchemeName());
                slots.add((Object)slot);
            }
        }
        classifications.add((Object)c);
        c = RimFactory.eINSTANCE.createClassificationType();
        c.setClassificationScheme("urn:uuid:cccf5598-8b07-4b77-a05e-ae952c785ead");
        c.setClassifiedObject(docEntry.getEntryUUID());
        if (docEntry.getPracticeSettingCode() != null) {
            c.setNodeRepresentation(docEntry.getPracticeSettingCode().getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getPracticeSettingCode().getDisplayName()));
            if (docEntry.getPracticeSettingCode().getSchemeName() != null) {
                slots = c.getSlot();
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)docEntry.getPracticeSettingCode().getSchemeName());
                slots.add((Object)slot);
            }
        }
        classifications.add((Object)c);
        c = RimFactory.eINSTANCE.createClassificationType();
        c.setClassificationScheme("urn:uuid:f0306f51-975f-434e-a61c-c59651d33983");
        c.setClassifiedObject(docEntry.getEntryUUID());
        if (docEntry.getTypeCode() != null) {
            c.setNodeRepresentation(docEntry.getTypeCode().getCode());
            c.setName(EbXML_3_0DocumentEntryTransformer.copy(docEntry.getTypeCode().getDisplayName()));
            if (docEntry.getTypeCode().getSchemeName() != null) {
                slots = c.getSlot();
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("codingScheme");
                slot.getValueList().getValue().add((Object)docEntry.getTypeCode().getSchemeName());
                slots.add((Object)slot);
            }
        }
        classifications.add((Object)c);
        if (docEntry.getAuthor() != null) {
            Iterator j;
            c = RimFactory.eINSTANCE.createClassificationType();
            c.setClassificationScheme("urn:uuid:93606bcf-9494-43ec-9b4e-a7748d1a838d");
            c.setClassifiedObject(docEntry.getEntryUUID());
            slots = c.getSlot();
            slot = RimFactory.eINSTANCE.createSlotType1();
            list = RimFactory.eINSTANCE.createValueListType();
            if (docEntry.getAuthor().getAuthorInstitution() != null && docEntry.getAuthor().getAuthorInstitution().size() > 0) {
                slot.setValueList(list);
                slot.setName("authorInstitution");
                j = docEntry.getAuthor().getAuthorInstitution().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((XON)((XON)j.next()), (char)'^', (char)'&'));
                }
                slots.add((Object)slot);
            }
            if (docEntry.getAuthor().getAuthorPerson() != null) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorPerson");
                slot.getValueList().getValue().add((Object)HL7V2MessageFormat.toMessageString((XCN)docEntry.getAuthor().getAuthorPerson(), (char)'^', (char)'&'));
                slots.add((Object)slot);
            }
            if (docEntry.getAuthor().getAuthorRole() != null && docEntry.getAuthor().getAuthorRole().size() > 0) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorRole");
                j = docEntry.getAuthor().getAuthorRole().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)((String)j.next()));
                }
                slots.add((Object)slot);
            }
            if (docEntry.getAuthor().getAuthorSpeciality() != null && docEntry.getAuthor().getAuthorSpeciality().size() > 0) {
                slot = RimFactory.eINSTANCE.createSlotType1();
                list = RimFactory.eINSTANCE.createValueListType();
                slot.setValueList(list);
                slot.setName("authorSpecialty");
                j = docEntry.getAuthor().getAuthorSpeciality().iterator();
                while (j.hasNext()) {
                    slot.getValueList().getValue().add((Object)((String)j.next()));
                }
                slots.add((Object)slot);
            }
            classifications.add((Object)c);
        }
    }

    private void setExtringsicObjectExternalIdentifiers(DocumentEntryType docEntry) {
        EList externalIdentifiers = this.docData.getExternalIdentifier();
        org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType idName = RimFactory.eINSTANCE.createLocalizedStringType();
        org.eclipse.ohf.ihe.common.ebxml._3._0.rim.InternationalStringType exIDName = RimFactory.eINSTANCE.createInternationalStringType();
        ExternalIdentifierType exID = RimFactory.eINSTANCE.createExternalIdentifierType();
        if (docEntry.getPatientId() != null) {
            exID.setValue(HL7V2MessageFormat.toMessageString((CX)docEntry.getPatientId(), (char)'^', (char)'&'));
            idName.setValue("XDSDocumentEntry.patientId");
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:58a6f841-87b3-4a3e-92fd-a8ffeff98427");
            externalIdentifiers.add((Object)exID);
        }
        if (docEntry.getUniqueId() != null) {
            exID = RimFactory.eINSTANCE.createExternalIdentifierType();
            exID.setValue(docEntry.getUniqueId());
            idName = RimFactory.eINSTANCE.createLocalizedStringType();
            idName.setValue("XDSDocumentEntry.uniqueId");
            exIDName = RimFactory.eINSTANCE.createInternationalStringType();
            exIDName.getLocalizedString().add((Object)idName);
            exID.setName(exIDName);
            exID.setIdentificationScheme("urn:uuid:2e82c1f6-a085-4c72-9da3-8640a32e42ab");
            externalIdentifiers.add((Object)exID);
        }
    }

    private static org.eclipse.ohf.ihe.common.ebxml._3._0.rim.InternationalStringType copy(InternationalStringType ist) {
        org.eclipse.ohf.ihe.common.ebxml._3._0.rim.InternationalStringType result = RimFactory.eINSTANCE.createInternationalStringType();
        if (ist != null) {
            Iterator i = ist.getLocalizedString().iterator();
            while (i.hasNext()) {
                org.eclipse.ohf.ihe.common.ebxml._3._0.rim.LocalizedStringType lst = RimFactory.eINSTANCE.createLocalizedStringType();
                LocalizedStringType original = (LocalizedStringType)i.next();
                lst.setCharset(original.getCharset());
                lst.setLang(original.getLang());
                lst.setValue(original.getValue());
                result.getLocalizedString().add((Object)lst);
            }
        }
        return result;
    }
}

