/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.pdq.consumer;

import java.util.StringTokenizer;
import org.apache.log4j.Logger;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPConformanceProfile;
import org.eclipse.ohf.hl7v2.core.message.MessageManager;
import org.eclipse.ohf.hl7v2.core.message.model.Field;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqMsg;

public class PdqConsumerVisitQuery
extends PdqMsg {
    private static Logger logger;
    private static final String queryType = "ZV1";
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerVisitQuery");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public PdqConsumerVisitQuery(MessageManager globalFactory, CPConformanceProfile cpProfile) throws PdqConsumerException {
        super(globalFactory, cpProfile, queryType);
        this.nodeType = 2;
        this.createZV1Fields();
    }

    public void addQueryPatientClass(String patientClass) throws PdqConsumerException {
        this.addOptionalVisitSearch("PV1-2", patientClass);
    }

    public void addQueryPatientVisitNumberId(String visitNumberId) throws PdqConsumerException {
        this.addOptionalVisitSearch("PV1-19-1", visitNumberId);
    }

    public void addOptionalVisitSearch(String path, String data) throws PdqConsumerException {
        StringTokenizer st = new StringTokenizer(path, "-");
        String segmentCode = st.nextToken();
        if (segmentCode == null) {
            st = new StringTokenizer(path, ".");
            segmentCode = st.nextToken();
        }
        if (segmentCode == null) {
            throw new PdqConsumerException("PdqConsumerVisitQuery: addOptionalVisitSearch - unrecognized segment " + path);
        }
        if (segmentCode.compareTo("PV1") != 0 && segmentCode.compareTo("PV2") != 0) {
            throw new PdqConsumerException("PdqConsumerVisitQuery: addOptionalVisitSearch - only supporting PV1 and PV2 segments, not " + segmentCode);
        }
        try {
            StringBuffer sb = new StringBuffer();
            sb.append("@");
            sb.append(path.replaceAll("-", "."));
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).forceComponent(1);
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).getComponents().item(0).forceElement("2");
            this.getSegments().getByCodeAndIndex("QPD", 1).forceField(2).getComponents().item(1).forceElement("2");
            Field field = this.getSegments().getByCodeAndIndex("QPD", 1).getFields().item(2).addRepeat(true);
            field.forceElement("1").setAsString(sb.toString());
            field.forceElement("2").setAsString(data);
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("PdqConsumerVisitQuery: addOptionalVisitSearch - " + sb.toString() + "^" + data));
            }
        }
        catch (HL7V2Exception e) {
            throw new PdqConsumerException(e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerVisitQuery: addOptionalVisitSearch ");
        }
    }

    private void createZV1Fields() throws PdqConsumerException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"PdqConsumerVisitQuery: createZV1Fields ");
        }
    }
}

