/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe;

import java.net.URI;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.conf.AbstractRhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.ihe.atna.agent.AtnaAgentFactory;
import org.eclipse.ohf.ihe.xds.consumer.B_Consumer;
import org.eclipse.ohf.ihe.xds.consumer.Consumer;
import org.eclipse.ohf.ihe.xds.source.B_Source;
import org.eclipse.ohf.ihe.xds.source.Source;

public class XdsResources
extends AbstractRhioDedicatedResources {
    static final Logger mLogger = Logger.getLogger(XdsResources.class);
    private Consumer mXdsStoredQueriesDocumentConsumer;
    private Consumer mXdsNoneStoredQueriesDocumentConsumer;
    private Source mXdsDocumentSource;
    private B_Consumer mXcaDocumentConsumer;
    private B_Consumer mXdsBDocumentConsumer;
    private B_Source mXdsBDocumentSource;

    public XdsResources(RhioConfig pConfig) {
        super(pConfig);
    }

    public boolean isXdsBTransaction() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getXdsType().equals("b");
    }

    public boolean isNonStoredQueryResourcesAvailable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl() != null;
    }

    public boolean isStoredQueryResourcesAvailable() {
        return this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() != null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getNonStoredQueryXdsDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getNoneStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsNoneStoredQueriesDocumentConsumer != null) {
            return this.mXdsNoneStoredQueriesDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsNoneStoredQueriesDocumentConsumer != null) {
                return this.mXdsNoneStoredQueriesDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("NoneStoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl().defaultUri());
            this.mXdsNoneStoredQueriesDocumentConsumer = new Consumer(registryUri);
        }
        return this.mXdsNoneStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Consumer getStoredQueryXcaDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getStoredQueryXcaDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXcaDocumentConsumer != null) {
            return this.mXcaDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXcaDocumentConsumer != null) {
                return this.mXcaDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating XCA-specific Document Consumer with " + this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("An XCA Gateway is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXcaGatewayConfig().getStoredQueryUrl().defaultUri());
            this.mXcaDocumentConsumer = new B_Consumer(registryUri);
        }
        return this.mXcaDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Consumer getStoredQueryXdsDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getStoredQueriesXdsDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsStoredQueriesDocumentConsumer != null) {
            return this.mXdsStoredQueriesDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsStoredQueriesDocumentConsumer != null) {
                return this.mXdsStoredQueriesDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("StoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri());
            this.mXdsStoredQueriesDocumentConsumer = new Consumer(registryUri);
        }
        return this.mXdsStoredQueriesDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Source getXdsDocumentSource() throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Source getXdsDocumentSource()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsDocumentSource != null) {
            return this.mXdsDocumentSource;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsDocumentSource != null) {
                return this.mXdsDocumentSource;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"create Source");
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI repositoryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getNonStoredQueryUrl().defaultUri());
            this.mXdsDocumentSource = new Source(repositoryUri);
        }
        return this.mXdsDocumentSource;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Consumer getXdsBDocumentConsumer() throws UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Consumer getXdsBDocumentConsumer()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsBDocumentConsumer != null) {
            return this.mXdsBDocumentConsumer;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsBDocumentConsumer != null) {
                return this.mXdsBDocumentConsumer;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("creating B Consumer with " + this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri()));
            }
            if (this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl() == null) {
                throw new UnavailableResourcesException("StoredQueriesUrl is not defined for this RHIO " + TransactionContext.instant().getSessionContext());
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI registryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri());
            this.mXdsBDocumentConsumer = new B_Consumer(registryUri);
        }
        return this.mXdsBDocumentConsumer;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public B_Source getXdsBDocumentSource() throws Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting Source getXdsBDocumentSource()  in " + TransactionContext.instant().getSessionContext() + " using " + this.getRhioConfiguration()));
        }
        if (this.mXdsBDocumentSource != null) {
            return this.mXdsBDocumentSource;
        }
        XdsResources xdsResources = this;
        synchronized (xdsResources) {
            if (this.mXdsBDocumentSource != null) {
                return this.mXdsBDocumentSource;
            }
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"create B Source");
            }
            AtnaAgentFactory.getAtnaAgent().setDoAudit(this.getRhioConfiguration().getAuditConfig().getAuditUri() != null);
            URI repositoryUri = new URI(this.getRhioConfiguration().getXdsRegistryConfig().getStoredQueryUrl().defaultUri());
            this.mXdsBDocumentSource = new B_Source(repositoryUri);
        }
        return this.mXdsBDocumentSource;
    }
}

