/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ApplicationMediaType
extends AbstractEnumerator {
    public static final int APPLICATION_DICOM = 0;
    public static final int APPLICATION_MSWORD = 1;
    public static final int APPLICATION_PDF = 2;
    public static final ApplicationMediaType APPLICATION_DICOM_LITERAL = new ApplicationMediaType(0, "applicationDicom", "application/dicom");
    public static final ApplicationMediaType APPLICATION_MSWORD_LITERAL = new ApplicationMediaType(1, "applicationMsword", "application/msword");
    public static final ApplicationMediaType APPLICATION_PDF_LITERAL = new ApplicationMediaType(2, "applicationPdf", "application/pdf");
    private static final ApplicationMediaType[] VALUES_ARRAY = new ApplicationMediaType[]{APPLICATION_DICOM_LITERAL, APPLICATION_MSWORD_LITERAL, APPLICATION_PDF_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ApplicationMediaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApplicationMediaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApplicationMediaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ApplicationMediaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ApplicationMediaType get(int value) {
        switch (value) {
            case 0: {
                return APPLICATION_DICOM_LITERAL;
            }
            case 1: {
                return APPLICATION_MSWORD_LITERAL;
            }
            case 2: {
                return APPLICATION_PDF_LITERAL;
            }
        }
        return null;
    }

    private ApplicationMediaType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

