/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class IntegrityCheckAlgorithm
extends AbstractEnumerator {
    public static final int SHA1 = 0;
    public static final int SHA256 = 1;
    public static final IntegrityCheckAlgorithm SHA1_LITERAL = new IntegrityCheckAlgorithm(0, "SHA1", "SHA-1");
    public static final IntegrityCheckAlgorithm SHA256_LITERAL = new IntegrityCheckAlgorithm(1, "SHA256", "SHA-256");
    private static final IntegrityCheckAlgorithm[] VALUES_ARRAY = new IntegrityCheckAlgorithm[]{SHA1_LITERAL, SHA256_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static IntegrityCheckAlgorithm get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntegrityCheckAlgorithm result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntegrityCheckAlgorithm getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            IntegrityCheckAlgorithm result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static IntegrityCheckAlgorithm get(int value) {
        switch (value) {
            case 0: {
                return SHA1_LITERAL;
            }
            case 1: {
                return SHA256_LITERAL;
            }
        }
        return null;
    }

    private IntegrityCheckAlgorithm(int value, String name, String literal) {
        super(value, name, literal);
    }
}

