/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class TextMediaType
extends AbstractEnumerator {
    public static final int TEXT_HTML = 0;
    public static final int TEXT_PLAIN = 1;
    public static final int TEXT_RTF = 2;
    public static final int TEXT_SGML = 3;
    public static final int TEXT_XHL7_FT = 4;
    public static final int TEXT_XML = 5;
    public static final TextMediaType TEXT_HTML_LITERAL = new TextMediaType(0, "textHtml", "text/html");
    public static final TextMediaType TEXT_PLAIN_LITERAL = new TextMediaType(1, "textPlain", "text/plain");
    public static final TextMediaType TEXT_RTF_LITERAL = new TextMediaType(2, "textRtf", "text/rtf");
    public static final TextMediaType TEXT_SGML_LITERAL = new TextMediaType(3, "textSgml", "text/sgml");
    public static final TextMediaType TEXT_XHL7_FT_LITERAL = new TextMediaType(4, "textXHl7Ft", "text/x-hl7-ft");
    public static final TextMediaType TEXT_XML_LITERAL = new TextMediaType(5, "textXml", "text/xml");
    private static final TextMediaType[] VALUES_ARRAY = new TextMediaType[]{TEXT_HTML_LITERAL, TEXT_PLAIN_LITERAL, TEXT_RTF_LITERAL, TEXT_SGML_LITERAL, TEXT_XHL7_FT_LITERAL, TEXT_XML_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static TextMediaType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextMediaType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextMediaType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            TextMediaType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static TextMediaType get(int value) {
        switch (value) {
            case 0: {
                return TEXT_HTML_LITERAL;
            }
            case 1: {
                return TEXT_PLAIN_LITERAL;
            }
            case 2: {
                return TEXT_RTF_LITERAL;
            }
            case 3: {
                return TEXT_SGML_LITERAL;
            }
            case 4: {
                return TEXT_XHL7_FT_LITERAL;
            }
            case 5: {
                return TEXT_XML_LITERAL;
            }
        }
        return null;
    }

    private TextMediaType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

