/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.Utils;
import org.eclipse.ohf.bridge.conf.DefaultMessageQueryName;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.ApplicationAndFacilityProperties;
import org.eclipse.ohf.bridge.ihe.pixpdq.IhePixPdqResourcesFactory;
import org.eclipse.ohf.bridge.ihe.pixpdq.PixPdqResources;
import org.eclipse.ohf.bridge.ihe.pixpdq.PixUtils;
import org.eclipse.ohf.bridge.pix.PatientConsumerBridge;
import org.eclipse.ohf.bridge.type.AddressType;
import org.eclipse.ohf.bridge.type.AssigningAuthorityType;
import org.eclipse.ohf.bridge.type.GenericAdtValue;
import org.eclipse.ohf.bridge.type.PatientIdType;
import org.eclipse.ohf.bridge.type.PatientInfoType;
import org.eclipse.ohf.bridge.type.PatientNameType;
import org.eclipse.ohf.bridge.type.PatientSearchPreferencesType;
import org.eclipse.ohf.bridge.type.PhoneType;
import org.eclipse.ohf.bridge.type.SearchPatientResponseType;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessage;
import org.eclipse.ohf.ihe.common.hl7v2.message.PixPdqMessageException;
import org.eclipse.ohf.ihe.common.hl7v2.mllpclient.ClientException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerDemographicQuery;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerException;
import org.eclipse.ohf.ihe.pdq.consumer.PdqConsumerResponse;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerException;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerQuery;
import org.eclipse.ohf.ihe.pix.consumer.PixConsumerResponse;

public class IhePatientConsumerBridge
implements PatientConsumerBridge {
    static final Logger mLogger = Logger.getLogger(IhePatientConsumerBridge.class);

    public SearchPatientResponseType searchPatient(PatientInfoType patientInfo, PatientSearchPreferencesType pPatientSearchPreferencesType) throws Exception {
        if (!pPatientSearchPreferencesType.isWithoutDemographics()) {
            return this.searchPatientUsingPDQ(patientInfo, pPatientSearchPreferencesType);
        }
        return this.searchPatientUsingPIX(patientInfo, pPatientSearchPreferencesType);
    }

    private SearchPatientResponseType searchPatientUsingPIX(PatientInfoType patientInfo, PatientSearchPreferencesType pPatientSearchPreferencesType) throws Exception {
        patientInfo.getPatientIdentifier().getAssigningAuthorityType().applyPixConsumerDefaults();
        PixConsumerQuery message = this.createPixConsumerQuery(patientInfo.getPatientIdentifier());
        PixConsumerResponse returnMessage = IhePixPdqResourcesFactory.getResources().getHl7PixConsumer().sendQuery(message, false);
        SearchPatientResponseType errorResponse = PixUtils.getErrorPixConsumerResponse(returnMessage);
        if (errorResponse != null) {
            return errorResponse;
        }
        return this.getPatientInfoTypesFromPixResponse(returnMessage);
    }

    private SearchPatientResponseType searchPatientUsingPDQ(PatientInfoType patientInfo, PatientSearchPreferencesType pPatientSearchPreferencesType) throws Exception {
        PdqConsumerDemographicQuery message = this.createPdqConsumerQuery(patientInfo);
        DefaultMessageQueryName defaults = IhePixPdqResourcesFactory.getResources().getDefaultMessageQueryName();
        this.applyDefaultMessageQueryName(message, defaults);
        this.applyDefaultWhatDomainsReturned(pPatientSearchPreferencesType, message);
        this.applyQuantityLimit(pPatientSearchPreferencesType, message);
        PdqConsumerResponse returnMessage = IhePixPdqResourcesFactory.getResources().getPdqConsumer().sendDemographicQuery(message, false);
        SearchPatientResponseType errorResponse = PixUtils.getErrorPdqResponse(returnMessage);
        if (errorResponse != null) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("got an error response " + errorResponse));
            }
            return errorResponse;
        }
        SearchPatientResponseType searchPatientResponseType = this.getPatientInfoTypesFromPdqResponce(returnMessage);
        while (!Utils.isEmptyOrNull((String)returnMessage.getContinuationPointer())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("got a continuation pointer and doing another query with pointer = " + returnMessage.getContinuationPointer()));
            }
            message.addOptionalContinuationPointer(returnMessage);
            returnMessage = IhePixPdqResourcesFactory.getResources().getPdqConsumer().sendDemographicQuery(message, false);
            errorResponse = PixUtils.getErrorPdqResponse(returnMessage);
            if (errorResponse != null) {
                if (mLogger.isDebugEnabled()) {
                    mLogger.debug((Object)("got an error response " + errorResponse));
                }
                return errorResponse;
            }
            this.appendPatientInfoTypesFromPdqResponse(returnMessage, searchPatientResponseType);
        }
        return searchPatientResponseType;
    }

    private void appendPatientInfoTypesFromPdqResponse(PdqConsumerResponse pReturnMessage, SearchPatientResponseType pSearchPatientResponseType) throws PdqConsumerException, PixPdqMessageException {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void appendPatientInfoTypesFromPdqResponce(" + pReturnMessage + ", " + pSearchPatientResponseType + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        ArrayList<PatientInfoType> patientList = new ArrayList<PatientInfoType>();
        Collections.addAll(patientList, pSearchPatientResponseType.getPatients());
        int patientIndex = 0;
        while (patientIndex < pReturnMessage.getPatientCount()) {
            PatientInfoType returnObject = new PatientInfoType();
            this.createPIDTypeFromPdqResponce(patientIndex, pReturnMessage, returnObject);
            patientList.add(returnObject);
            if (patientList.size() > 200) {
                mLogger.error((Object)"The size of the patient buffer is more then the max, stopping to get more patients. Buffer size is 200");
                pSearchPatientResponseType.setPatients(patientList.toArray(new PatientInfoType[patientList.size()]));
                pSearchPatientResponseType.setSuccess(false);
            }
            ++patientIndex;
        }
        pSearchPatientResponseType.setPatients(patientList.toArray(new PatientInfoType[patientList.size()]));
        pSearchPatientResponseType.setSuccess(true);
    }

    private void applyDefaultMessageQueryName(PdqConsumerDemographicQuery message, DefaultMessageQueryName defaults) throws PdqConsumerException {
        if (defaults != null) {
            message.changeDefaultMessageQueryName(defaults.getQpd11Identifier(), defaults.getQpd12Text(), defaults.getQpd13NameOfCodingSystem(), "", "", "");
        }
    }

    private PdqConsumerDemographicQuery createPdqConsumerQuery(PatientInfoType patientInfo) throws PdqConsumerException, PixPdqMessageException, ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException, Exception {
        PixPdqResources resource = IhePixPdqResourcesFactory.getResources();
        PdqConsumerDemographicQuery message = resource.getPdqConsumer().createDemographicQuery();
        if (patientInfo.getPatientIdentifier() != null) {
            if (patientInfo.getPatientIdentifier() != null && !Utils.isEmptyOrNull((String)patientInfo.getPatientIdentifier().getIdNumber())) {
                message.addQueryPatientID(patientInfo.getPatientIdentifier().getIdNumber(), "", "", "");
            }
            this.populatePdqConsumerQueryFromPatientInfo(patientInfo, message);
            PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)message, resource.getPdqConsumerProperties(), resource.getRhioConfiguration().getPixConfig().getPdqServerProperties());
        }
        return message;
    }

    private PixConsumerQuery createPixConsumerQuery(PatientIdType patientInfo) throws PdqConsumerException, ClientException, HL7V2Exception, URISyntaxException, UnavailableResourcesException, Exception {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PixConsumerQuery createPixConsumerQuery(" + patientInfo + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        AssigningAuthorityType authority = patientInfo.getAssigningAuthorityType();
        PixConsumerQuery message = IhePixPdqResourcesFactory.getResources().getHl7PixConsumer().createQuery(patientInfo.getIdNumber(), authority.getNamespaceId(), authority.getUniversalId(), authority.getUniversalIdType());
        PixPdqResources resource = IhePixPdqResourcesFactory.getResources();
        PixUtils.populateMessageWithApplicationAndFacility((PixPdqMessage)message, resource.getPixConsumerProperties(), (ApplicationAndFacilityProperties)resource.getRhioConfiguration().getPixConfig().getPixServerProperties());
        if (!Utils.isEmptyOrNull((String)authority.getUniversalIdTypeCode())) {
            message.setField("QPD-3-5", authority.getUniversalIdTypeCode());
        }
        return message;
    }

    private void applyDefaultWhatDomainsReturned(PatientSearchPreferencesType pPatientSearchPreferencesType, PdqConsumerDemographicQuery message) throws PdqConsumerException, UnavailableResourcesException {
        AssigningAuthorityType[] assigningAuthoritys;
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting void applyDefaultWhatDomainsReturned(" + pPatientSearchPreferencesType + ") " + " in " + TransactionContext.instant().getSessionContext()));
        }
        if (pPatientSearchPreferencesType != null && (assigningAuthoritys = pPatientSearchPreferencesType.getDomainsReturned()) != null) {
            int i = 0;
            while (i < assigningAuthoritys.length) {
                assigningAuthoritys[i].applyPdqConsumerDefaults();
                if (!(Utils.isEmptyOrNull((String)assigningAuthoritys[i].getNamespaceId()) && Utils.isEmptyOrNull((String)assigningAuthoritys[i].getUniversalId()) && Utils.isEmptyOrNull((String)assigningAuthoritys[i].getUniversalIdType()))) {
                    if (mLogger.isDebugEnabled()) {
                        mLogger.debug((Object)("setting message with changeDefaultWhatDomainsReturned to use " + assigningAuthoritys[i]));
                    }
                    message.changeDefaultWhatDomainsReturned(assigningAuthoritys[i].getNamespaceId(), assigningAuthoritys[i].getUniversalId(), assigningAuthoritys[i].getUniversalIdType());
                }
                ++i;
            }
        }
    }

    private void applyQuantityLimit(PatientSearchPreferencesType pPatientSearchPreferencesType, PdqConsumerDemographicQuery message) throws PdqConsumerException, UnavailableResourcesException {
        int limitRecords;
        if (pPatientSearchPreferencesType != null && (limitRecords = pPatientSearchPreferencesType.getQuantityLimit()) > 0) {
            message.addOptionalQuantityLimit(limitRecords);
        }
    }

    private SearchPatientResponseType getPatientInfoTypesFromPdqResponce(PdqConsumerResponse returnMessage) throws PdqConsumerException, PixPdqMessageException {
        ArrayList<PatientInfoType> patientList = new ArrayList<PatientInfoType>();
        int patientIndex = 0;
        while (patientIndex < returnMessage.getPatientCount()) {
            PatientInfoType returnObject = new PatientInfoType();
            this.createPIDTypeFromPdqResponce(patientIndex, returnMessage, returnObject);
            patientList.add(returnObject);
            ++patientIndex;
        }
        SearchPatientResponseType responce = new SearchPatientResponseType();
        responce.setPatients(patientList.toArray(new PatientInfoType[patientList.size()]));
        responce.setSuccess(true);
        return responce;
    }

    private SearchPatientResponseType getPatientInfoTypesFromPixResponse(PixConsumerResponse returnMessage) throws PixConsumerException {
        ArrayList<PatientInfoType> patientList = new ArrayList<PatientInfoType>();
        int patientIndex = 0;
        while (patientIndex < returnMessage.getPatientCount()) {
            int patientIdIndex = 0;
            while (patientIdIndex < returnMessage.getPatientIdentifierCount(patientIndex)) {
                PatientInfoType returnObject = new PatientInfoType();
                this.createPIDTypeFromPixResponse(patientIndex, patientIdIndex, returnMessage, returnObject);
                patientList.add(returnObject);
                ++patientIdIndex;
            }
            ++patientIndex;
        }
        SearchPatientResponseType responce = new SearchPatientResponseType();
        responce.setPatients(patientList.toArray(new PatientInfoType[patientList.size()]));
        responce.setSuccess(true);
        return responce;
    }

    private void createPIDTypeFromPdqResponce(int patientIndex, PdqConsumerResponse returnMessage, PatientInfoType returnObject) throws PdqConsumerException, PixPdqMessageException {
        PatientIdType pid = new PatientIdType();
        String[] patID = returnMessage.getPatientIdentifier(patientIndex, 0);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Retrieved a new patient ID for index " + patientIndex + " " + patID[0] + ":" + patID[1] + ":" + patID[2] + ":" + patID[3]));
        }
        pid.setIdNumber(patID[0]);
        pid.getAssigningAuthorityType().setNamespaceId(patID[1]);
        pid.getAssigningAuthorityType().setUniversalId(patID[2]);
        pid.getAssigningAuthorityType().setUniversalIdType(patID[3]);
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Adding a new patient Id with " + pid));
        }
        returnObject.setPatientIdentifier(pid);
        PatientNameType patientName = new PatientNameType();
        patientName.setFamilyName(returnMessage.getPatientNameFamilyName(patientIndex, 0));
        patientName.setGivenName(returnMessage.getPatientNameGivenName(patientIndex, 0));
        patientName.setOtherName(returnMessage.getPatientNameOtherName(patientIndex, 0));
        patientName.setPrefix(returnMessage.getPatientNamePrefix(patientIndex, 0));
        patientName.setSuffix(returnMessage.getPatientNameSuffix(patientIndex, 0));
        returnObject.setPatientName(patientName);
        AddressType patientAddress = new AddressType();
        String[] patAddr = returnMessage.getPatientAddress(patientIndex, 0);
        patientAddress.setStreetAddress(patAddr[0]);
        patientAddress.setOtherDesignation(patAddr[1]);
        patientAddress.setCity(patAddr[2]);
        patientAddress.setStateOrProvince(patAddr[3]);
        patientAddress.setZipOrPostalCode(patAddr[4]);
        patientAddress.setCountry(patAddr[5]);
        patientAddress.setCountyParishCode(patAddr[8]);
        returnObject.setPatientAddress(patientAddress);
        PhoneType homePhone = new PhoneType();
        PhoneType businessPhone = new PhoneType();
        homePhone.setUnformattedTelephoneNumber(returnMessage.getPatientPhoneHomeUnformattedTelephoneNumber(patientIndex, 0));
        businessPhone.setUnformattedTelephoneNumber(returnMessage.getPatientPhoneBusinessUnformattedTelephoneNumber(patientIndex, 0));
        returnObject.setPatientPhoneHome(homePhone);
        returnObject.setPatientPhoneBusiness(businessPhone);
    }

    private void createPIDTypeFromPixResponse(int patientIndex, int patientIdIndex, PixConsumerResponse returnMessage, PatientInfoType returnObject) throws PixConsumerException {
        PatientIdType pid = new PatientIdType();
        String[] patID = returnMessage.getPatientIdentifier(patientIndex, patientIdIndex);
        pid.setIdNumber(patID[0]);
        pid.getAssigningAuthorityType().setNamespaceId(patID[1]);
        pid.getAssigningAuthorityType().setUniversalId(patID[2]);
        pid.getAssigningAuthorityType().setUniversalIdType(patID[3]);
        returnObject.setPatientIdentifier(pid);
        PatientNameType patientName = new PatientNameType();
        returnObject.setPatientName(patientName);
        PhoneType homePhone = new PhoneType();
        PhoneType businessPhone = new PhoneType();
        returnObject.setPatientPhoneHome(homePhone);
        returnObject.setPatientPhoneBusiness(businessPhone);
    }

    private void populatePdqConsumerQueryFromPatientInfo(PatientInfoType patientInfo, PdqConsumerDemographicQuery message) throws PdqConsumerException, PixPdqMessageException {
        if (patientInfo.getPatientName() != null) {
            if (patientInfo.getPatientName().getFamilyName() != null && !patientInfo.getPatientName().getFamilyName().equals("")) {
                message.addQueryPatientNameFamilyName(patientInfo.getPatientName().getFamilyName());
            }
            if (patientInfo.getPatientName().getGivenName() != null && !patientInfo.getPatientName().getGivenName().equals("")) {
                message.addQueryPatientNameGivenName(patientInfo.getPatientName().getGivenName());
            }
            if (patientInfo.getPatientName().getOtherName() != null && !patientInfo.getPatientName().getOtherName().equals("")) {
                message.addQueryPatientNameOtherName(patientInfo.getPatientName().getOtherName());
            }
            if (patientInfo.getPatientName().getSuffix() != null && !patientInfo.getPatientName().getSuffix().equals("")) {
                message.addQueryPatientNameSuffix(patientInfo.getPatientName().getSuffix());
            }
            if (patientInfo.getPatientName().getPrefix() != null && !patientInfo.getPatientName().getPrefix().equals("")) {
                message.addQueryPatientNamePrefix(patientInfo.getPatientName().getPrefix());
            }
        }
        if (patientInfo.getPatientSex() != null && !patientInfo.getPatientSex().equals("")) {
            message.addQueryPatientSex(patientInfo.getPatientSex());
        }
        if (patientInfo.getPatientDateOfBirth() != null && !patientInfo.getPatientDateOfBirth().equals("")) {
            message.addQueryPatientDateOfBirth(patientInfo.getPatientDateOfBirth());
        }
        if (patientInfo.getPatientAddress() != null) {
            if (patientInfo.getPatientAddress().getStreetAddress() != null && !patientInfo.getPatientAddress().getStreetAddress().equals("") && mLogger.isInfoEnabled()) {
                mLogger.info((Object)"removed StreetAddress search from the query since the IBM server can not do a query with it");
            }
            if (patientInfo.getPatientAddress().getCity() != null && !patientInfo.getPatientAddress().getCity().equals("")) {
                message.addQueryPatientAddressCity(patientInfo.getPatientAddress().getCity());
            }
            if (patientInfo.getPatientAddress().getCountyParishCode() != null && !patientInfo.getPatientAddress().getCountyParishCode().equals("")) {
                message.addQueryPatientAddressCountyParishCode(patientInfo.getPatientAddress().getCountyParishCode());
            }
            if (patientInfo.getPatientAddress().getStateOrProvince() != null && !patientInfo.getPatientAddress().getStateOrProvince().equals("")) {
                message.addQueryPatientAddressStateOrProvince(patientInfo.getPatientAddress().getStateOrProvince());
            }
            if (patientInfo.getPatientAddress().getCountry() != null && !patientInfo.getPatientAddress().getCountry().equals("")) {
                message.addQueryPatientAddressCountry(patientInfo.getPatientAddress().getCountry());
            }
            if (patientInfo.getPatientAddress().getZipOrPostalCode() != null && !patientInfo.getPatientAddress().getZipOrPostalCode().equals("")) {
                message.addQueryPatientAddressZipOrPostalCode(patientInfo.getPatientAddress().getZipOrPostalCode());
            }
            if (patientInfo.getPatientAddress().getOtherDesignation() != null && !patientInfo.getPatientAddress().getOtherDesignation().equals("")) {
                message.addQueryPatientAddressOtherDesignation(patientInfo.getPatientAddress().getOtherDesignation());
            }
        }
        if (patientInfo.getPatientPhoneHome() != null && patientInfo.getPatientPhoneHome().getUnformattedTelephoneNumber() != null && !patientInfo.getPatientPhoneHome().getUnformattedTelephoneNumber().equals("")) {
            message.addQueryPatientPhoneHomeUnformattedTelephoneNumber(patientInfo.getPatientPhoneHome().getUnformattedTelephoneNumber());
        }
        if (patientInfo.getPatientPhoneBusiness() != null && patientInfo.getPatientPhoneBusiness().getUnformattedTelephoneNumber() != null && !patientInfo.getPatientPhoneBusiness().getUnformattedTelephoneNumber().equals("")) {
            message.addQueryPatientPhoneBusinessUnformattedTelephoneNumber(patientInfo.getPatientPhoneBusiness().getUnformattedTelephoneNumber());
        }
        IhePatientConsumerBridge.setFields(message, patientInfo);
    }

    private static void setFields(PdqConsumerDemographicQuery pMessage, PatientInfoType pPatientInfo) throws PdqConsumerException, PixPdqMessageException {
        GenericAdtValue[] values = pPatientInfo.getGenericAdtValues();
        int i = 0;
        while (i < values.length) {
            IhePatientConsumerBridge.setField(pMessage, values[i]);
            ++i;
        }
    }

    private static void setField(PdqConsumerDemographicQuery pMessage, GenericAdtValue value) throws PdqConsumerException, PixPdqMessageException {
        if (Utils.isEmptyOrNull((String)value.getPath()) || Utils.isEmptyOrNull((String)value.getData())) {
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)("Not setting incomplete GenericAdtValue: " + value));
            }
            return;
        }
        String segmentName = value.getPath();
        if (segmentName.equalsIgnoreCase("PID") || segmentName.equalsIgnoreCase("PD1")) {
            pMessage.addOptionalDemographicSearch(value.getPath(), value.getData());
        } else {
            pMessage.setField(value.getPath(), value.getData());
        }
    }
}

