/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe.pixpdq;

import org.apache.log4j.Logger;
import org.eclipse.ohf.bridge.conf.GlobalConfigurations;
import org.eclipse.ohf.bridge.conf.PixPdqResourcesFactory;
import org.eclipse.ohf.bridge.conf.RhioDedicatedResources;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.UnavailableResourcesException;
import org.eclipse.ohf.bridge.conf.rhio.RhioConfig;
import org.eclipse.ohf.bridge.ihe.pixpdq.IhePIXSourceBridge;
import org.eclipse.ohf.bridge.ihe.pixpdq.IhePatientConsumerBridge;
import org.eclipse.ohf.bridge.ihe.pixpdq.PixPdqResources;
import org.eclipse.ohf.bridge.pix.PIXSourceBridge;
import org.eclipse.ohf.bridge.pix.PatientConsumerBridge;

public class IhePixPdqResourcesFactory
implements PixPdqResourcesFactory {
    static final Logger mLogger = Logger.getLogger(IhePixPdqResourcesFactory.class);
    private IhePatientConsumerBridge mConsumerBridge;
    private PIXSourceBridge mPIXSourceBridge;

    public RhioDedicatedResources getRhioDedicatedResources(RhioConfig pConfig, GlobalConfigurations pConfigurations) {
        return new PixPdqResources(pConfig, pConfigurations);
    }

    public static PixPdqResources getResources() throws UnavailableResourcesException {
        return (PixPdqResources)TransactionContext.instant().getPixPdqResources();
    }

    public IhePatientConsumerBridge getPIXBridge() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PDQBridge getPDQBridge() in " + TransactionContext.instant().getSessionContext()));
        }
        if (this.mConsumerBridge == null) {
            this.mConsumerBridge = new IhePatientConsumerBridge();
        }
        return this.mConsumerBridge;
    }

    public PatientConsumerBridge getPatientConsumerBridge() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PDQBridge getPDQBridge() in " + TransactionContext.instant().getSessionContext()));
        }
        if (this.mConsumerBridge == null) {
            this.mConsumerBridge = new IhePatientConsumerBridge();
        }
        return this.mConsumerBridge;
    }

    public PIXSourceBridge getPIXSourceBridge() {
        if (mLogger.isDebugEnabled()) {
            mLogger.debug((Object)("Starting PIXSourceBridge getPIXSourceBridge() in " + TransactionContext.instant().getSessionContext()));
        }
        if (this.mPIXSourceBridge == null) {
            this.mPIXSourceBridge = new IhePIXSourceBridge();
        }
        return this.mPIXSourceBridge;
    }
}

