/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract;

import java.io.IOException;
import java.io.InputStream;
import org.apache.log4j.Logger;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.AssociationType1;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.DocumentRoot;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.ExtrinsicObjectType;
import org.eclipse.ohf.ihe.common.ebxml._2._1.rim.util.RimResourceFactoryImpl;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;

public class EbXML_2_1InputStreamDocumentEntryExtractor
implements DocumentEntryExtractor {
    public static final String DESCRIPTOR = "EBXML_STREAM_DE_EXTR";
    private static final Logger logger;
    private InputStream ebXMLdocumentEntryInputStream;
    static /* synthetic */ Class class$0;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.EbXML_2_1InputStreamDocumentEntryExtractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
    }

    public EbXML_2_1InputStreamDocumentEntryExtractor(InputStream ebXMLdocumentEntryInputStream) {
        this.ebXMLdocumentEntryInputStream = ebXMLdocumentEntryInputStream;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public DocumentEntryType extract() throws MetadataExtractionException {
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading RimPackage.");
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Loading Resources.");
        }
        Resource resource = new RimResourceFactoryImpl().createResource(URI.createURI((String)"urn:oasis:names:tc:ebxml-regrep:rim:xsd:2.1"));
        try {
            resource.load(this.ebXMLdocumentEntryInputStream, null);
        }
        catch (IOException e) {
            logger.error((Object)"IOException while loading Resources from InputStream.", (Throwable)e);
            throw new MetadataExtractionException("IOException while loading Resources from InputStream.", e);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Parsing ebXML InputStream contents.");
        }
        EList list = resource.getContents();
        DocumentRoot root = (DocumentRoot)list.get(0);
        ExtrinsicObjectType docData = null;
        AssociationType1 parentData = null;
        if (root.getExtrinsicObject() != null) {
            docData = root.getExtrinsicObject();
        } else {
            if (root.getLeafRegistryObjectList() == null) {
                logger.error((Object)"Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
                throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
            }
            if (!root.getLeafRegistryObjectList().getExtrinsicObject().isEmpty()) {
                docData = (ExtrinsicObjectType)root.getLeafRegistryObjectList().getExtrinsicObject().get(0);
                if (root.getLeafRegistryObjectList().getAssociation().isEmpty()) {
                    logger.error((Object)"Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
                    throw new MetadataExtractionException("Malformed InputStream: InputStream must contain a single ExtrinsicObject or a single LeafRegistryObjectList containing a single ExtrinsicObject and a Association. Extraction cannot proceed.");
                }
                parentData = (AssociationType1)root.getLeafRegistryObjectList().getAssociation().get(0);
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("Creating DocumentEntry metadata with object from InputStream " + this.ebXMLdocumentEntryInputStream));
        }
        EbXML_2_1DocumentEntryExtractor deExtractor = new EbXML_2_1DocumentEntryExtractor(docData, parentData);
        DocumentEntryType documentEntry = deExtractor.extract();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Unloading Resources.");
        }
        resource.unload();
        return documentEntry;
    }
}

