/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.xds.metadata.extract.cdar2;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.TimeZone;
import org.apache.log4j.Logger;
import org.eclipse.emf.ecore.util.FeatureMap;
import org.eclipse.emf.ecore.xml.type.XMLTypePackage;
import org.eclipse.ohf.ihe.common.cdar2.AD;
import org.eclipse.ohf.ihe.common.cdar2.ADXP;
import org.eclipse.ohf.ihe.common.cdar2.CD;
import org.eclipse.ohf.ihe.common.cdar2.CE;
import org.eclipse.ohf.ihe.common.cdar2.ENXP;
import org.eclipse.ohf.ihe.common.cdar2.II;
import org.eclipse.ohf.ihe.common.cdar2.IVLTS;
import org.eclipse.ohf.ihe.common.cdar2.ON;
import org.eclipse.ohf.ihe.common.cdar2.PN;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedEntity;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget;
import org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent;
import org.eclipse.ohf.ihe.common.cdar2.TEL;
import org.eclipse.ohf.ihe.common.cdar2.TS1;
import org.eclipse.ohf.ihe.common.hl7v2.CX;
import org.eclipse.ohf.ihe.common.hl7v2.Hl7v2Factory;
import org.eclipse.ohf.ihe.common.hl7v2.SourcePatientInfoType;
import org.eclipse.ohf.ihe.common.hl7v2.XAD;
import org.eclipse.ohf.ihe.common.hl7v2.XCN;
import org.eclipse.ohf.ihe.common.hl7v2.XON;
import org.eclipse.ohf.ihe.common.hl7v2.XPN;
import org.eclipse.ohf.ihe.common.hl7v2.XTN;
import org.eclipse.ohf.ihe.xds.metadata.AuthorType;
import org.eclipse.ohf.ihe.xds.metadata.AvailabilityStatusType;
import org.eclipse.ohf.ihe.xds.metadata.CodedMetadataType;
import org.eclipse.ohf.ihe.xds.metadata.DocumentEntryType;
import org.eclipse.ohf.ihe.xds.metadata.ExtensionType;
import org.eclipse.ohf.ihe.xds.metadata.InternationalStringType;
import org.eclipse.ohf.ihe.xds.metadata.LocalizedStringType;
import org.eclipse.ohf.ihe.xds.metadata.MetadataFactory;
import org.eclipse.ohf.ihe.xds.metadata.ParentDocumentType;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryElementExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.DocumentEntryExtractor;
import org.eclipse.ohf.ihe.xds.metadata.extract.MetadataExtractionException;
import org.eclipse.ohf.ihe.xds.metadata.extract.cdar2.AdministrativeGender;
import org.eclipse.ohf.ihe.xds.metadata.impl.MetadataFactoryImpl;

public class CDAR2Extractor
implements DocumentEntryExtractor,
DocumentEntryElementExtractor {
    public static final String DESCRIPTOR = "CDAR2_DE_EXTR";
    private static Logger logger;
    public static final HashMap ADMIN_GENDER_TABLE_001;
    protected POCDMT000040ClinicalDocument cda;
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;
    static /* synthetic */ Class class$2;
    static /* synthetic */ Class class$3;
    static /* synthetic */ Class class$4;
    static /* synthetic */ Class class$5;
    static /* synthetic */ Class class$6;
    static /* synthetic */ Class class$7;
    static /* synthetic */ Class class$8;
    static /* synthetic */ Class class$9;
    static /* synthetic */ Class class$10;
    static /* synthetic */ Class class$11;
    static /* synthetic */ Class class$12;
    static /* synthetic */ Class class$13;
    static /* synthetic */ Class class$14;
    static /* synthetic */ Class class$15;
    static /* synthetic */ Class class$16;

    static {
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ohf.ihe.xds.metadata.extract.cdar2.CDAR2Extractor");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        logger = Logger.getLogger((Class)clazz);
        ADMIN_GENDER_TABLE_001 = new HashMap();
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.M_LITERAL.getName(), "M");
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.F_LITERAL.getName(), "F");
        ADMIN_GENDER_TABLE_001.put(AdministrativeGender.UN_LITERAL.getName(), "O");
    }

    public CDAR2Extractor(POCDMT000040ClinicalDocument cda) {
        this.cda = cda;
    }

    public DocumentEntryType extract() throws MetadataExtractionException {
        String uniqueId;
        CodedMetadataType typeCode;
        InternationalStringType title;
        SourcePatientInfoType patientInfo;
        CX sourcePatientId;
        String stopTime;
        String startTime;
        XCN legalAuth;
        String langCode;
        CodedMetadataType psc;
        CodedMetadataType hcfc;
        String creationTime;
        CodedMetadataType[] confidentialityCodes;
        CodedMetadataType classCode;
        AuthorType author;
        logger.info((Object)"BEGIN CDAR2Extractor.extract()");
        if (this.cda == null) {
            logger.error((Object)"CDA is null, cannot execute extraction.");
            throw new MetadataExtractionException("CDA is null, cannot execute extraction.");
        }
        DocumentEntryType docEntry = MetadataFactoryImpl.eINSTANCE.createDocumentEntryType();
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.author(s)");
        }
        if ((author = this.extractAuthor()) != null) {
            docEntry.setAuthor(author);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.classCode");
        }
        if ((classCode = this.extractClassCode()) != null) {
            docEntry.setClassCode(classCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.confidentialityCode");
        }
        if ((confidentialityCodes = this.extractConfidentialityCodes()) != null) {
            int i = 0;
            while (i < confidentialityCodes.length) {
                docEntry.getConfidentialityCode().add((Object)confidentialityCodes[i]);
                ++i;
            }
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.creationTime");
        }
        if ((creationTime = this.extractCreationTime()) != null) {
            docEntry.setCreationTime(creationTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.healthcareFacilityCode");
        }
        if ((hcfc = this.extractHealthCareFacilityTypeCode()) != null) {
            docEntry.setHealthCareFacilityTypeCode(hcfc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.practiceSettingCode");
        }
        if ((psc = this.extractPracticeSettingCode()) != null) {
            docEntry.setPracticeSettingCode(psc);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.languageCode");
        }
        if ((langCode = this.extractLanguageCode()) != null) {
            docEntry.setLanguageCode(langCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.legalAuthenticator");
        }
        if ((legalAuth = this.extractLegalAuthenticator()) != null) {
            docEntry.setLegalAuthenticator(legalAuth);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.serviceStartTime");
        }
        if ((startTime = this.extractServiceStartTime()) != null) {
            docEntry.setServiceStartTime(startTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.serviceStopTime");
        }
        if ((stopTime = this.extractServiceStopTime()) != null) {
            docEntry.setServiceStopTime(stopTime);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.sourcePatientId");
        }
        if ((sourcePatientId = this.extractSourcePatientId()) != null) {
            docEntry.setSourcePatientId(sourcePatientId);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.sourcePatientInfo");
        }
        if ((patientInfo = this.extractSourcePatientInfo()) != null) {
            docEntry.setSourcePatientInfo(patientInfo);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.title");
        }
        if ((title = this.extractTitle()) != null) {
            docEntry.setTitle(title);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.typeCode");
        }
        if ((typeCode = this.extractTypeCode()) != null) {
            docEntry.setTypeCode(typeCode);
        }
        if (logger.isDebugEnabled()) {
            logger.debug((Object)"Extracting DocumentEntry.uniqueId");
        }
        if ((uniqueId = this.extractUniqueId()) != null) {
            docEntry.setUniqueId(uniqueId);
        }
        logger.info((Object)"DONE");
        return docEntry;
    }

    public AuthorType extractAuthor() {
        if (!this.atLeastOne((List)this.cda.getAuthor())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        Iterator i = this.cda.getAuthor().iterator();
        POCDMT000040Author author = (POCDMT000040Author)i.next();
        AuthorType aut = null;
        POCDMT000040AssignedAuthor aAuth = author.getAssignedAuthor();
        if (aAuth == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz3 = class$2;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/");
                Class<?> clazz4 = class$3;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
        } else if (aAuth.getAssignedAuthoringDevice() == null) {
            String speciality;
            String role;
            XON inst;
            aut = MetadataFactory.eINSTANCE.createAuthorType();
            XCN person = this.extractAuthorPerson(aAuth);
            if (person != null) {
                aut.setAuthorPerson(person);
            }
            if ((inst = this.extractAuthorInstitution(aAuth.getRepresentedOrganization())) != null) {
                aut.getAuthorInstitution().add((Object)inst);
            }
            if ((role = this.extractAuthorRole(author.getFunctionCode())) != null) {
                aut.getAuthorRole().add((Object)role);
            }
            if ((speciality = this.extractAuthorSpeciality(aAuth.getCode())) != null) {
                aut.getAuthorSpeciality().add((Object)speciality);
            }
        }
        return aut;
    }

    public AvailabilityStatusType extractAvailabilityStatus() {
        logger.info((Object)"CDA R2 document header does not contain information corresponding to availablity status metadata.");
        return null;
    }

    public CodedMetadataType extractClassCode() {
        if (this.cda.getCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/code").toString());
            }
            return null;
        }
        if (this.cda.getCode().getCode() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/code@code").toString());
        }
        if (this.cda.getCode().getDisplayName() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/code@displayName").toString());
        }
        if (this.cda.getCode().getCodeSystemName() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/code@codeSchemeName").toString());
        }
        CodedMetadataType code = this.map((CD)this.cda.getCode());
        return code;
    }

    public InternationalStringType extractComments() {
        logger.info((Object)"CDA R2 document header does not contain information corresponding to comments metadata.");
        return null;
    }

    public CodedMetadataType[] extractConfidentialityCodes() {
        if (this.cda.getConfidentialityCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/confidentialityCode").toString());
            }
            return null;
        }
        if (this.cda.getConfidentialityCode().getCode() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/confidentialityCode@code").toString());
        }
        if (this.cda.getConfidentialityCode().getDisplayName() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/confidentialityCode@displayName").toString());
        }
        if (this.cda.getConfidentialityCode().getCodeSystemName() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/confidentialityCode@codeSchemeName").toString());
        }
        CodedMetadataType code = this.map((CD)this.cda.getConfidentialityCode());
        return new CodedMetadataType[]{code};
    }

    public String extractCreationTime() {
        if (this.cda.getEffectiveTime() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/effectiveTime").toString());
            }
            return null;
        }
        if (this.cda.getEffectiveTime().getValue() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/effectiveTime@value").toString());
            }
            return null;
        }
        return this.map(this.cda.getEffectiveTime());
    }

    public String extractEntryUUID() {
        logger.info((Object)"DocumentEntry.entryUUID is an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CodedMetadataType[] extractEventCodes() {
        logger.info((Object)"This extraction routine, at this point,does not attempt to extract event code metadata from a generic CDA R2 document.");
        return null;
    }

    public ExtensionType[] extractExtensions() {
        logger.info((Object)"This extraction routine, at this point,does not attempt to extract extension metadata from a generic CDA R2 document.");
        return null;
    }

    public CodedMetadataType extractFormatCode() {
        logger.info((Object)"DocumentEntry.formatCode is an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractHash() {
        logger.info((Object)"DocumentEntry.hash is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CodedMetadataType extractHealthCareFacilityTypeCode() {
        if (this.cda.getComponentOf() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$4;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$4;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$5;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$4;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$5;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer6.append(clazz6.getName()).append("/ ");
                Class<?> clazz7 = class$6;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer7.append(clazz7.getName()).toString());
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz8 = class$4;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer8.append(clazz8.getName()).append("/ ");
                Class<?> clazz9 = class$5;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$6;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer10.append(clazz10.getName()).append("/ ");
                Class<?> clazz11 = class$7;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer11.append(clazz11.getName()).toString());
            }
        } else if (this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz12 = class$4;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/ ");
                Class<?> clazz13 = class$5;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer14 = stringBuffer13.append(clazz13.getName()).append("/ ");
                Class<?> clazz14 = class$6;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer15 = stringBuffer14.append(clazz14.getName()).append("/ ");
                Class<?> clazz15 = class$7;
                if (clazz15 == null) {
                    try {
                        clazz15 = class$7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer15.append(clazz15.getName()).append("/code").toString());
            }
        } else {
            CE facility = this.cda.getComponentOf().getEncompassingEncounter().getLocation().getHealthCareFacility().getCode();
            if (facility.getCode() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer16 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz16 = class$4;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer17 = stringBuffer16.append(clazz16.getName()).append("/ ");
                Class<?> clazz17 = class$5;
                if (clazz17 == null) {
                    try {
                        clazz17 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer18 = stringBuffer17.append(clazz17.getName()).append("/ ");
                Class<?> clazz18 = class$6;
                if (clazz18 == null) {
                    try {
                        clazz18 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer19 = stringBuffer18.append(clazz18.getName()).append("/ ");
                Class<?> clazz19 = class$7;
                if (clazz19 == null) {
                    try {
                        clazz19 = class$7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer19.append(clazz19.getName()).append("/code@code)").toString());
            }
            if (facility.getDisplayName() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer20 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz20 = class$4;
                if (clazz20 == null) {
                    try {
                        clazz20 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer21 = stringBuffer20.append(clazz20.getName()).append("/ ");
                Class<?> clazz21 = class$5;
                if (clazz21 == null) {
                    try {
                        clazz21 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer22 = stringBuffer21.append(clazz21.getName()).append("/ ");
                Class<?> clazz22 = class$6;
                if (clazz22 == null) {
                    try {
                        clazz22 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer23 = stringBuffer22.append(clazz22.getName()).append("/ ");
                Class<?> clazz23 = class$7;
                if (clazz23 == null) {
                    try {
                        clazz23 = class$7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer23.append(clazz23.getName()).append("/code@displayName)").toString());
            }
            if (facility.getCodeSystemName() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer24 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz24 = class$4;
                if (clazz24 == null) {
                    try {
                        clazz24 = class$4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Component1");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer25 = stringBuffer24.append(clazz24.getName()).append("/ ");
                Class<?> clazz25 = class$5;
                if (clazz25 == null) {
                    try {
                        clazz25 = class$5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040EncompassingEncounter");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer26 = stringBuffer25.append(clazz25.getName()).append("/ ");
                Class<?> clazz26 = class$6;
                if (clazz26 == null) {
                    try {
                        clazz26 = class$6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Location");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer27 = stringBuffer26.append(clazz26.getName()).append("/ ");
                Class<?> clazz27 = class$7;
                if (clazz27 == null) {
                    try {
                        clazz27 = class$7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040HealthCareFacility");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer27.append(clazz27.getName()).append("/code@codeSchemeName)").toString());
            }
            CodedMetadataType code = this.map((CD)facility);
            return code;
        }
        return null;
    }

    public String extractLanguageCode() {
        if (this.cda.getLanguageCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/languageCode").toString());
            }
            return null;
        }
        if (this.cda.getLanguageCode().getCode() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer.append(clazz.getName()).append("/languageCode@code").toString());
        }
        return this.cda.getLanguageCode().getCode();
    }

    public XCN extractLegalAuthenticator() {
        if (this.cda.getLegalAuthenticator() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$8;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        if (this.cda.getLegalAuthenticator().getAssignedEntity() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$8;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$9;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
            return null;
        }
        POCDMT000040AssignedEntity auth = this.cda.getLegalAuthenticator().getAssignedEntity();
        boolean idNull = false;
        if (!this.atLeastOne((List)auth.getId())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$8;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$9;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer6.append(clazz6.getName()).append("/ id").toString());
            }
            idNull = true;
        } else {
            if (((II)auth.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz7 = class$8;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer7.append(clazz7.getName()).append("/ ");
                Class<?> clazz8 = class$9;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer8.append(clazz8.getName()).append("/ id@root").toString());
            }
            if (((II)auth.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz9 = class$8;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$9;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer10.append(clazz10.getName()).append("/ id@extension").toString());
            }
            if (((II)auth.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz11 = class$8;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer11.append(clazz11.getName()).append("/ ");
                Class<?> clazz12 = class$9;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer12.append(clazz12.getName()).append("/ id@assigningAuthorityName").toString());
            }
        }
        if (auth.getAssignedPerson() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz13 = class$8;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer14 = stringBuffer13.append(clazz13.getName()).append("/ ");
                Class<?> clazz14 = class$9;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer15 = stringBuffer14.append(clazz14.getName()).append("/ ");
                Class<?> clazz15 = class$10;
                if (clazz15 == null) {
                    try {
                        clazz15 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer15.append(clazz15.getName()).toString());
            }
            if (idNull) {
                return null;
            }
            return this.map((II)auth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)auth.getAssignedPerson().getName())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer16 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz16 = class$8;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer17 = stringBuffer16.append(clazz16.getName()).append("/ ");
                Class<?> clazz17 = class$9;
                if (clazz17 == null) {
                    try {
                        clazz17 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer18 = stringBuffer17.append(clazz17.getName()).append("/ ");
                Class<?> clazz18 = class$10;
                if (clazz18 == null) {
                    try {
                        clazz18 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer18.append(clazz18.getName()).append("/name ").toString());
            }
            if (idNull) {
                return null;
            }
            return this.map((II)auth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getFamily()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer19 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz19 = class$8;
            if (clazz19 == null) {
                try {
                    clazz19 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer20 = stringBuffer19.append(clazz19.getName()).append("/ ");
            Class<?> clazz20 = class$9;
            if (clazz20 == null) {
                try {
                    clazz20 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer21 = stringBuffer20.append(clazz20.getName()).append("/ ");
            Class<?> clazz21 = class$10;
            if (clazz21 == null) {
                try {
                    clazz21 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer21.append(clazz21.getName()).append("/name/family ").toString());
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getGiven()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer22 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz22 = class$8;
            if (clazz22 == null) {
                try {
                    clazz22 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer23 = stringBuffer22.append(clazz22.getName()).append("/ ");
            Class<?> clazz23 = class$9;
            if (clazz23 == null) {
                try {
                    clazz23 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer24 = stringBuffer23.append(clazz23.getName()).append("/ ");
            Class<?> clazz24 = class$10;
            if (clazz24 == null) {
                try {
                    clazz24 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer24.append(clazz24.getName()).append("/name/given ").toString());
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getPrefix()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer25 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz25 = class$8;
            if (clazz25 == null) {
                try {
                    clazz25 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer26 = stringBuffer25.append(clazz25.getName()).append("/ ");
            Class<?> clazz26 = class$9;
            if (clazz26 == null) {
                try {
                    clazz26 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer27 = stringBuffer26.append(clazz26.getName()).append("/ ");
            Class<?> clazz27 = class$10;
            if (clazz27 == null) {
                try {
                    clazz27 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer27.append(clazz27.getName()).append("/name/prefix ").toString());
        }
        if (!this.atLeastOne((List)((PN)auth.getAssignedPerson().getName().get(0)).getSuffix()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer28 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz28 = class$8;
            if (clazz28 == null) {
                try {
                    clazz28 = class$8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040LegalAuthenticator");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer29 = stringBuffer28.append(clazz28.getName()).append("/ ");
            Class<?> clazz29 = class$9;
            if (clazz29 == null) {
                try {
                    clazz29 = class$9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssociatedEntity");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer30 = stringBuffer29.append(clazz29.getName()).append("/ ");
            Class<?> clazz30 = class$10;
            if (clazz30 == null) {
                try {
                    clazz30 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer30.append(clazz30.getName()).append("/name/suffix ").toString());
        }
        if (idNull) {
            return this.map(null, (PN)auth.getAssignedPerson().getName().get(0));
        }
        return this.map((II)auth.getId().get(0), (PN)auth.getAssignedPerson().getName().get(0));
    }

    public String extractMimeType() {
        logger.info((Object)"DocumentEntry.mimeTypeis an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public ParentDocumentType extractParentDocument() {
        logger.info((Object)"DocumentEntry.parentDocument expresses the id and relationship of a parent document to this CDA document in the XDS Regisry.\nThis is not necessairly the same parent document that is documented within the CDA. \nThus, this information is not extracted.");
        return null;
    }

    public CX extractPatientId() {
        logger.info((Object)"DocumentEntry.patientId expresses the Affinity Domain level patient id used in the XDS Regisry.\nIn all cases, this is not necessairly the same patientId that is documented within the CDA. \nThus, this information is not extracted.");
        return null;
    }

    public CodedMetadataType extractPracticeSettingCode() {
        return this.extractHealthCareFacilityTypeCode();
    }

    public String extractRepositoryUniqueId() {
        logger.info((Object)"DocumentEntry.repositoryUniqueIdis an XDS specific attribute and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractServiceStartTime() {
        if (!this.atLeastOne((List)this.cda.getDocumentationOf())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        Iterator i = this.cda.getDocumentationOf().iterator();
        String minLowTime = null;
        while (i.hasNext()) {
            POCDMT000040DocumentationOf docOf = (POCDMT000040DocumentationOf)i.next();
            POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
            if (sEvent == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$11;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$12;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4).toString());
                continue;
            }
            if (sEvent.getEffectiveTime() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$11;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$12;
                if (clazz6 == null) {
                    try {
                        clazz6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer6.append(clazz6).append("/ effectiveTime").toString());
                continue;
            }
            IVLTS range = sEvent.getEffectiveTime();
            if (range.getLow() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz7 = class$11;
                if (clazz7 == null) {
                    try {
                        clazz7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer7.append(clazz7.getName()).append("/ ");
                Class<?> clazz8 = class$12;
                if (clazz8 == null) {
                    try {
                        clazz8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer8.append(clazz8).append("/ effectiveTime/ low").toString());
                continue;
            }
            if (range.getLow().getValue() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz9 = class$11;
                if (clazz9 == null) {
                    try {
                        clazz9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$12;
                if (clazz10 == null) {
                    try {
                        clazz10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer10.append(clazz10).append("/ effectiveTime/ low@value").toString());
                continue;
            }
            String lowTime = this.map((TS1)range.getLow());
            if (minLowTime == null && lowTime != null) {
                minLowTime = lowTime;
                continue;
            }
            if (minLowTime == null || lowTime == null || lowTime.compareTo(minLowTime) >= 0) continue;
            minLowTime = lowTime;
        }
        return minLowTime;
    }

    public String extractServiceStopTime() {
        if (!this.atLeastOne((List)this.cda.getDocumentationOf())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$11;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$11 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        Iterator i = this.cda.getDocumentationOf().iterator();
        String maxHighTime = null;
        while (i.hasNext()) {
            POCDMT000040DocumentationOf docOf = (POCDMT000040DocumentationOf)i.next();
            POCDMT000040ServiceEvent sEvent = docOf.getServiceEvent();
            if (sEvent == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$11;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$12;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4).toString());
                continue;
            }
            if (sEvent.getEffectiveTime() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$11;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$12;
                if (clazz6 == null) {
                    try {
                        clazz6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer6.append(clazz6).append("/ effectiveTime").toString());
                continue;
            }
            IVLTS range = sEvent.getEffectiveTime();
            if (range.getHigh() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz7 = class$11;
                if (clazz7 == null) {
                    try {
                        clazz7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer7.append(clazz7.getName()).append("/ ");
                Class<?> clazz8 = class$12;
                if (clazz8 == null) {
                    try {
                        clazz8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer8.append(clazz8).append("/ effectiveTime/ high").toString());
                continue;
            }
            if (range.getHigh().getValue() == null) {
                if (!logger.isDebugEnabled()) continue;
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz9 = class$11;
                if (clazz9 == null) {
                    try {
                        clazz9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040DocumentationOf");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$12;
                if (clazz10 == null) {
                    try {
                        clazz10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ServiceEvent");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer10.append(clazz10).append("/ effectiveTime/ high@value").toString());
                continue;
            }
            String highTime = this.map((TS1)range.getHigh());
            if (maxHighTime == null && highTime != null) {
                maxHighTime = highTime;
                continue;
            }
            if (maxHighTime == null || highTime == null || highTime.compareTo(maxHighTime) <= 0) continue;
            maxHighTime = highTime;
        }
        return maxHighTime;
    }

    public String extractSize() {
        logger.info((Object)"DocumentEntry.size is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public CX extractSourcePatientId() {
        if (!this.atLeastOne((List)this.cda.getRecordTarget())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        POCDMT000040RecordTarget target = (POCDMT000040RecordTarget)this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$13;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$14;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        if (!this.atLeastOne((List)patient.getId())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$13;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$14;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer6.append(clazz6.getName()).append("/ id").toString());
            }
            return null;
        }
        II pId = (II)patient.getId().get(0);
        if (pId.getExtension() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer7 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz7 = class$13;
            if (clazz7 == null) {
                try {
                    clazz7 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer8 = stringBuffer7.append(clazz7.getName()).append("/ ");
            Class<?> clazz8 = class$14;
            if (clazz8 == null) {
                try {
                    clazz8 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer8.append(clazz8.getName()).append("/ id@extension").toString());
        }
        if (pId.getRoot() == null && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer9 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz9 = class$13;
            if (clazz9 == null) {
                try {
                    clazz9 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
            Class<?> clazz10 = class$14;
            if (clazz10 == null) {
                try {
                    clazz10 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer10.append(clazz10.getName()).append("/ id@root").toString());
        }
        return this.map(pId);
    }

    public SourcePatientInfoType extractSourcePatientInfo() {
        if (!this.atLeastOne((List)this.cda.getRecordTarget())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).toString());
            }
            return null;
        }
        POCDMT000040RecordTarget target = (POCDMT000040RecordTarget)this.cda.getRecordTarget().get(0);
        if (target.getPatientRole() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz3 = class$13;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$14;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
            return null;
        }
        POCDMT000040PatientRole patient = target.getPatientRole();
        SourcePatientInfoType sourceInfo = Hl7v2Factory.eINSTANCE.createSourcePatientInfoType();
        if (!this.atLeastOne((List)patient.getId())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz5 = class$13;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/ ");
                Class<?> clazz6 = class$14;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer6.append(clazz6.getName()).append("/ id").toString());
            }
        } else {
            sourceInfo.getPatientIdentifier().addAll((Collection)this.extractPid3((List)patient.getId()));
        }
        if (!this.atLeastOne((List)patient.getAddr())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz7 = class$13;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer7.append(clazz7.getName()).append("/ ");
                Class<?> clazz8 = class$14;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer8.append(clazz8.getName()).append("/ addr").toString());
            }
        } else {
            sourceInfo.setPatientAddress(this.extractPid11((AD)patient.getAddr().get(0)));
        }
        if (!this.atLeastOne((List)patient.getTelecom()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer9 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz9 = class$13;
            if (clazz9 == null) {
                try {
                    clazz9 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
            Class<?> clazz10 = class$14;
            if (clazz10 == null) {
                try {
                    clazz10 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer10.append(clazz10.getName()).append("/ telecom").toString());
        }
        if (patient.getPatient() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz11 = class$13;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer11.append(clazz11.getName()).append("/ ");
                Class<?> clazz12 = class$14;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/ ");
                Class<?> clazz13 = class$15;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$15 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer13.append(clazz13.getName()).toString());
            }
        } else {
            POCDMT000040Patient p = patient.getPatient();
            if (p.getId() == null) {
                if (logger.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer14 = stringBuffer.append(clazz.getName()).append("/ ");
                    Class<?> clazz14 = class$13;
                    if (clazz14 == null) {
                        try {
                            clazz14 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer15 = stringBuffer14.append(clazz14.getName()).append("/ ");
                    Class<?> clazz15 = class$14;
                    if (clazz15 == null) {
                        try {
                            clazz15 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer16 = stringBuffer15.append(clazz15.getName()).append("/ ");
                    Class<?> clazz16 = class$15;
                    if (clazz16 == null) {
                        try {
                            clazz16 = class$15 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    logger.debug((Object)stringBuffer16.append(clazz16.getName()).append("/ id").toString());
                }
            } else {
                ArrayList<II> l = new ArrayList<II>();
                l.add(p.getId());
                sourceInfo.getPatientIdentifier().addAll((Collection)this.extractPid3(l));
            }
            if (!this.atLeastOne((List)p.getName())) {
                if (logger.isDebugEnabled()) {
                    StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                    Class<?> clazz = class$1;
                    if (clazz == null) {
                        try {
                            clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer17 = stringBuffer.append(clazz.getName()).append("/ ");
                    Class<?> clazz17 = class$13;
                    if (clazz17 == null) {
                        try {
                            clazz17 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer18 = stringBuffer17.append(clazz17.getName()).append("/ ");
                    Class<?> clazz18 = class$14;
                    if (clazz18 == null) {
                        try {
                            clazz18 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    StringBuffer stringBuffer19 = stringBuffer18.append(clazz18.getName()).append("/ ");
                    Class<?> clazz19 = class$15;
                    if (clazz19 == null) {
                        try {
                            clazz19 = class$15 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                        }
                        catch (ClassNotFoundException classNotFoundException) {
                            throw new NoClassDefFoundError(classNotFoundException.getMessage());
                        }
                    }
                    logger.debug((Object)stringBuffer19.append(clazz19.getName()).append("/ name").toString());
                }
            } else {
                sourceInfo.getPatientName().addAll((Collection)this.extractPid5((List)p.getName()));
            }
            sourceInfo.setPatientDateOfBirth(this.extractPid7(p.getBirthTime()));
            sourceInfo.setPatientSex(this.extractPid8(p.getAdministrativeGenderCode()));
        }
        return sourceInfo;
    }

    public InternationalStringType extractTitle() {
        if (this.cda.getTitle() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/title").toString());
            }
            return null;
        }
        LocalizedStringType dName = MetadataFactory.eINSTANCE.createLocalizedStringType();
        String txt = this.processMixed(this.cda.getTitle().getMixed());
        if (txt.length() <= 0) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata value: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/title").toString());
            }
            return null;
        }
        dName.setValue(txt);
        InternationalStringType display = MetadataFactory.eINSTANCE.createInternationalStringType();
        display.getLocalizedString().add((Object)dName);
        return display;
    }

    public CodedMetadataType extractTypeCode() {
        return this.extractClassCode();
    }

    public String extractURI() {
        logger.info((Object)"DocumentEntry.URI is a comptuted value and outside the scope of any CDA R2 document. \nThus, it cannot be extracted.");
        return null;
    }

    public String extractUniqueId() {
        if (this.cda.getId() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/id").toString());
            }
            return null;
        }
        if (this.cda.getId().getRoot() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/id@root").toString());
            }
            return null;
        }
        if (this.cda.getId().getExtension() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer.append(clazz.getName()).append("/id@extension").toString());
            }
            return this.cda.getId().getRoot();
        }
        return String.valueOf(this.cda.getId().getRoot()) + "^" + this.cda.getId().getExtension();
    }

    private XON extractAuthorInstitution(POCDMT000040Organization org) {
        if (org == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/");
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$16;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).toString());
            }
            return null;
        }
        boolean idNull = false;
        if (!this.atLeastOne((List)org.getId())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz5 = class$2;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/");
                Class<?> clazz6 = class$3;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer6.append(clazz6.getName()).append("/ ");
                Class<?> clazz7 = class$16;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer7.append(clazz7.getName()).append("/ id").toString());
            }
            idNull = true;
        } else {
            if (((II)org.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz8 = class$2;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer8.append(clazz8.getName()).append("/");
                Class<?> clazz9 = class$3;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$16;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer10.append(clazz10.getName()).append("/ id@root").toString());
            }
            if (((II)org.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz11 = class$2;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer11.append(clazz11.getName()).append("/");
                Class<?> clazz12 = class$3;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/ ");
                Class<?> clazz13 = class$16;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer13.append(clazz13.getName()).append("/ id@extension").toString());
            }
            if (((II)org.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer14 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz14 = class$2;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer15 = stringBuffer14.append(clazz14.getName()).append("/");
                Class<?> clazz15 = class$3;
                if (clazz15 == null) {
                    try {
                        clazz15 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer16 = stringBuffer15.append(clazz15.getName()).append("/ ");
                Class<?> clazz16 = class$16;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer16.append(clazz16.getName()).append("/ id@assigningAuthorityName").toString());
            }
        }
        if (!this.atLeastOne((List)org.getName())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer17 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz17 = class$2;
                if (clazz17 == null) {
                    try {
                        clazz17 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer18 = stringBuffer17.append(clazz17.getName()).append("/");
                Class<?> clazz18 = class$3;
                if (clazz18 == null) {
                    try {
                        clazz18 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer19 = stringBuffer18.append(clazz18.getName()).append("/ ");
                Class<?> clazz19 = class$16;
                if (clazz19 == null) {
                    try {
                        clazz19 = class$16 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Organization");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer19.append(clazz19.getName()).append("/ name").toString());
            }
            if (idNull) {
                return null;
            }
            return this.map(null, (II)org.getId().get(0));
        }
        if (idNull) {
            return this.map((ON)org.getName().get(0), null);
        }
        return this.map((ON)org.getName().get(0), (II)org.getId().get(0));
    }

    private XCN extractAuthorPerson(POCDMT000040AssignedAuthor aAuth) {
        if (aAuth == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/");
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer3.append(clazz3.getName()).toString());
            }
            return null;
        }
        boolean idNull = false;
        if (!this.atLeastOne((List)aAuth.getId())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz4 = class$2;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer4.append(clazz4.getName()).append("/");
                Class<?> clazz5 = class$3;
                if (clazz5 == null) {
                    try {
                        clazz5 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer5.append(clazz5.getName()).append("/ id").toString());
            }
            idNull = true;
        } else {
            if (((II)aAuth.getId().get(0)).getRoot() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz6 = class$2;
                if (clazz6 == null) {
                    try {
                        clazz6 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer6.append(clazz6.getName()).append("/");
                Class<?> clazz7 = class$3;
                if (clazz7 == null) {
                    try {
                        clazz7 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer7.append(clazz7.getName()).append("/ id@root").toString());
            }
            if (((II)aAuth.getId().get(0)).getExtension() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz8 = class$2;
                if (clazz8 == null) {
                    try {
                        clazz8 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer8.append(clazz8.getName()).append("/");
                Class<?> clazz9 = class$3;
                if (clazz9 == null) {
                    try {
                        clazz9 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer9.append(clazz9.getName()).append("/ id@extension").toString());
            }
            if (((II)aAuth.getId().get(0)).getAssigningAuthorityName() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz10 = class$2;
                if (clazz10 == null) {
                    try {
                        clazz10 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer10.append(clazz10.getName()).append("/");
                Class<?> clazz11 = class$3;
                if (clazz11 == null) {
                    try {
                        clazz11 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer11.append(clazz11.getName()).append("/ id@assigningAuthorityName").toString());
            }
        }
        if (aAuth.getAssignedPerson() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz12 = class$2;
                if (clazz12 == null) {
                    try {
                        clazz12 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/");
                Class<?> clazz13 = class$3;
                if (clazz13 == null) {
                    try {
                        clazz13 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer14 = stringBuffer13.append(clazz13.getName()).append("/ ");
                Class<?> clazz14 = class$10;
                if (clazz14 == null) {
                    try {
                        clazz14 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer14.append(clazz14.getName()).toString());
            }
            if (idNull) {
                return null;
            }
            return this.map((II)aAuth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)aAuth.getAssignedPerson().getName())) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer15 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz15 = class$2;
                if (clazz15 == null) {
                    try {
                        clazz15 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer16 = stringBuffer15.append(clazz15.getName()).append("/");
                Class<?> clazz16 = class$3;
                if (clazz16 == null) {
                    try {
                        clazz16 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer17 = stringBuffer16.append(clazz16.getName()).append("/ ");
                Class<?> clazz17 = class$10;
                if (clazz17 == null) {
                    try {
                        clazz17 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer17.append(clazz17.getName()).append("/name ").toString());
            }
            if (idNull) {
                return null;
            }
            return this.map((II)aAuth.getId().get(0), null);
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getFamily()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer18 = stringBuffer.append(clazz.getName()).append("/");
            Class<?> clazz18 = class$2;
            if (clazz18 == null) {
                try {
                    clazz18 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer19 = stringBuffer18.append(clazz18.getName()).append("/");
            Class<?> clazz19 = class$3;
            if (clazz19 == null) {
                try {
                    clazz19 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer20 = stringBuffer19.append(clazz19.getName()).append("/ ");
            Class<?> clazz20 = class$10;
            if (clazz20 == null) {
                try {
                    clazz20 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer20.append(clazz20.getName()).append("/name/family ").toString());
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getGiven()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer21 = stringBuffer.append(clazz.getName()).append("/");
            Class<?> clazz21 = class$2;
            if (clazz21 == null) {
                try {
                    clazz21 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer22 = stringBuffer21.append(clazz21.getName()).append("/");
            Class<?> clazz22 = class$3;
            if (clazz22 == null) {
                try {
                    clazz22 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer23 = stringBuffer22.append(clazz22.getName()).append("/ ");
            Class<?> clazz23 = class$10;
            if (clazz23 == null) {
                try {
                    clazz23 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer23.append(clazz23.getName()).append("/name/given ").toString());
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getPrefix()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer24 = stringBuffer.append(clazz.getName()).append("/");
            Class<?> clazz24 = class$2;
            if (clazz24 == null) {
                try {
                    clazz24 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer25 = stringBuffer24.append(clazz24.getName()).append("/");
            Class<?> clazz25 = class$3;
            if (clazz25 == null) {
                try {
                    clazz25 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer26 = stringBuffer25.append(clazz25.getName()).append("/ ");
            Class<?> clazz26 = class$10;
            if (clazz26 == null) {
                try {
                    clazz26 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer26.append(clazz26.getName()).append("/name/prefix ").toString());
        }
        if (!this.atLeastOne((List)((PN)aAuth.getAssignedPerson().getName().get(0)).getSuffix()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer27 = stringBuffer.append(clazz.getName()).append("/");
            Class<?> clazz27 = class$2;
            if (clazz27 == null) {
                try {
                    clazz27 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer28 = stringBuffer27.append(clazz27.getName()).append("/");
            Class<?> clazz28 = class$3;
            if (clazz28 == null) {
                try {
                    clazz28 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer29 = stringBuffer28.append(clazz28.getName()).append("/ ");
            Class<?> clazz29 = class$10;
            if (clazz29 == null) {
                try {
                    clazz29 = class$10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Person");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer29.append(clazz29.getName()).append("/name/suffix ").toString());
        }
        if (idNull) {
            return this.map(null, (PN)aAuth.getAssignedPerson().getName().get(0));
        }
        return this.map((II)aAuth.getId().get(0), (PN)aAuth.getAssignedPerson().getName().get(0));
    }

    private String extractAuthorRole(CE role) {
        if (role == null) {
            return null;
        }
        if (role.getCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer2.append(clazz2.getName()).append("/ functionCode").toString());
            }
            return null;
        }
        return role.getCode();
    }

    private String extractAuthorSpeciality(CE spec) {
        if (spec == null) {
            return null;
        }
        if (spec.getCode() == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$2;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Author");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/");
                Class<?> clazz3 = class$3;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040AssignedAuthor");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer3.append(clazz3.getName()).append("/code").toString());
            }
            return null;
        }
        return spec.getCode();
    }

    private List extractPid3(List idList) {
        Iterator i = idList.iterator();
        ArrayList<CX> ids = new ArrayList<CX>();
        while (i.hasNext()) {
            CX cx;
            II pId = (II)i.next();
            if (pId.getExtension() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/ ");
                Class<?> clazz3 = class$14;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer3.append(clazz3.getName()).append("/ id@extension").toString());
            }
            if (pId.getRoot() == null && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz4 = class$13;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer4.append(clazz4.getName()).append("/ ");
                Class<?> clazz5 = class$14;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer5.append(clazz5.getName()).append("/ id@root").toString());
            }
            if ((cx = this.map(pId)) == null) continue;
            ids.add(cx);
        }
        return ids;
    }

    private List extractPid5(List nameList) {
        Iterator i = nameList.iterator();
        ArrayList<XPN> names = new ArrayList<XPN>();
        while (i.hasNext()) {
            PN name = (PN)i.next();
            if (!this.atLeastOne((List)name.getFamily()) && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/");
                Class<?> clazz3 = class$14;
                if (clazz3 == null) {
                    try {
                        clazz3 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$15;
                if (clazz4 == null) {
                    try {
                        clazz4 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).append("/name/family ").toString());
            }
            if (!this.atLeastOne((List)name.getGiven()) && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer5 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz5 = class$13;
                if (clazz5 == null) {
                    try {
                        clazz5 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer6 = stringBuffer5.append(clazz5.getName()).append("/");
                Class<?> clazz6 = class$14;
                if (clazz6 == null) {
                    try {
                        clazz6 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer7 = stringBuffer6.append(clazz6.getName()).append("/ ");
                Class<?> clazz7 = class$15;
                if (clazz7 == null) {
                    try {
                        clazz7 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer7.append(clazz7.getName()).append("/name/given ").toString());
            }
            if (!this.atLeastOne((List)name.getPrefix()) && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz8 = class$13;
                if (clazz8 == null) {
                    try {
                        clazz8 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer9 = stringBuffer8.append(clazz8.getName()).append("/");
                Class<?> clazz9 = class$14;
                if (clazz9 == null) {
                    try {
                        clazz9 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer10 = stringBuffer9.append(clazz9.getName()).append("/ ");
                Class<?> clazz10 = class$15;
                if (clazz10 == null) {
                    try {
                        clazz10 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer10.append(clazz10.getName()).append("/name/prefix ").toString());
            }
            if (!this.atLeastOne((List)name.getSuffix()) && logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer11 = stringBuffer.append(clazz.getName()).append("/");
                Class<?> clazz11 = class$13;
                if (clazz11 == null) {
                    try {
                        clazz11 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer12 = stringBuffer11.append(clazz11.getName()).append("/");
                Class<?> clazz12 = class$14;
                if (clazz12 == null) {
                    try {
                        clazz12 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/ ");
                Class<?> clazz13 = class$15;
                if (clazz13 == null) {
                    try {
                        clazz13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer13.append(clazz13.getName()).append("/name/suffix ").toString());
            }
            XPN xpn = this.map(name);
            names.add(xpn);
        }
        return names;
    }

    private String extractPid7(TS1 time) {
        if (time == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/ ");
                Class<?> clazz3 = class$14;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$15;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$15 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).append("/ birthTime").toString());
            }
            return null;
        }
        return this.map(time);
    }

    private String extractPid8(CE docCode) {
        if (docCode == null) {
            if (logger.isDebugEnabled()) {
                StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
                Class<?> clazz = class$1;
                if (clazz == null) {
                    try {
                        clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
                Class<?> clazz2 = class$13;
                if (clazz2 == null) {
                    try {
                        clazz2 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/ ");
                Class<?> clazz3 = class$14;
                if (clazz3 == null) {
                    try {
                        clazz3 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                StringBuffer stringBuffer4 = stringBuffer3.append(clazz3.getName()).append("/ ");
                Class<?> clazz4 = class$15;
                if (clazz4 == null) {
                    try {
                        clazz4 = class$15 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040Patient");
                    }
                    catch (ClassNotFoundException classNotFoundException) {
                        throw new NoClassDefFoundError(classNotFoundException.getMessage());
                    }
                }
                logger.debug((Object)stringBuffer4.append(clazz4.getName()).append("/ administrativeGenderCode").toString());
            }
            return null;
        }
        String gender = docCode.getCode();
        String value = (String)ADMIN_GENDER_TABLE_001.get(gender);
        if (value == null && gender != null) {
            logger.warn((Object)("Vocabulary value not found: " + gender));
        }
        return value;
    }

    private XAD extractPid11(AD addr) {
        if (!this.atLeastOne((List)addr.getStreetAddressLine()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer2 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz2 = class$13;
            if (clazz2 == null) {
                try {
                    clazz2 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer3 = stringBuffer2.append(clazz2.getName()).append("/ ");
            Class<?> clazz3 = class$14;
            if (clazz3 == null) {
                try {
                    clazz3 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer3.append(clazz3.getName()).append("/ addr/streetAddressLine ").toString());
        }
        if (!this.atLeastOne((List)addr.getAdditionalLocator()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer4 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz4 = class$13;
            if (clazz4 == null) {
                try {
                    clazz4 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer5 = stringBuffer4.append(clazz4.getName()).append("/ ");
            Class<?> clazz5 = class$14;
            if (clazz5 == null) {
                try {
                    clazz5 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer5.append(clazz5.getName()).append("/ addr/additionalLocator").toString());
        }
        if (!this.atLeastOne((List)addr.getCity()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer6 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz6 = class$13;
            if (clazz6 == null) {
                try {
                    clazz6 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer7 = stringBuffer6.append(clazz6.getName()).append("/ ");
            Class<?> clazz7 = class$14;
            if (clazz7 == null) {
                try {
                    clazz7 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer7.append(clazz7.getName()).append("/ addr/city").toString());
        }
        if (!this.atLeastOne((List)addr.getState()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer8 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz8 = class$13;
            if (clazz8 == null) {
                try {
                    clazz8 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer9 = stringBuffer8.append(clazz8.getName()).append("/ ");
            Class<?> clazz9 = class$14;
            if (clazz9 == null) {
                try {
                    clazz9 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer9.append(clazz9.getName()).append("/ addr/state ").toString());
        }
        if (!this.atLeastOne((List)addr.getPostalCode()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer10 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz10 = class$13;
            if (clazz10 == null) {
                try {
                    clazz10 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer11 = stringBuffer10.append(clazz10.getName()).append("/ ");
            Class<?> clazz11 = class$14;
            if (clazz11 == null) {
                try {
                    clazz11 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer11.append(clazz11.getName()).append("/ addr/postalCode ").toString());
        }
        if (!this.atLeastOne((List)addr.getCountry()) && logger.isDebugEnabled()) {
            StringBuffer stringBuffer = new StringBuffer("Missing metadata source: ");
            Class<?> clazz = class$1;
            if (clazz == null) {
                try {
                    clazz = class$1 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040ClinicalDocument");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer12 = stringBuffer.append(clazz.getName()).append("/ ");
            Class<?> clazz12 = class$13;
            if (clazz12 == null) {
                try {
                    clazz12 = class$13 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040RecordTarget");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            StringBuffer stringBuffer13 = stringBuffer12.append(clazz12.getName()).append("/ ");
            Class<?> clazz13 = class$14;
            if (clazz13 == null) {
                try {
                    clazz13 = class$14 = Class.forName("org.eclipse.ohf.ihe.common.cdar2.POCDMT000040PatientRole");
                }
                catch (ClassNotFoundException classNotFoundException) {
                    throw new NoClassDefFoundError(classNotFoundException.getMessage());
                }
            }
            logger.debug((Object)stringBuffer13.append(clazz13.getName()).append("/ addr/country").toString());
        }
        return this.map(addr);
    }

    protected String processMixed(FeatureMap m) {
        StringBuffer txt = new StringBuffer("");
        int i = 0;
        while (i < m.size()) {
            FeatureMap.Entry entry = (FeatureMap.Entry)m.get(i);
            if (entry.getEStructuralFeature() == XMLTypePackage.eINSTANCE.getXMLTypeDocumentRoot_Text()) {
                txt.append((String)entry.getValue());
            }
            ++i;
        }
        return txt.toString();
    }

    protected boolean atLeastOne(List l) {
        if (l == null) {
            return false;
        }
        if (l.size() < 1) {
            return false;
        }
        return l.get(0) != null;
    }

    protected CodedMetadataType map(CD docCode) {
        if (docCode == null) {
            return null;
        }
        CodedMetadataType code = MetadataFactoryImpl.eINSTANCE.createCodedMetadataType();
        code.setCode(docCode.getCode());
        if (docCode.getDisplayName() != null) {
            LocalizedStringType dName = MetadataFactory.eINSTANCE.createLocalizedStringType();
            dName.setValue(docCode.getDisplayName());
            InternationalStringType display = MetadataFactory.eINSTANCE.createInternationalStringType();
            display.getLocalizedString().add((Object)dName);
            code.setDisplayName(display);
        }
        if (docCode.getCodeSystemName() != null) {
            code.setSchemeName(docCode.getCodeSystemName());
        }
        return code;
    }

    protected CX map(II id) {
        if (id == null) {
            return null;
        }
        CX cx = Hl7v2Factory.eINSTANCE.createCX();
        cx.setIdNumber(id.getExtension());
        cx.setAssigningAuthorityUniversalId(id.getRoot());
        cx.setAssigningAuthorityUniversalIdType("ISO");
        return cx;
    }

    protected XTN map(TEL tel) {
        if (tel == null) {
            return null;
        }
        XTN xtn = Hl7v2Factory.eINSTANCE.createXTN();
        xtn.setUnformattedTelephoneNumber(tel.getValue());
        return xtn;
    }

    protected String map(TS1 time) {
        if (time == null) {
            return null;
        }
        if (time.getValue() == null) {
            return null;
        }
        String tm = time.getValue();
        String offset = "";
        if (tm.length() > "-ZZZZ".length()) {
            if (tm.charAt(tm.length() - "-ZZZZ".length()) == '-') {
                offset = tm.substring(tm.length() - "-ZZZZ".length());
            } else if (tm.charAt(tm.length() - "-ZZZZ".length()) == '+') {
                offset = tm.substring(tm.length() - "+ZZZZ".length());
            }
        }
        if (tm.length() > "YYYYMMDDHHMMSS".length()) {
            tm = tm.substring(0, "YYYYMMDDHHMMSS".length());
        }
        if (tm.length() > "YYYYMMDDHH".length() && offset.length() > 0) {
            SimpleDateFormat sdf = new SimpleDateFormat("yyyyMMddHHmmss");
            sdf.setTimeZone(TimeZone.getTimeZone("GMT" + offset));
            try {
                Date specifiedTime = sdf.parse(tm);
                sdf.setTimeZone(TimeZone.getTimeZone("GMT"));
                tm = sdf.format(specifiedTime);
            }
            catch (ParseException parseException) {}
        }
        return tm;
    }

    protected XPN map(PN name) {
        ENXP prefix;
        ENXP suffix;
        ENXP family;
        String txt;
        if (name == null) {
            return null;
        }
        XPN xpn = Hl7v2Factory.eINSTANCE.createXPN();
        if (this.atLeastOne((List)name.getFamily()) && (txt = this.processMixed((family = (ENXP)name.getFamily().get(0)).getMixed())).length() > 0) {
            xpn.setFamilyName(txt);
        }
        if (this.atLeastOne((List)name.getGiven())) {
            ENXP given = (ENXP)name.getGiven().get(0);
            txt = this.processMixed(given.getMixed());
            if (txt.length() > 0) {
                xpn.setGivenName(txt);
            }
            if (name.getGiven().size() > 1 && name.getGiven().get(1) != null) {
                ENXP cfr_ignored_0 = (ENXP)name.getGiven().get(1);
                txt = this.processMixed(given.getMixed());
                if (txt.length() > 0) {
                    xpn.setOtherName(txt);
                }
            }
        }
        if (this.atLeastOne((List)name.getSuffix()) && (txt = this.processMixed((suffix = (ENXP)name.getSuffix().get(0)).getMixed())).length() > 0) {
            xpn.setSuffix(txt);
        }
        if (this.atLeastOne((List)name.getPrefix()) && (txt = this.processMixed((prefix = (ENXP)name.getPrefix().get(0)).getMixed())).length() > 0) {
            xpn.setPrefix(txt);
        }
        return xpn;
    }

    protected XCN map(II id, PN name) {
        XCN xcn = Hl7v2Factory.eINSTANCE.createXCN();
        boolean idNull = true;
        boolean nameNull = true;
        if (id != null) {
            xcn.setIdNumber(id.getExtension());
            xcn.setAssigningAuthorityName(id.getAssigningAuthorityName());
            xcn.setAssigningAuthorityUniversalId(id.getRoot());
            xcn.setAssigningAuthorityUniversalIdType("ISO");
            idNull = false;
        }
        if (name != null) {
            ENXP prefix;
            ENXP suffix;
            ENXP family;
            String txt;
            if (this.atLeastOne((List)name.getFamily()) && (txt = this.processMixed((family = (ENXP)name.getFamily().get(0)).getMixed())).length() > 0) {
                xcn.setFamilyName(txt);
            }
            if (this.atLeastOne((List)name.getGiven())) {
                ENXP given = (ENXP)name.getGiven().get(0);
                txt = this.processMixed(given.getMixed());
                if (txt.length() > 0) {
                    xcn.setGivenName(txt);
                }
                if (name.getGiven().size() > 1 && name.getGiven().get(1) != null) {
                    ENXP cfr_ignored_0 = (ENXP)name.getGiven().get(1);
                    txt = this.processMixed(given.getMixed());
                    if (txt.length() > 0) {
                        xcn.setOtherName(txt);
                    }
                }
            }
            if (this.atLeastOne((List)name.getSuffix()) && (txt = this.processMixed((suffix = (ENXP)name.getSuffix().get(0)).getMixed())).length() > 0) {
                xcn.setSuffix(txt);
            }
            if (this.atLeastOne((List)name.getPrefix()) && (txt = this.processMixed((prefix = (ENXP)name.getPrefix().get(0)).getMixed())).length() > 0) {
                xcn.setPrefix(txt);
            }
        }
        if (idNull && nameNull) {
            return null;
        }
        return xcn;
    }

    protected XON map(ON name, II id) {
        String txt;
        XON xon = Hl7v2Factory.eINSTANCE.createXON();
        if (id != null) {
            xon.setIdNumber(id.getExtension());
            xon.setAssigningAuthorityName(id.getAssigningAuthorityName());
            xon.setAssigningAuthorityUniversalId(id.getRoot());
            xon.setAssigningAuthorityUniversalIdType("ISO");
        }
        if (name != null && (txt = this.processMixed(name.getMixed())).length() > 0) {
            xon.setOrganizationName(txt);
        }
        return xon;
    }

    protected XAD map(AD addr) {
        ADXP stl;
        String txt;
        if (addr == null) {
            return null;
        }
        XAD xad = Hl7v2Factory.eINSTANCE.createXAD();
        if (this.atLeastOne((List)addr.getStreetAddressLine()) && (txt = this.processMixed((stl = (ADXP)addr.getStreetAddressLine().get(0)).getMixed())).length() > 0) {
            xad.setStreetAddress(txt);
        }
        if (this.atLeastOne((List)addr.getAdditionalLocator()) && (txt = this.processMixed((stl = (ADXP)addr.getAdditionalLocator().get(0)).getMixed())).length() > 0) {
            xad.setOtherDesignation(txt);
        }
        if (this.atLeastOne((List)addr.getCity()) && (txt = this.processMixed((stl = (ADXP)addr.getCity().get(0)).getMixed())).length() > 0) {
            xad.setCity(txt);
        }
        if (this.atLeastOne((List)addr.getState()) && (txt = this.processMixed((stl = (ADXP)addr.getState().get(0)).getMixed())).length() > 0) {
            xad.setStateOrProvince(txt);
        }
        if (this.atLeastOne((List)addr.getPostalCode()) && (txt = this.processMixed((stl = (ADXP)addr.getPostalCode().get(0)).getMixed())).length() > 0) {
            xad.setZipOrPostalCode(txt);
        }
        if (this.atLeastOne((List)addr.getCountry()) && (txt = this.processMixed((stl = (ADXP)addr.getCountry().get(0)).getMixed())).length() > 0) {
            xad.setCountry(txt);
        }
        return xad;
    }
}

