/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.ihe.common.cdar2;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.eclipse.emf.common.util.AbstractEnumerator;

public final class ScopeType
extends AbstractEnumerator {
    public static final int ROW = 0;
    public static final int COL = 1;
    public static final int ROWGROUP = 2;
    public static final int COLGROUP = 3;
    public static final ScopeType ROW_LITERAL = new ScopeType(0, "row", "row");
    public static final ScopeType COL_LITERAL = new ScopeType(1, "col", "col");
    public static final ScopeType ROWGROUP_LITERAL = new ScopeType(2, "rowgroup", "rowgroup");
    public static final ScopeType COLGROUP_LITERAL = new ScopeType(3, "colgroup", "colgroup");
    private static final ScopeType[] VALUES_ARRAY = new ScopeType[]{ROW_LITERAL, COL_LITERAL, ROWGROUP_LITERAL, COLGROUP_LITERAL};
    public static final List VALUES = Collections.unmodifiableList(Arrays.asList(VALUES_ARRAY));

    public static ScopeType get(String literal) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScopeType result = VALUES_ARRAY[i];
            if (result.toString().equals(literal)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScopeType getByName(String name) {
        int i = 0;
        while (i < VALUES_ARRAY.length) {
            ScopeType result = VALUES_ARRAY[i];
            if (result.getName().equals(name)) {
                return result;
            }
            ++i;
        }
        return null;
    }

    public static ScopeType get(int value) {
        switch (value) {
            case 0: {
                return ROW_LITERAL;
            }
            case 1: {
                return COL_LITERAL;
            }
            case 2: {
                return ROWGROUP_LITERAL;
            }
            case 3: {
                return COLGROUP_LITERAL;
            }
        }
        return null;
    }

    private ScopeType(int value, String name, String literal) {
        super(value, name, literal);
    }
}

