/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.bridge.ihe;

import org.apache.log4j.Logger;
import org.apache.log4j.Priority;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.ohf.bridge.ServiceStarter;
import org.eclipse.ohf.bridge.conf.TransactionContext;
import org.eclipse.ohf.bridge.conf.XdsResourcesFactory;
import org.eclipse.ohf.bridge.ihe.IheXdsResourcesFactory;
import org.osgi.framework.BundleContext;

public class IheActivator
extends Plugin {
    public static final String PLUGIN_ID = "org.eclipse.ohf.bridge.ihii";
    static Logger mLogger;
    private static IheActivator plugin;
    private static final String[] DEPENDENT_BUNDLES;

    static {
        DEPENDENT_BUNDLES = new String[]{"org.eclipse.ohf.ihe.xds.consumer", "org.eclipse.ohf.ihe.xds.metadata", "org.eclipse.ohf.ihe.xds.metadata.extract", "org.eclipse.ohf.ihe.atna.audit", "org.eclipse.ohf.ihe.xds.soap", "org.eclipse.core.runtime", "org.eclipse.ohf.utilities", "org.eclipse.ohf.ihe.xds.metadata.transform", "org.eclipse.ohf.ihe.xds.source", "org.eclipse.ohf.ihe.common.cdar2", "org.eclipse.ohf.ihe.common.hl7v2", "org.eclipse.ohf.ihe.common.ebXML._2._1", "org.eclipse.ohf.ihe.common.ebXML._3._0"};
    }

    private void validateClassLoad() {
    }

    public IheActivator() {
        System.out.println("IHE Activator");
        plugin = this;
    }

    public void start(BundleContext context) throws Exception {
        try {
            super.start(context);
            mLogger = Logger.getLogger(IheActivator.class);
            TransactionContext.setXdsResourcesFactory((XdsResourcesFactory)new IheXdsResourcesFactory());
            if (mLogger.isDebugEnabled()) {
                mLogger.debug((Object)"started IHE Activator");
            }
            ServiceStarter.startDependentBundles((String[])DEPENDENT_BUNDLES);
            this.validateClassLoad();
        }
        catch (Throwable t) {
            t.printStackTrace();
            if (mLogger != null && mLogger.isEnabledFor(Priority.ERROR)) {
                mLogger.error((Object)"internal test failed, exiting application", t);
            }
            System.exit(1);
        }
    }

    public void stop(BundleContext context) throws Exception {
        plugin = null;
        super.stop(context);
        TransactionContext.setXdsResourcesFactory(null);
    }

    public static IheActivator getDefault() {
        return plugin;
    }
}

