/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPItem;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class CPCell
extends CPItem {
    private String name;
    private String dataType;
    private int length;
    private String table;
    private String fixedValue;
    private String[] dataValues;

    public CPCell(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.name = null;
        this.dataType = null;
        this.length = -1;
        this.table = null;
        this.fixedValue = null;
        this.dataValues = null;
    }

    public String getDataType() {
        return this.dataType;
    }

    public void setDataType(String dataType) {
        this.dataType = dataType;
    }

    public String[] getDataValues() {
        return this.dataValues;
    }

    public void setDataValues(String[] dataValues) {
        this.dataValues = dataValues;
    }

    public String getFixedValue() {
        return this.fixedValue;
    }

    public void setFixedValue(String fixedValue) {
        this.fixedValue = fixedValue;
    }

    public int getLength() {
        return this.length;
    }

    public void setLength(int length) {
        this.length = length;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getTable() {
        return this.table;
    }

    public void setTable(String table) {
        this.table = table;
    }

    public void addDataValue(String content) {
        if (this.dataValues == null) {
            this.dataValues = new String[]{content};
        } else {
            String[] newDataValues = new String[this.dataValues.length + 1];
            int i = 0;
            while (i < this.dataValues.length) {
                newDataValues[i] = this.dataValues[i];
                ++i;
            }
            newDataValues[this.dataValues.length] = content;
            this.dataValues = newDataValues;
        }
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 39, 40, 41, 42, 43});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 39: {
                return Integer.toString(this.getLength());
            }
            case 40: {
                return this.getDataValuesAsString();
            }
            case 41: {
                return this.getDataType();
            }
            case 42: {
                return this.getTable();
            }
            case 43: {
                return this.getFixedValue();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 39: {
                this.setLength(Integer.parseInt(value));
                break;
            }
            case 40: {
                this.setDataValuesAsString(value);
                break;
            }
            case 41: {
                this.setDataType(value);
                break;
            }
            case 42: {
                this.setTable(value);
                break;
            }
            case 43: {
                this.setFixedValue(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    private void setDataValuesAsString(String value) {
        String[] bits = value.split(",");
        this.dataValues = null;
        int i = 0;
        while (i < bits.length) {
            this.addDataValue(bits[i].trim());
            ++i;
        }
    }

    private String getDataValuesAsString() {
        if (this.dataValues == null) {
            return "";
        }
        String temp = this.dataValues[0];
        int i = 1;
        while (i < this.dataValues.length) {
            temp = String.valueOf(temp) + ", " + this.dataValues[i];
            ++i;
        }
        return temp;
    }

    public void defaults() {
        super.defaults();
        this.name = null;
        this.dataType = null;
        this.length = -1;
        this.table = null;
        this.fixedValue = null;
        this.dataValues = null;
    }

    public boolean hasLength() {
        return this.length > -1;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPCell src = (CPCell)source;
        this.name = src.name;
        this.dataType = src.dataType;
        this.length = src.length;
        this.table = src.table;
        this.fixedValue = src.fixedValue;
        this.dataValues = src.dataValues == null ? null : (String[])src.dataValues.clone();
    }

    public CPCell cloneCell() throws CloneNotSupportedException {
        return (CPCell)this.clone();
    }

    public boolean hasFixedValue() {
        return this.fixedValue != null && !this.fixedValue.equals("");
    }

    public boolean hasTable() {
        return this.table != null && !this.table.equals("");
    }
}

