/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPDynamicDefinition
extends CPElement {
    public static final int ACKNOWLEDGE_UNKNOWN = 0;
    public static final int ACKNOWLEDGE_ALWAYS = 1;
    public static final int ACKNOWLEDGE_NEVER = 2;
    public static final int ACKNOWLEDGE_SUCCESS = 3;
    public static final int ACKNOWLEDGE_ERROR = 4;
    public static final int ACKNOWLEDGE_MODE_UNKNOWN = 0;
    public static final int ACKNOWLEDGE_MODE_IMMEDIATE = 1;
    public static final int ACKNOWLEDGE_MODE_DEFERRED = 2;
    public static final int QUERY_TYPE_UNKNOWN = 0;
    public static final int QUERY_TYPE_NONQUERY = 1;
    public static final int QUERY_TYPE_QUERY = 2;
    public static final int QUERY_TYPE_RESPONSE = 3;
    public static final int QUERY_TYPE_PUBLISH = 4;
    public static final int QUERY_MODE_UNKNOWN = 0;
    public static final int QUERY_MODE_BATCH = 1;
    public static final int QUERY_MODE_REALTIME = 2;
    public static final int QUERY_MODE_BOTH = 3;
    private int acceptAcknowledgment;
    private int applicationAcknowledgment;
    private int acknowledgmentMode;
    private int queryType;
    private int queryMode;

    public CPDynamicDefinition(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.acceptAcknowledgment = 0;
        this.applicationAcknowledgment = 0;
        this.acknowledgmentMode = 0;
        this.queryType = 0;
        this.queryMode = 0;
    }

    public int getAcceptAcknowledgment() {
        return this.acceptAcknowledgment;
    }

    public void setAcceptAcknowledgment(int acceptAcknowledgment) {
        this.acceptAcknowledgment = acceptAcknowledgment;
    }

    public int getAcknowledgmentMode() {
        return this.acknowledgmentMode;
    }

    public void setAcknowledgmentMode(int acknowledgmentMode) {
        this.acknowledgmentMode = acknowledgmentMode;
    }

    public int getApplicationAcknowledgment() {
        return this.applicationAcknowledgment;
    }

    public void setApplicationAcknowledgment(int applicationAcknowledgment) {
        this.applicationAcknowledgment = applicationAcknowledgment;
    }

    public int getQueryMode() {
        return this.queryMode;
    }

    public void setQueryMode(int queryMode) {
        this.queryMode = queryMode;
    }

    public int getQueryType() {
        return this.queryType;
    }

    public void setQueryType(int queryType) {
        this.queryType = queryType;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{32, 33, 34, 35, 36});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 32: {
                return Integer.toString(this.getAcceptAcknowledgment());
            }
            case 33: {
                return Integer.toString(this.getApplicationAcknowledgment());
            }
            case 34: {
                return Integer.toString(this.getAcknowledgmentMode());
            }
            case 35: {
                return Integer.toString(this.getQueryType());
            }
            case 36: {
                return Integer.toString(this.getQueryMode());
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 32: {
                this.setAcceptAcknowledgment(Integer.parseInt(value));
                break;
            }
            case 33: {
                this.setApplicationAcknowledgment(Integer.parseInt(value));
                break;
            }
            case 34: {
                this.setAcknowledgmentMode(Integer.parseInt(value));
                break;
            }
            case 35: {
                this.setQueryType(Integer.parseInt(value));
                break;
            }
            case 36: {
                this.setQueryMode(Integer.parseInt(value));
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Dynamic Definition";
    }

    public void defaults() {
        super.defaults();
        this.acceptAcknowledgment = 2;
        this.applicationAcknowledgment = 1;
        this.acknowledgmentMode = 1;
        this.queryType = 1;
        this.queryMode = 0;
    }

    public int elementType() {
        return 8;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPDynamicDefinition src = (CPDynamicDefinition)source;
        this.acceptAcknowledgment = src.acceptAcknowledgment;
        this.applicationAcknowledgment = src.applicationAcknowledgment;
        this.acknowledgmentMode = src.acknowledgmentMode;
        this.queryType = src.queryType;
        this.queryMode = src.queryMode;
    }

    public CPDynamicDefinition cloneDynamicDefinition() throws CloneNotSupportedException {
        return (CPDynamicDefinition)this.clone();
    }
}

