/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPDescribed;
import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public abstract class CPItem
extends CPDescribed {
    private String predicate;
    private int usage;

    public CPItem(CPElement owner) {
        super(owner);
    }

    public void clear() {
        super.clear();
        this.predicate = null;
        this.usage = 0;
    }

    public String getPredicate() {
        return this.predicate;
    }

    public void setPredicate(String predicate) {
        this.predicate = predicate;
    }

    public int getUsage() {
        return this.usage;
    }

    public void setUsage(int usage) {
        this.usage = usage;
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{30, 10});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 30: {
                return this.getPredicate();
            }
            case 10: {
                return Integer.toString(this.getUsage());
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 30: {
                this.setPredicate(value);
                break;
            }
            case 10: {
                this.setUsage(Integer.parseInt(value));
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public void defaults() {
        super.defaults();
        this.predicate = null;
        this.usage = 3;
    }

    public CPItem cloneItem() throws CloneNotSupportedException {
        return (CPItem)this.clone();
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPItem src = (CPItem)source;
        this.predicate = src.predicate;
        this.usage = src.usage;
    }

    public boolean isRequired() {
        return this.usage == 1;
    }
}

