/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.conformance.model;

import org.eclipse.ohf.hl7v2.core.conformance.model.CPElement;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class CPUseCaseElement
extends CPElement {
    public static final int USE_CASE_ELEMENT_TYPE_UNKNOWN = 0;
    public static final int USE_CASE_ELEMENT_TYPE_ACTOR = 1;
    public static final int USE_CASE_ELEMENT_TYPE_PRECONDITION = 2;
    public static final int USE_CASE_ELEMENT_TYPE_POSTCONDITION = 3;
    public static final int USE_CASE_ELEMENT_TYPE_EVENTFLOW = 4;
    public static final int USE_CASE_ELEMENT_TYPE_DERIVEDEVENT = 5;
    private int type;
    private String name;
    private String value;

    public static String displayElementType(int value) {
        switch (value) {
            case 1: {
                return "Actor";
            }
            case 2: {
                return "Pre-Condition";
            }
            case 3: {
                return "Post-Condition";
            }
            case 4: {
                return "Event Flow";
            }
            case 5: {
                return "Derived Type";
            }
        }
        return "??";
    }

    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public CPUseCaseElement(CPElement owner) {
        super(owner);
    }

    public int[] getPropertyIds() {
        return this.mergeIds(super.getPropertyIds(), new int[]{1, 2, 3});
    }

    public String getProperty(int id) throws HL7V2Exception {
        switch (id) {
            case 1: {
                return this.getName();
            }
            case 2: {
                return Integer.toString(this.getType());
            }
            case 3: {
                return this.getValue();
            }
        }
        return super.getProperty(id);
    }

    public void setProperty(int id, String value) throws HL7V2Exception {
        switch (id) {
            case 1: {
                this.setName(value);
                break;
            }
            case 2: {
                this.setType(Integer.parseInt(value));
                break;
            }
            case 3: {
                this.setValue(value);
                break;
            }
            default: {
                super.setProperty(id, value);
            }
        }
    }

    public String getHumanType() {
        return "Use Case Element";
    }

    public void defaults() {
        super.defaults();
        this.type = 1;
        this.name = null;
        this.value = null;
    }

    public int elementType() {
        return 5;
    }

    public void assign(CPElement source) throws CloneNotSupportedException {
        super.assign(source);
        CPUseCaseElement src = (CPUseCaseElement)source;
        this.type = src.type;
        this.name = src.name;
        this.value = src.value;
    }

    public CPUseCaseElement cloneUseCaseElement() throws CloneNotSupportedException {
        return (CPUseCaseElement)this.clone();
    }
}

