/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.message.model;

import org.eclipse.ohf.hl7v2.core.message.ComposingOptions;
import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.message.model.ItemIterator;
import org.eclipse.ohf.hl7v2.core.message.model.ItemList;
import org.eclipse.ohf.hl7v2.core.message.model.Message;
import org.eclipse.ohf.hl7v2.core.message.model.Segment;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentGroup;
import org.eclipse.ohf.hl7v2.core.message.model.SegmentIterator;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;
import org.eclipse.ohf.hl7v2.core.utilities.SegmentGroupMapper;

public class SegmentList
extends ItemList {
    private static final long serialVersionUID = 6484199012424142549L;
    private SegmentGroup map = null;

    public SegmentList(Item owner, boolean owns) {
        super(owner, owns);
    }

    public void clear() {
        super.clear();
        this.dropMap();
    }

    public void dropMap() {
        this.map = null;
    }

    public Segment item(int index) {
        return (Segment)this.itemNode(index);
    }

    public int countByCode(String code) {
        int result = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.item(i).getCode().equals(code)) {
                ++result;
            }
            ++i;
        }
        return result;
    }

    public void dropByCode(String code) throws HL7V2Exception {
        int i = this.size() - 1;
        while (i >= 0) {
            if (this.item(i).getCode().equals(code)) {
                this.dropMap();
                this.remove(i);
            }
            --i;
        }
    }

    public Segment getByCodeAndIndex(String code, int index) {
        int count = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.item(i).getCode().equals(code)) {
                if (count == index - 1) {
                    return this.item(i);
                }
                ++count;
            }
            ++i;
        }
        return null;
    }

    public void add(Segment segment) throws HL7V2Exception {
        this.dropMap();
        super.add(segment);
    }

    public Segment add(String code) throws HL7V2Exception {
        Segment result = new Segment();
        result.setCode(code);
        this.add(result);
        result.buildFields();
        return result;
    }

    public void insert(Segment segment, int index) throws HL7V2Exception {
        this.dropMap();
        super.insert(segment, index);
    }

    public Segment insert(String code, int index) throws HL7V2Exception {
        Segment result = new Segment();
        result.setCode(code);
        this.insert(result, index);
        return result;
    }

    public void insert(Segment segment, Segment before) throws HL7V2Exception {
        this.insert(segment, this.indexOfItem(before));
    }

    public Segment insert(String code, Segment before) throws HL7V2Exception {
        return this.insert(code, this.indexOfItem(before));
    }

    public SegmentGroup getMap() {
        return this.map;
    }

    public int indexByCode(Segment segment) {
        int count = 0;
        int i = 0;
        while (i < this.size()) {
            if (this.item(i).getCode().equals(segment.getCode())) {
                if (this.item(i) == segment) {
                    return count;
                }
                ++count;
            }
            ++i;
        }
        return -1;
    }

    public void buildSegmentMap(ComposingOptions options) throws HL7V2Exception {
        this.dropMap();
        if (this.getOwner() != null && this.getOwner() instanceof Message) {
            SegmentGroupMapper mapper = new SegmentGroupMapper(options, (Message)this.getOwner());
            this.map = mapper.build();
        }
    }

    public SegmentIterator iteratorSegment() {
        return (SegmentIterator)this.makeIterator();
    }

    protected ItemIterator makeIterator() {
        return new SegmentIterator(this);
    }

    public void remove(int index) throws HL7V2Exception {
        this.dropMap();
        super.remove(index);
    }

    public void remove(Segment segment) throws HL7V2Exception {
        this.dropMap();
        super.remove(this.indexOfItem(segment));
    }
}

