/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ohf.hl7v2.core.validators;

import org.eclipse.ohf.hl7v2.core.message.model.Item;
import org.eclipse.ohf.hl7v2.core.utilities.HL7V2Exception;

public class ValidationItem {
    public static final int ITEM_TYPE_UNKNOWN = 0;
    public static final int ITEM_TYPE_INFORMATION = 1;
    public static final int ITEM_TYPE_WARNING = 2;
    public static final int ITEM_TYPE_ERROR = 3;
    public static final int ITEM_TYPE_FATAL = 4;
    private Item node;
    private int type;
    private int condition;
    private String message;

    public ValidationItem() {
    }

    public ValidationItem(Item node, int type, int condition, String message) {
        this.setNode(node);
        this.setType(type);
        this.setCondition(condition);
        this.setMessage(message);
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public Item getNode() {
        return this.node;
    }

    public void setNode(Item node) {
        this.node = node;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public int getCondition() {
        return this.condition;
    }

    public void setCondition(int condition) {
        this.condition = condition;
    }

    public CharSequence asText() throws HL7V2Exception {
        return String.valueOf(this.node.elementName()) + ": " + this.message;
    }
}

